/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import java.util.function.Consumer;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Subscription;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.ROS2TopicNameTools;

public class ROS2Callback<T> {
    private final Consumer<T> messageCallback;
    private ROS2Subscription<T> subscription;
    private volatile boolean enabled = true;

    public ROS2Callback(ROS2NodeInterface ros2Node, ROS2Topic<T> topicName, Consumer<T> messageCallback) {
        this(ros2Node, topicName.getType(), topicName, messageCallback);
    }

    public ROS2Callback(ROS2NodeInterface ros2Node, Class<T> messageType, ROS2Topic topicName, Consumer<T> messageCallback) {
        this(ros2Node, messageType, topicName.withTypeName(messageType).toString(), messageCallback);
    }

    public ROS2Callback(ROS2NodeInterface ros2Node, Class<T> messageType, String topicName, Consumer<T> messageCallback) {
        this.messageCallback = messageCallback;
        ExceptionTools.handle(() -> {
            this.subscription = ros2Node.createSubscription(ROS2TopicNameTools.newMessageTopicDataTypeInstance(messageType), this::nullOmissionCallback, topicName);
        }, (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
    }

    private void nullOmissionCallback(Subscriber<T> subscriber) {
        if (this.enabled) {
            Object incomingData = subscriber.takeNextData();
            if (incomingData != null) {
                this.messageCallback.accept(incomingData);
            } else {
                LogTools.warn((String)"Received null from takeNextData()");
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void destroy() {
        this.setEnabled(false);
        if (this.subscription != null) {
            this.subscription.remove();
        }
    }
}

