/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import us.ihmc.concurrent.ConcurrentRingBuffer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.ros2.NewMessageListener;

class RealtimeROS2SubscriptionListener<T>
implements NewMessageListener<T> {
    private final T data;
    private final ConcurrentRingBuffer<T> messageQueue;
    private final TopicDataType<T> topicDataTypeForCallback;
    private final TopicDataType<T> topicDataTypeForPoll;

    RealtimeROS2SubscriptionListener(TopicDataType<T> topicDataType, int queueDepth) {
        this.data = topicDataType.createData();
        this.messageQueue = new ConcurrentRingBuffer(() -> topicDataType.createData(), queueDepth);
        this.topicDataTypeForCallback = topicDataType.newInstance();
        this.topicDataTypeForPoll = topicDataType.newInstance();
    }

    boolean poll(T data) {
        if (this.messageQueue.poll()) {
            Object next = this.messageQueue.read();
            this.topicDataTypeForPoll.copy(next, data);
            this.messageQueue.flush();
            return true;
        }
        return false;
    }

    boolean flushAndGetLatest(T data) {
        if (this.messageQueue.poll()) {
            Object next;
            Object latest = null;
            while ((next = this.messageQueue.read()) != null) {
                latest = next;
            }
            this.topicDataTypeForPoll.copy(latest, data);
            this.messageQueue.flush();
            return true;
        }
        return false;
    }

    @Override
    public void onNewDataMessage(Subscriber<T> subscriber) {
        Object next;
        if (subscriber.takeNextData(this.data, null) && (next = this.messageQueue.next()) != null) {
            this.topicDataTypeForCallback.copy(this.data, next);
            this.messageQueue.commit();
        }
    }
}

