/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.QueuedROS2Subscription;
import us.ihmc.ros2.ROS2PublisherBasics;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Subscription;
import us.ihmc.ros2.SubscriptionMatchedListener;

public interface ROS2NodeInterface {
    public static final int DEFAULT_QUEUE_SIZE = 10;

    public static ParticipantAttributes createParticipantAttributes(int domainId, InetAddress ... addressRestriction) {
        ParticipantAttributes participantAttributes = ParticipantAttributes.create().domainId(domainId).discoveryLeaseDuration(Time.Infinite);
        if (addressRestriction != null && addressRestriction.length > 0 && addressRestriction[0] != null) {
            participantAttributes.bindToAddressRestrictions(true, Arrays.asList(addressRestriction));
        }
        return participantAttributes;
    }

    public static int domainFromEnvironment() {
        String rosDomainId = System.getenv("ROS_DOMAIN_ID");
        int rosDomainIdAsInteger = 0;
        if (rosDomainId != null) {
            rosDomainId = rosDomainId.trim();
            try {
                rosDomainIdAsInteger = Integer.parseInt(rosDomainId);
            }
            catch (NumberFormatException e) {
                LogTools.warn((String)"Environment variable ROS_DOMAIN_ID cannot be parsed as an integer: {}", (Object)rosDomainId);
            }
        }
        LogTools.info((String)"ROS_DOMAIN_ID from environment is {} (fallback only; ignore if set manually)", (Object)rosDomainIdAsInteger);
        return rosDomainIdAsInteger;
    }

    default public <T> ROS2PublisherBasics<T> createPublisher(TopicDataType<T> topicDataType, String topicName) throws IOException {
        return this.createPublisher(topicDataType, topicName, ROS2QosProfile.DEFAULT());
    }

    default public <T> ROS2PublisherBasics<T> createPublisher(TopicDataType<T> topicDataType, String topicName, ROS2QosProfile qosProfile) throws IOException {
        return this.createPublisher(topicDataType, this.createPublisherAttributes(topicDataType, topicName, qosProfile));
    }

    public <T> PublisherAttributes createPublisherAttributes(TopicDataType<T> var1, String var2, ROS2QosProfile var3);

    public <T> ROS2PublisherBasics<T> createPublisher(TopicDataType<T> var1, PublisherAttributes var2) throws IOException;

    default public <T> QueuedROS2Subscription<T> createQueuedSubscription(TopicDataType<T> topicDataType, String topicName) throws IOException {
        return this.createQueuedSubscription(topicDataType, topicName, ROS2QosProfile.DEFAULT(), 10);
    }

    default public <T> QueuedROS2Subscription<T> createQueuedSubscription(TopicDataType<T> topicDataType, String topicName, ROS2QosProfile qosProfile, int queueSize) throws IOException {
        return this.createQueuedSubscription(topicDataType, this.createSubscriberAttributes(topicName, topicDataType, qosProfile), queueSize);
    }

    public <T> QueuedROS2Subscription<T> createQueuedSubscription(TopicDataType<T> var1, SubscriberAttributes var2, int var3) throws IOException;

    default public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, NewMessageListener<T> newMessageListener, String topicName) throws IOException {
        return this.createSubscription(topicDataType, newMessageListener, topicName, ROS2QosProfile.DEFAULT());
    }

    default public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, NewMessageListener<T> newMessageListener, String topicName, ROS2QosProfile qosProfile) throws IOException {
        return this.createSubscription(topicDataType, newMessageListener, this.createSubscriberAttributes(topicName, topicDataType, qosProfile));
    }

    public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> var1, NewMessageListener<T> var2, SubscriberAttributes var3) throws IOException;

    default public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, final NewMessageListener<T> newMessageListener, final SubscriptionMatchedListener<T> subscriptionMatchedListener, String topicName, ROS2QosProfile qosProfile) throws IOException {
        return this.createSubscription(topicDataType, new NewMessageListener<T>(){

            @Override
            public void onNewDataMessage(Subscriber<T> subscriber) {
                newMessageListener.onNewDataMessage(subscriber);
            }

            @Override
            public void onSubscriptionMatched(Subscriber<T> subscriber, MatchingInfo info) {
                subscriptionMatchedListener.onSubscriptionMatched(subscriber, info);
            }
        }, this.createSubscriberAttributes(topicName, topicDataType, qosProfile));
    }

    public String getName();

    public String getNamespace();

    public <T> SubscriberAttributes createSubscriberAttributes(String var1, TopicDataType<T> var2, ROS2QosProfile var3);
}

