/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import us.ihmc.concurrent.ConcurrentRingBuffer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.ros2.ROS2Publisher;

public class QueuedROS2Publisher<T>
extends ROS2Publisher<T> {
    private final TopicDataType<T> topicDataType;
    private final ConcurrentRingBuffer<T> concurrentRingBuffer;

    QueuedROS2Publisher(TopicDataType<T> topicDataType, ROS2Publisher<T> rosPublisher, int queueDepth) {
        super(rosPublisher.getDomain(), rosPublisher.getPublisher());
        this.topicDataType = topicDataType.newInstance();
        this.concurrentRingBuffer = new ConcurrentRingBuffer(() -> topicDataType.createData(), queueDepth);
    }

    @Override
    public boolean publish(T data) {
        Object next = this.concurrentRingBuffer.next();
        if (next != null) {
            this.topicDataType.copy(data, next);
            this.concurrentRingBuffer.commit();
            return true;
        }
        return false;
    }

    void spin() {
        if (this.concurrentRingBuffer.poll()) {
            Object next;
            while ((next = this.concurrentRingBuffer.read()) != null) {
                super.publish(next);
            }
            this.concurrentRingBuffer.flush();
        }
    }

    @Override
    public void remove() {
    }
}

