/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.CommonAttributes;

public class ROS2TopicNameTools {
    public static final String ROS_TOPIC_PREFIX = "rt";
    public static final String pubSubTypeGetterName = "getPubSubType";

    public static String removeMessageOrPacketSuffixFromTypeName(Class<?> messageType) {
        return ROS2TopicNameTools.removeMessageOrPacketSuffixFromTypeName(messageType.getSimpleName());
    }

    public static String removeMessageOrPacketSuffixFromTypeName(String simpleTypeName) {
        String suffixRemoved = simpleTypeName;
        suffixRemoved = StringUtils.removeEnd((String)suffixRemoved, (String)"Packet");
        suffixRemoved = StringUtils.removeEnd((String)suffixRemoved, (String)"Message");
        return suffixRemoved;
    }

    public static String toROSTopicFormat(String pascalCased) {
        if (pascalCased == null) {
            return null;
        }
        if ((pascalCased = pascalCased.trim()).isEmpty()) {
            return pascalCased;
        }
        if (pascalCased.length() == 1) {
            return pascalCased.toLowerCase();
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean isNewWord = true;
        boolean isPreviousUpper = false;
        for (int charIndex = 0; charIndex < pascalCased.length(); ++charIndex) {
            boolean isCharUpper = Character.isUpperCase(pascalCased.charAt(charIndex));
            if (charIndex == 0 || !isCharUpper) {
                isNewWord = false;
            } else if (!isPreviousUpper) {
                isNewWord = true;
            } else {
                int nextIndex = charIndex + 1;
                boolean isNextUpper = nextIndex == pascalCased.length() || Character.isUpperCase(pascalCased.charAt(nextIndex));
                isNewWord = !isNextUpper;
            }
            isPreviousUpper = isCharUpper;
            if (isNewWord) {
                stringBuilder.append("_");
            }
            stringBuilder.append(Character.toLowerCase(pascalCased.charAt(charIndex)));
        }
        return stringBuilder.toString();
    }

    static void assignNameAndPartitionsToAttributes(CommonAttributes<?> attributes, String namespace, String nodeName, String topic, boolean avoidRosNamespace) {
        if (avoidRosNamespace) {
            attributes.topicName(topic);
            if (namespace != null && !namespace.isEmpty()) {
                attributes.partitions(Arrays.asList(namespace));
            }
        } else {
            String fullyQualifiedName = ROS2TopicNameTools.getFullyQualifiedName(namespace, nodeName, topic);
            attributes.topicName(fullyQualifiedName);
        }
    }

    private static String getFullyQualifiedName(String namespace, String nodeName, String topic) {
        if (((String)topic).startsWith("~/")) {
            topic = nodeName + ((String)topic).substring(1);
        } else if (((String)topic).equals("~")) {
            topic = nodeName;
        }
        ROS2TopicNameTools.checkTopicName((String)topic);
        ROS2TopicNameTools.checkNamespace(namespace);
        ROS2TopicNameTools.checkNodename(nodeName);
        String fullyQualifiedName = ((String)topic).startsWith("/") ? ROS_TOPIC_PREFIX + (String)topic : ROS_TOPIC_PREFIX + namespace + "/" + (String)topic;
        return fullyQualifiedName;
    }

    static void checkNodename(String nodename) {
        if (nodename.isEmpty()) {
            throw new RuntimeException("Invalid node name: node name must not be empty string");
        }
        if (nodename.matches("^.*[^a-zA-Z0-9_].*$")) {
            throw new RuntimeException("Invalid node name: node name must not contain characters other than alphanumerics and '_': " + nodename);
        }
    }

    static void checkNamespace(String namespace) {
        if (namespace.isEmpty()) {
            return;
        }
        if (namespace.endsWith("/")) {
            throw new RuntimeException("Invalid namespace: namespace must not end with a forward slash: " + namespace);
        }
        if (!namespace.startsWith("/")) {
            throw new RuntimeException("Invalid namespace: namespace must start with a forward slash: " + namespace);
        }
        if (namespace.matches("^[0-9].*$")) {
            throw new RuntimeException("Invalid namespace: namespace token must not start with a number: " + namespace);
        }
        if (namespace.matches("^.*[^a-zA-Z0-9_/].*$")) {
            throw new RuntimeException("Invalid namespace: namespace must not contain characters other than alphanumerics, '_', '~': " + namespace);
        }
    }

    private static void checkTopicName(String topic) {
        if (topic.isEmpty()) {
            throw new RuntimeException("Invalid topic name: topic name must not be empty string");
        }
        if (topic.contains("~")) {
            throw new RuntimeException("Invalid topic name: topic name must not have tilde '~' unless it is the first character and followed by a slash '/': " + topic);
        }
        if (topic.endsWith("/")) {
            throw new RuntimeException("Invalid topic name: topic name must not end with a forward slash: " + topic);
        }
        if (topic.matches("^[0-9].*$")) {
            throw new RuntimeException("Invalid topic name: topic name token must not start with a number: " + topic);
        }
        if (topic.matches("^.*[^a-zA-Z0-9_/].*$")) {
            throw new RuntimeException("Invalid topic name: topic name must not contain characters other than alphanumerics, '_', '~': " + topic);
        }
    }

    public static <T> T newMessageInstance(Class<T> messageType) {
        try {
            return messageType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Something went wrong when invoking " + messageType.getSimpleName() + "'s empty constructor.", e);
        }
    }

    public static <T> TopicDataType<T> newMessageTopicDataTypeInstance(Class<T> messageType) {
        TopicDataType topicDataType;
        Method pubSubTypeGetter;
        try {
            pubSubTypeGetter = messageType.getDeclaredMethod(pubSubTypeGetterName, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Something went wrong when looking up for the method " + messageType.getSimpleName() + ".getPubSubType().", e);
        }
        try {
            topicDataType = (TopicDataType)((Supplier)pubSubTypeGetter.invoke(ROS2TopicNameTools.newMessageInstance(messageType), new Object[0])).get();
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Something went wrong when invoking the method " + messageType.getSimpleName() + ".getPubSubType().", e);
        }
        return topicDataType;
    }

    public static String messageTypeToTopicNamePart(Class<?> messageType) {
        if (messageType == null) {
            return "";
        }
        String messageTypePart = ROS2TopicNameTools.removeMessageOrPacketSuffixFromTypeName(messageType);
        return ROS2TopicNameTools.processTopicNamePart(ROS2TopicNameTools.toROSTopicFormat(messageTypePart));
    }

    public static String processTopicNamePart(String string) {
        if (string == null) {
            return "";
        }
        if (((String)(string = ((String)string).trim().toLowerCase())).isEmpty()) {
            return "";
        }
        if (!((String)string).startsWith("/")) {
            string = "/" + (String)string;
        }
        return string;
    }

    public static String titleCasedToUnderscoreCased(String titleCased) {
        return titleCased.trim().toLowerCase().replaceAll("\\s+", "_");
    }
}

