/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosKindType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosKindType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindType;

public class ROS2QosProfile {
    private HistoryQosKindType history = HistoryQosKindType.KEEP_LAST;
    private int depth = 1;
    private ReliabilityQosKindType reliability = ReliabilityQosKindType.RELIABLE;
    private RosDurability durability = RosDurability.VOLATILE;
    private boolean avoidRosNamespaceConventions = false;

    public static ROS2QosProfile DEFAULT() {
        return new ROS2QosProfile();
    }

    public static final ROS2QosProfile KEEP_HISTORY(int depth) {
        return new ROS2QosProfile(HistoryQosKindType.KEEP_LAST, depth, ReliabilityQosKindType.RELIABLE, RosDurability.TRANSIENT_LOCAL, false);
    }

    public static final ROS2QosProfile BEST_EFFORT() {
        return new ROS2QosProfile(HistoryQosKindType.KEEP_LAST, 1, ReliabilityQosKindType.BEST_EFFORT, RosDurability.VOLATILE, false);
    }

    public ROS2QosProfile() {
    }

    public ROS2QosProfile(HistoryQosKindType history, int depth, ReliabilityQosKindType reliability, RosDurability durability, boolean avoidRosNamespaceConventions) {
        this();
        this.history = history;
        this.depth = depth;
        this.reliability = reliability;
        this.durability = durability;
        this.avoidRosNamespaceConventions = avoidRosNamespaceConventions;
    }

    public HistoryQosKindType getHistory() {
        return this.history;
    }

    public void setHistory(HistoryQosKindType history) {
        this.history = history;
    }

    public int getSize() {
        return this.depth;
    }

    public void setSize(int depth) {
        this.depth = depth;
    }

    public ReliabilityQosKindType getReliability() {
        return this.reliability;
    }

    public void setReliability(ReliabilityQosKindType reliability) {
        this.reliability = reliability;
    }

    public RosDurability getDurability() {
        return this.durability;
    }

    public void setDurability(RosDurability durability) {
        this.durability = durability;
    }

    public boolean isAvoidRosNamespaceConventions() {
        return this.avoidRosNamespaceConventions;
    }

    public void setAvoidRosNamespaceConventions(boolean avoidRosNamespaceConventions) {
        this.avoidRosNamespaceConventions = avoidRosNamespaceConventions;
    }

    public static enum RosDurability {
        VOLATILE,
        TRANSIENT_LOCAL;


        public DurabilityQosKindType toKind() {
            switch (this) {
                case VOLATILE: {
                    return DurabilityQosKindType.VOLATILE;
                }
                case TRANSIENT_LOCAL: {
                    return DurabilityQosKindType.TRANSIENT_LOCAL;
                }
            }
            throw new RuntimeException("Unreachable code");
        }
    }
}

