/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import java.io.IOException;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.ros2.ROS2PublisherBasics;

public class ROS2Publisher<T>
implements ROS2PublisherBasics<T> {
    private final Domain domain;
    private final Publisher publisher;

    ROS2Publisher(Domain domain, Publisher publisher) {
        this.domain = domain;
        this.publisher = publisher;
    }

    @Override
    public boolean publish(T data) {
        try {
            if (this.publisher.isAvailable()) {
                this.publisher.write(data);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void remove() {
        this.domain.removePublisher(this.publisher);
    }

    Publisher getPublisher() {
        return this.publisher;
    }

    Domain getDomain() {
        return this.domain;
    }
}

