/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import java.io.IOException;
import us.ihmc.concurrent.ConcurrentRingBuffer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2PublisherBasics;

public class RealtimeROS2Publisher<T>
implements ROS2PublisherBasics<T> {
    private final TopicDataType<T> topicDataType;
    private final ROS2Publisher<T> rosPublisher;
    private final ConcurrentRingBuffer<T> concurrentRingBuffer;

    RealtimeROS2Publisher(TopicDataType<T> topicDataType, ROS2Publisher<T> rosPublisher, int queueDepth) {
        this.topicDataType = topicDataType.newInstance();
        this.rosPublisher = rosPublisher;
        this.concurrentRingBuffer = new ConcurrentRingBuffer(() -> topicDataType.createData(), queueDepth);
    }

    @Override
    public boolean publish(T data) {
        Object next = this.concurrentRingBuffer.next();
        if (next != null) {
            this.topicDataType.copy(data, next);
            this.concurrentRingBuffer.commit();
            return true;
        }
        return false;
    }

    void spin() {
        if (this.concurrentRingBuffer.poll()) {
            Object next;
            while ((next = this.concurrentRingBuffer.read()) != null) {
                try {
                    this.rosPublisher.publish(next);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.concurrentRingBuffer.flush();
        }
    }

    @Override
    public void remove() {
    }
}

