/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.ROS2Distro;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeBasics;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2PublisherBasics;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Subscription;
import us.ihmc.ros2.RealtimeROS2Publisher;
import us.ihmc.ros2.RealtimeROS2Subscription;
import us.ihmc.ros2.RealtimeROS2SubscriptionListener;
import us.ihmc.ros2.SubscriptionMatchedListener;
import us.ihmc.util.PeriodicThreadScheduler;
import us.ihmc.util.PeriodicThreadSchedulerFactory;

public class RealtimeROS2Node
implements ROS2NodeInterface {
    public static int THREAD_PERIOD_MICROSECONDS = 1000;
    public static final int DEFAULT_QUEUE_SIZE = 10;
    private final ROS2NodeBasics node;
    private final ArrayList<RealtimeROS2Publisher<?>> publishers = new ArrayList();
    private final ReentrantLock startupLock = new ReentrantLock();
    private final PeriodicThreadScheduler scheduler;
    private boolean spinning = false;

    public RealtimeROS2Node(DomainFactory.PubSubImplementation pubSubImplementation, PeriodicThreadSchedulerFactory threadFactory, String name, String namespace) throws IOException {
        this(pubSubImplementation, threadFactory, name, namespace, ROS2NodeBasics.ROS_DEFAULT_DOMAIN_ID);
    }

    public RealtimeROS2Node(DomainFactory.PubSubImplementation pubSubImplementation, ROS2Distro ros2Distro, PeriodicThreadSchedulerFactory threadFactory, String name, String namespace) throws IOException {
        this(pubSubImplementation, ros2Distro, threadFactory, name, namespace, ROS2NodeBasics.ROS_DEFAULT_DOMAIN_ID);
    }

    public RealtimeROS2Node(DomainFactory.PubSubImplementation pubSubImplementation, PeriodicThreadSchedulerFactory threadFactory, String name, String namespace, int domainId) throws IOException {
        this(pubSubImplementation, ROS2Distro.fromEnvironment(), threadFactory, name, namespace, domainId);
    }

    public RealtimeROS2Node(DomainFactory.PubSubImplementation pubSubImplementation, ROS2Distro ros2Distro, PeriodicThreadSchedulerFactory threadFactory, String name, String namespace, int domainId) throws IOException {
        this(pubSubImplementation, ros2Distro, threadFactory, name, namespace, domainId, null);
    }

    public RealtimeROS2Node(DomainFactory.PubSubImplementation pubSubImplementation, ROS2Distro ros2Distro, PeriodicThreadSchedulerFactory threadFactory, String name, String namespace, int domainId, InetAddress addressRestriction) throws IOException {
        this.node = new ROS2NodeBasics(pubSubImplementation, ros2Distro, name, namespace, domainId, addressRestriction);
        this.scheduler = threadFactory.createPeriodicThreadScheduler("RealtimeNode_" + namespace + "/" + name);
    }

    public RealtimeROS2Node(ROS2Node ros2Node, PeriodicThreadSchedulerFactory threadFactory) {
        this.node = ros2Node;
        this.scheduler = threadFactory.createPeriodicThreadScheduler("RealtimeNode_" + this.node.getName() + "/" + this.node.getNamespace());
    }

    public <T> RealtimeROS2Publisher<T> createPublisher(TopicDataType<T> topicDataType, String topicName) throws IOException {
        return this.createPublisher((TopicDataType)topicDataType, topicName, ROS2QosProfile.DEFAULT());
    }

    public <T> RealtimeROS2Publisher<T> createPublisher(TopicDataType<T> topicDataType, String topicName, ROS2QosProfile qosProfile) throws IOException {
        return this.createPublisher(topicDataType, topicName, qosProfile, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> RealtimeROS2Publisher<T> createPublisher(TopicDataType<T> topicDataType, String topicName, ROS2QosProfile qosProfile, int queueSize) throws IOException {
        this.startupLock.lock();
        try {
            if (this.spinning) {
                throw new RuntimeException("Cannot add publishers to a RealtimeROS2Node that is already spinning");
            }
            ROS2PublisherBasics rosPublisher = this.node.createPublisher((TopicDataType)topicDataType, topicName, qosProfile);
            RealtimeROS2Publisher<T> realtimePublisher = new RealtimeROS2Publisher<T>(topicDataType, rosPublisher, queueSize);
            this.publishers.add(realtimePublisher);
            RealtimeROS2Publisher<T> realtimeROS2Publisher = realtimePublisher;
            return realtimeROS2Publisher;
        }
        finally {
            this.startupLock.unlock();
        }
    }

    public <T> RealtimeROS2Subscription<T> createQueuedSubscription(TopicDataType<T> topicDataType, String topicName) throws IOException {
        return this.createQueuedSubscription((TopicDataType)topicDataType, topicName, ROS2QosProfile.DEFAULT(), 10);
    }

    public <T> RealtimeROS2Subscription<T> createQueuedSubscription(TopicDataType<T> topicDataType, String topicName, ROS2QosProfile qosProfile, int queueSize) throws IOException {
        RealtimeROS2SubscriptionListener<T> listener = new RealtimeROS2SubscriptionListener<T>(topicDataType, queueSize);
        this.node.createSubscription(topicDataType, listener, topicName, qosProfile);
        RealtimeROS2Subscription<T> subscription = new RealtimeROS2Subscription<T>(listener);
        return subscription;
    }

    @Override
    public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, NewMessageListener<T> newMessageListener, String topicName) throws IOException {
        this.node.createSubscription(topicDataType, newMessageListener, topicName);
        return new RealtimeROS2Subscription(null);
    }

    @Override
    public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, NewMessageListener<T> newMessageListener, String topicName, ROS2QosProfile qosProfile) throws IOException {
        this.node.createSubscription(topicDataType, newMessageListener, topicName, qosProfile);
        return new RealtimeROS2Subscription(null);
    }

    @Override
    public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, NewMessageListener<T> newMessageListener, SubscriptionMatchedListener<T> subscriptionMatchedListener, String topicName, ROS2QosProfile qosProfile) throws IOException {
        this.node.createSubscription(topicDataType, newMessageListener, subscriptionMatchedListener, topicName, qosProfile);
        return new RealtimeROS2Subscription(null);
    }

    public <T> void createCallbackSubscription(TopicDataType<T> topicDataType, String topicName, NewMessageListener<T> newMessageListener) throws IOException {
        this.node.createSubscription(topicDataType, newMessageListener, topicName);
    }

    public <T> void createCallbackSubscription(TopicDataType<T> topicDataType, String topicName, NewMessageListener<T> newMessageListener, ROS2QosProfile qosProfile) throws IOException {
        this.node.createSubscription(topicDataType, newMessageListener, topicName, qosProfile);
    }

    public void spin() {
        this.startupLock.lock();
        if (this.spinning) {
            this.startupLock.unlock();
            throw new RuntimeException("This RealtimeROS2Node is already spinning");
        }
        this.spinning = true;
        this.scheduler.schedule(this::realtimeNodeThread, (long)THREAD_PERIOD_MICROSECONDS, TimeUnit.MICROSECONDS);
        this.startupLock.unlock();
    }

    private void realtimeNodeThread() {
        for (int i = 0; i < this.publishers.size(); ++i) {
            this.publishers.get(i).spin();
        }
    }

    public void stopSpinning() {
        this.scheduler.shutdown();
        this.startupLock.lock();
        this.spinning = false;
    }

    public void destroy() {
        if (this.spinning) {
            this.stopSpinning();
        }
        this.node.destroy();
    }

    @Override
    public String getName() {
        return this.node.getName();
    }

    @Override
    public String getNamespace() {
        return this.node.getNamespace();
    }
}

