/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2.example;

import java.io.IOException;
import java.util.Random;
import org.junit.jupiter.api.Test;
import ros_msgs.msg.dds.BigNumSequence;
import ros_msgs.msg.dds.BigNumSequencePubSubType;
import ros_msgs.msg.dds.Num;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.ros2.QueuedROS2Subscription;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.util.PeriodicNonRealtimeThreadSchedulerFactory;
import us.ihmc.util.PeriodicRealtimeThreadSchedulerFactory;
import us.ihmc.util.PeriodicThreadSchedulerFactory;

public class RealtimeROS2IntraprocessCopyTest {
    public static final int NUMBER_OF_MESSAGES_TO_SEND = 20;
    private static final boolean RUN_USING_REALTIME_THREAD = Boolean.parseBoolean(System.getProperty("realtime"));

    @Test
    public void testIntraprocessCopy() throws IOException, InterruptedException {
        Random random = new Random(892141240123L);
        PeriodicRealtimeThreadSchedulerFactory threadFactory = RUN_USING_REALTIME_THREAD ? new PeriodicRealtimeThreadSchedulerFactory(20) : new PeriodicNonRealtimeThreadSchedulerFactory();
        RealtimeROS2Node node = new RealtimeROS2Node(DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.INTRAPROCESS), (PeriodicThreadSchedulerFactory)threadFactory, "RealtimeROS2IntraprocessCopyTest", "/us/ihmc");
        ROS2Publisher publisher = node.createPublisher((TopicDataType)new BigNumSequencePubSubType(), "/example");
        QueuedROS2Subscription subscription = node.createQueuedSubscription((TopicDataType)new BigNumSequencePubSubType(), "/example");
        node.spin();
        for (int i = 0; i < 20; ++i) {
            BigNumSequence message = new BigNumSequence();
            Num e = new Num();
            int randomSize = random.nextInt(10000);
            for (int j = 0; j < randomSize; ++j) {
                e.setDoubleTest((double)(i + j));
                ((Num)message.getLargeSequence().add()).set(e);
            }
            publisher.publish((Object)message);
            System.out.println("Sending: " + i + " sendSize: " + message.getLargeSequence().size());
        }
        BigNumSequence incomingMessage = new BigNumSequence();
        while (!subscription.poll((Object)incomingMessage)) {
        }
        int i = 1;
        while (i < 10) {
            if (!subscription.poll((Object)incomingMessage)) continue;
            System.out.println("Receiving: " + i + " copiedSize: " + incomingMessage.getLargeSequence().size());
            ++i;
        }
    }
}

