/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2.example;

import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Test;
import ros_msgs.msg.dds.Num;
import ros_msgs.msg.dds.NumPubSubType;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.robotics.Assert;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Publisher;

public class DataTypesTest {
    @Test
    public void testAllDoubleValuesGetAcross() {
        MutablePair messagesReceived = new MutablePair();
        int NUMBER_OF_MESSAGES_TO_SEND = 10;
        try {
            ROS2Node node = new ROS2Node(DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.INTRAPROCESS), "ROS2CommunicationTest");
            NumPubSubType topicDataType = new NumPubSubType();
            ROS2Publisher publisher = node.createPublisher((TopicDataType)topicDataType, "/chatter");
            messagesReceived.setValue((Object)0);
            node.createSubscription((TopicDataType)topicDataType, arg_0 -> DataTypesTest.lambda$testAllDoubleValuesGetAcross$0((Pair)messagesReceived, arg_0), "/chatter");
            for (int i = 0; i < NUMBER_OF_MESSAGES_TO_SEND; ++i) {
                Num message = new Num();
                switch (i) {
                    case 0: {
                        message.setDoubleTest(Double.NaN);
                        break;
                    }
                    case 1: {
                        message.setDoubleTest(Double.MAX_VALUE);
                        break;
                    }
                    case 2: {
                        message.setDoubleTest(Double.MIN_VALUE);
                        break;
                    }
                    case 3: {
                        message.setDoubleTest(1023.0);
                        break;
                    }
                    case 4: {
                        message.setDoubleTest(-1022.0);
                        break;
                    }
                    case 5: {
                        message.setDoubleTest(Double.MIN_NORMAL);
                        break;
                    }
                    case 6: {
                        message.setDoubleTest(Double.POSITIVE_INFINITY);
                        break;
                    }
                    case 7: {
                        message.setDoubleTest(Double.NEGATIVE_INFINITY);
                        break;
                    }
                }
                System.out.println("Publishing: " + message.getDoubleTest());
                publisher.publish((Object)message);
                System.out.println("Published: " + message.getDoubleTest());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while ((Integer)messagesReceived.getValue() < NUMBER_OF_MESSAGES_TO_SEND) {
            Thread.yield();
        }
        Assert.assertEquals("all messages not received", NUMBER_OF_MESSAGES_TO_SEND, ((Integer)messagesReceived.getValue()).intValue());
    }

    private static /* synthetic */ void lambda$testAllDoubleValuesGetAcross$0(Pair messagesReceived, Subscriber subscriber) {
        Num message = new Num();
        System.out.println("Incoming message...");
        if (subscriber.takeNextData((Object)message, new SampleInfo())) {
            switch ((Integer)messagesReceived.getValue()) {
                case 0: {
                    Assert.assertEquals("Wasn't NaN", Double.NaN, message.getDoubleTest(), 0.0);
                    break;
                }
                case 1: {
                    Assert.assertEquals("Wasn't MAX_VALUE", Double.MAX_VALUE, message.getDoubleTest(), 0.0);
                    break;
                }
                case 2: {
                    Assert.assertEquals("Wasn't MIN_VALUE", Double.MIN_VALUE, message.getDoubleTest(), 0.0);
                    break;
                }
                case 3: {
                    Assert.assertEquals("Wasn't MAX_EXPONENT", 1023.0, message.getDoubleTest(), 0.0);
                    break;
                }
                case 4: {
                    Assert.assertEquals("Wasn't MIN_EXPONENT", -1022.0, message.getDoubleTest(), 0.0);
                    break;
                }
                case 5: {
                    Assert.assertEquals("Wasn't MIN_NORMAL", Double.MIN_NORMAL, message.getDoubleTest(), 0.0);
                    break;
                }
                case 6: {
                    Assert.assertEquals("Wasn't POSITIVE_INFINITY", Double.POSITIVE_INFINITY, message.getDoubleTest(), 0.0);
                    break;
                }
                case 7: {
                    Assert.assertEquals("Wasn't NEGATIVE_INFINITY", Double.NEGATIVE_INFINITY, message.getDoubleTest(), 0.0);
                    break;
                }
            }
            System.out.println("Received: " + message.getDoubleTest());
            messagesReceived.setValue((Object)((Integer)messagesReceived.getValue() + 1));
        }
    }
}

