/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import java.time.Duration;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import ros_msgs.msg.dds.TwoNum;
import ros_msgs.msg.dds.TwoNumPubSubType;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.ros2.QueuedROS2Subscription;
import us.ihmc.ros2.ROS2Distro;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.util.PeriodicNonRealtimeThreadScheduler;

public class CommunicationTest {
    @Test
    public void testSimpleIntraProcessCommunication() {
        this.testSimpleCommunication(DomainFactory.PubSubImplementation.INTRAPROCESS, null);
    }

    @Test
    public void testSimpleRealRTPSCommunicationDefaultRosVersion() {
        this.testSimpleCommunication(DomainFactory.PubSubImplementation.FAST_RTPS, null);
    }

    @Test
    public void testSimpleRealRTPSCommunicationArdent() {
        this.testSimpleCommunication(DomainFactory.PubSubImplementation.FAST_RTPS, ROS2Distro.ARDENT);
    }

    @Test
    public void testSimpleRealRTPSCommunicationBouncy() {
        this.testSimpleCommunication(DomainFactory.PubSubImplementation.FAST_RTPS, ROS2Distro.BOUNCY);
    }

    private void testSimpleCommunication(DomainFactory.PubSubImplementation pubSubImplementation, ROS2Distro ros2Distro) {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            MutablePair messagesReceived = new MutablePair();
            try {
                String name = "ROS2CommunicationTest";
                ROS2Node node = ros2Distro == null ? new ROS2Node(pubSubImplementation, name) : new ROS2Node(pubSubImplementation, ros2Distro, name);
                TwoNumPubSubType topicDataType = new TwoNumPubSubType();
                ROS2Publisher publisher = node.createPublisher((TopicDataType)topicDataType, "/chatter");
                messagesReceived.setValue((Object)0);
                node.createSubscription((TopicDataType)topicDataType, arg_0 -> CommunicationTest.lambda$testSimpleCommunication$0((Pair)messagesReceived, arg_0), "/chatter");
                for (int i = 0; i < 11; ++i) {
                    TwoNum message = new TwoNum();
                    message.getStr1().append("Hello world: " + i);
                    System.out.println("Publishing: " + message.getStr1());
                    publisher.publish((Object)message);
                    System.out.println("Published: " + message.getStr1());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            while ((Integer)messagesReceived.getValue() < 5) {
                Thread.yield();
            }
        });
    }

    @Test
    public void testSimpleRealRTPSCommunicationAndDestroy() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            MutablePair messagesReceived = new MutablePair();
            try {
                ROS2Node node = new ROS2Node(DomainFactory.PubSubImplementation.FAST_RTPS, "ROS2CommunicationTest");
                TwoNumPubSubType topicDataType = new TwoNumPubSubType();
                ROS2Publisher publisher = node.createPublisher((TopicDataType)topicDataType, "/chatter");
                messagesReceived.setValue((Object)0);
                node.createSubscription((TopicDataType)topicDataType, arg_0 -> CommunicationTest.lambda$testSimpleRealRTPSCommunicationAndDestroy$2((Pair)messagesReceived, arg_0), "/chatter");
                for (int i = 0; i < 11; ++i) {
                    TwoNum message = new TwoNum();
                    message.getStr1().append("Hello world: " + i);
                    System.out.println("Publishing: " + message.getStr1());
                    publisher.publish((Object)message);
                    System.out.println("Published: " + message.getStr1());
                }
                ThreadTools.sleepSeconds((double)1.0);
                node.destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            while ((Integer)messagesReceived.getValue() < 5) {
                Thread.yield();
            }
        });
    }

    @Test
    public void testSimpleIntraProcessCommunicationRealtime() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            MutablePair messagesReceived = new MutablePair();
            try {
                RealtimeROS2Node node = new RealtimeROS2Node(DomainFactory.PubSubImplementation.INTRAPROCESS, PeriodicNonRealtimeThreadScheduler::new, "ROS2CommunicationTest", "/us/ihmc");
                TwoNumPubSubType topicDataType = new TwoNumPubSubType();
                ROS2Publisher publisher = node.createPublisher((TopicDataType)topicDataType, "/chatter");
                messagesReceived.setValue((Object)0);
                QueuedROS2Subscription subscription = node.createQueuedSubscription((TopicDataType)topicDataType, "/chatter");
                node.spin();
                for (int i = 0; i < 11; ++i) {
                    TwoNum message = new TwoNum();
                    message.getStr1().append("Hello world: " + i);
                    System.out.println("Publishing: " + message.getStr1());
                    boolean success = publisher.publish((Object)message);
                    System.out.println("Published: success: " + success + " content: " + message.getStr1());
                }
                TwoNum incomingMessage = new TwoNum();
                while (!subscription.poll((Object)incomingMessage)) {
                }
                System.out.println("Received: " + incomingMessage.getStr1());
                messagesReceived.setValue((Object)((Integer)messagesReceived.getValue() + 1));
                while ((Integer)messagesReceived.getValue() < 10) {
                    boolean pollSuccess = subscription.poll((Object)incomingMessage);
                    if (pollSuccess) {
                        System.out.println("Received: " + incomingMessage.getStr1());
                        messagesReceived.setValue((Object)((Integer)messagesReceived.getValue() + 1));
                        continue;
                    }
                    System.out.println("No messages in queue.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static /* synthetic */ void lambda$testSimpleRealRTPSCommunicationAndDestroy$2(Pair messagesReceived, Subscriber subscriber) {
        TwoNum message = new TwoNum();
        System.out.println("Incoming message...");
        if (subscriber.takeNextData((Object)message, null)) {
            System.out.println("Received: " + message.getStr1());
            messagesReceived.setValue((Object)((Integer)messagesReceived.getValue() + 1));
        }
    }

    private static /* synthetic */ void lambda$testSimpleCommunication$0(Pair messagesReceived, Subscriber subscriber) {
        TwoNum message = new TwoNum();
        System.out.println("Incoming message...");
        if (subscriber.takeNextData((Object)message, null)) {
            System.out.println("Received: " + message.getStr1());
            messagesReceived.setValue((Object)((Integer)messagesReceived.getValue() + 1));
        }
    }
}

