/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.utilities.ros;

import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import sensor_msgs.PointCloud2;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.graphicsDescription.color.MutableColor;
import us.ihmc.robotics.Assert;
import us.ihmc.utilities.ros.IHMCRosTestWithRosCore;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.publisher.RosPointCloudPublisher;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;
import us.ihmc.utilities.ros.subscriber.RosPointCloudSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;
import us.ihmc.utilities.ros.types.PointType;

@Disabled
public class RosPointCloudPublisherSubscriberTest
extends IHMCRosTestWithRosCore {
    @Test
    public void testPubSubSinglePointXYZICloud() throws URISyntaxException, InterruptedException {
        this.testPubSubSingleCloud(PointType.XYZI);
    }

    @Test
    public void testPubSubSinglePointXYZRGBCloud() throws URISyntaxException, InterruptedException {
        this.testPubSubSingleCloud(PointType.XYZRGB);
    }

    private void testPubSubSingleCloud(final PointType testPointType) throws URISyntaxException, InterruptedException {
        RosMainNode rosMainNode = new RosMainNode(this.rosMasterURI, "topicClientTestNode");
        String testTopic = "/cloudTest";
        String testFrameId = "/testFrame";
        final Point3D[] testPoints = new Point3D[]{new Point3D(1.0, 2.0, 3.0)};
        final float[] testIntensities = new float[]{1.0f};
        final MutableColor[] testColor = new MutableColor[]{new MutableColor(1.0f, 2.0f, 3.0f)};
        RosPointCloudPublisher publisher = new RosPointCloudPublisher(testPointType, true);
        rosMainNode.attachPublisher(testTopic, (RosTopicPublisher)publisher);
        final CountDownLatch latch = new CountDownLatch(1);
        RosPointCloudSubscriber subscriber = new RosPointCloudSubscriber(){

            public void onNewMessage(PointCloud2 pointCloud) {
                RosPointCloudSubscriber.UnpackedPointCloud unpackedCloud = RosPointCloudSubscriber.unpackPointsAndIntensities((PointCloud2)pointCloud);
                Assert.assertEquals((Object)testPointType, (Object)unpackedCloud.getPointType());
                Assert.assertArrayEquals((Object[])testPoints, (Object[])unpackedCloud.getPoints());
                switch (unpackedCloud.getPointType()) {
                    case XYZI: {
                        Assert.assertArrayEquals((float[])testIntensities, (float[])unpackedCloud.getIntensities(), (float)1.0E-10f);
                        break;
                    }
                    case XYZRGB: {
                        Assert.assertArrayEquals((Object[])testColor, (Object[])unpackedCloud.getPointColors());
                    }
                }
                Assert.assertEquals((Object)"/testFrame", (Object)pointCloud.getHeader().getFrameId());
                latch.countDown();
            }
        };
        rosMainNode.attachSubscriber(testTopic, (RosTopicSubscriberInterface)subscriber);
        rosMainNode.execute();
        subscriber.wailTillRegistered();
        publisher.waitTillRegistered();
        switch (testPointType) {
            case XYZI: {
                publisher.publish(testPoints, testIntensities, "/testFrame");
                break;
            }
            case XYZRGB: {
                publisher.publish(testPoints, testColor, "/testFrame");
            }
        }
        Assert.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
    }
}

