/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.utilities.ros;

import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.ros.exception.RemoteException;
import org.ros.exception.RosRuntimeException;
import org.ros.internal.message.Message;
import org.ros.node.service.ServiceResponseListener;
import test_rosmaster.AddTwoIntsRequest;
import test_rosmaster.AddTwoIntsResponse;
import us.ihmc.robotics.Assert;
import us.ihmc.utilities.ros.AddTwoIntsClient;
import us.ihmc.utilities.ros.AddTwoIntsServer;
import us.ihmc.utilities.ros.IHMCRosTestWithRosCore;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.RosServiceClient;
import us.ihmc.utilities.ros.RosServiceServer;

public class AddTwoIntsServiceTest
extends IHMCRosTestWithRosCore {
    static final boolean USE_JAVA_ROSCORE = true;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp(true);
    }

    @Test
    public void lowlevelRosServiceClientTest() throws URISyntaxException, InterruptedException {
        RosMainNode rosMainNode = new RosMainNode(this.rosMasterURI, "serviceClientTestNode");
        RosServiceClient serviceClient = new RosServiceClient("test_rosmaster/AddTwoInts");
        AddTwoIntsServer serviceServer = new AddTwoIntsServer();
        rosMainNode.attachServiceClient("/add_two_ints", serviceClient);
        rosMainNode.attachServiceServer("/add_two_ints", (RosServiceServer)serviceServer);
        rosMainNode.execute();
        serviceClient.waitTillConnected();
        int nTry = 100;
        final CountDownLatch latch = new CountDownLatch(nTry);
        ServiceResponseListener<AddTwoIntsResponse> responseListener = new ServiceResponseListener<AddTwoIntsResponse>(){

            public void onSuccess(AddTwoIntsResponse response) {
                latch.countDown();
            }

            public void onFailure(RemoteException e) {
                throw new RosRuntimeException((Throwable)e);
            }
        };
        for (int i = 0; i < nTry; ++i) {
            AddTwoIntsRequest request = (AddTwoIntsRequest)serviceClient.getMessage();
            request.setA((long)i);
            request.setB(0L);
            serviceClient.call((Message)request, (ServiceResponseListener)responseListener);
        }
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
    }

    @Test
    public void highLevelRosServiceClientTest() throws InterruptedException {
        RosMainNode rosMainNode = new RosMainNode(this.rosMasterURI, "serviceClientTestNode");
        AddTwoIntsClient serviceClient = new AddTwoIntsClient();
        AddTwoIntsServer serviceServer = new AddTwoIntsServer();
        rosMainNode.attachServiceServer("/add_two_ints", (RosServiceServer)serviceServer);
        rosMainNode.attachServiceClient("/add_two_ints", (RosServiceClient)serviceClient);
        rosMainNode.execute();
        serviceClient.waitTillConnected();
        int nTry = 100;
        for (int i = 0; i < nTry; ++i) {
            long answer = serviceClient.simpleCall(i, 0L);
            Assert.assertEquals((long)(i + 0), (long)answer);
        }
    }
}

