/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.weightMatrices;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.weightMatrices.WeightMatrix3D;

public class WeightMatrix6D {
    private final WeightMatrix3D angularWeights = new WeightMatrix3D();
    private final WeightMatrix3D linearWeights = new WeightMatrix3D();

    public WeightMatrix6D() {
    }

    public WeightMatrix6D(WeightMatrix6D other) {
        this.set(other);
    }

    public void clearWeightFrame() {
        this.setWeightFrame(null);
    }

    public void clearAngularWeightFrame() {
        this.angularWeights.clearWeightFrame();
    }

    public void clearLinearWeightFrame() {
        this.linearWeights.clearWeightFrame();
    }

    public void setWeightFrame(ReferenceFrame weightFrame) {
        this.setWeightFrames(weightFrame, weightFrame);
    }

    public void setWeightFrames(ReferenceFrame angularWeightFrame, ReferenceFrame linearWeightFrame) {
        this.angularWeights.setWeightFrame(angularWeightFrame);
        this.linearWeights.setWeightFrame(linearWeightFrame);
    }

    public void clear() {
        this.angularWeights.clear();
        this.linearWeights.clear();
    }

    public void clearAngularWeights() {
        this.angularWeights.clear();
    }

    public void clearLinearWeights() {
        this.linearWeights.clear();
    }

    public void set(WeightMatrix6D other) {
        this.angularWeights.set(other.angularWeights);
        this.linearWeights.set(other.linearWeights);
    }

    public void setAngularPart(WeightMatrix3D angularPart) {
        this.angularWeights.set(angularPart);
    }

    public void setLinearPart(WeightMatrix3D linearPart) {
        this.linearWeights.set(linearPart);
    }

    public void setAngularWeights(double angularXWeight, double angularYWeight, double angularZWeight) {
        this.setAngularXAxisWeight(angularXWeight);
        this.setAngularYAxisWeight(angularYWeight);
        this.setAngularZAxisWeight(angularZWeight);
    }

    public void setAngularXAxisWeight(double weight) {
        this.angularWeights.setXAxisWeight(weight);
    }

    public void setAngularYAxisWeight(double weight) {
        this.angularWeights.setYAxisWeight(weight);
    }

    public void setAngularZAxisWeight(double weight) {
        this.angularWeights.setZAxisWeight(weight);
    }

    public void setAngularWeights(Tuple3DReadOnly angularWeights) {
        this.angularWeights.setWeights(angularWeights);
    }

    public void setLinearWeights(double linearXWeight, double linearYWeight, double linearZWeight) {
        this.setLinearXAxisWeight(linearXWeight);
        this.setLinearYAxisWeight(linearYWeight);
        this.setLinearZAxisWeight(linearZWeight);
    }

    public void setLinearXAxisWeight(double weight) {
        this.linearWeights.setXAxisWeight(weight);
    }

    public void setLinearYAxisWeight(double weight) {
        this.linearWeights.setYAxisWeight(weight);
    }

    public void setLinearZAxisWeight(double weight) {
        this.linearWeights.setZAxisWeight(weight);
    }

    public void setLinearWeights(Tuple3DReadOnly linearWeights) {
        this.linearWeights.setWeights(linearWeights);
    }

    public void scale(double scalar) {
        this.angularWeights.scale(scalar);
        this.linearWeights.scale(scalar);
    }

    public void applyAngularWeight(FrameVector3D vectorToBeModified) {
        this.angularWeights.applyWeight(vectorToBeModified);
    }

    public void applyLinearWeight(FrameVector3D vectorToBeModified) {
        this.linearWeights.applyWeight(vectorToBeModified);
    }

    public void getFullWeightMatrixInFrame(ReferenceFrame destinationFrame, DMatrixRMaj weightMatrixToPack) {
        weightMatrixToPack.reshape(6, 6);
        weightMatrixToPack.zero();
        this.angularWeights.getFullWeightMatrixInFrame(destinationFrame, 0, 0, weightMatrixToPack);
        this.linearWeights.getFullWeightMatrixInFrame(destinationFrame, 3, 3, weightMatrixToPack);
    }

    public void getCompactWeightMatrixInFrame(ReferenceFrame destinationFrame, DMatrixRMaj weightMatrixToPack) {
        weightMatrixToPack.reshape(6, 6);
        weightMatrixToPack.zero();
        this.linearWeights.getCompactWeightMatrixInFrame(destinationFrame, 3, 3, weightMatrixToPack);
        this.angularWeights.getCompactWeightMatrixInFrame(destinationFrame, 0, 0, weightMatrixToPack);
    }

    public double getAngularXAxisWeight() {
        return this.angularWeights.getXAxisWeight();
    }

    public double getAngularYAxisWeight() {
        return this.angularWeights.getYAxisWeight();
    }

    public double getAngularZAxisWeight() {
        return this.angularWeights.getZAxisWeight();
    }

    public ReferenceFrame getAngularWeightFrame() {
        return this.angularWeights.getWeightFrame();
    }

    public double getLinearXAxisWeight() {
        return this.linearWeights.getXAxisWeight();
    }

    public double getLinearYAxisWeight() {
        return this.linearWeights.getYAxisWeight();
    }

    public double getLinearZAxisWeight() {
        return this.linearWeights.getZAxisWeight();
    }

    public ReferenceFrame getLinearWeightFrame() {
        return this.linearWeights.getWeightFrame();
    }

    public WeightMatrix3D getAngularPart() {
        return this.angularWeights;
    }

    public WeightMatrix3D getLinearPart() {
        return this.linearWeights;
    }

    public String toString() {
        return "Angular: " + String.valueOf(this.angularWeights) + ", linear: " + String.valueOf(this.linearWeights);
    }

    public boolean containsHardConstraint() {
        return this.angularWeights.containsHardConstraint() || this.linearWeights.containsHardConstraint();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.angularWeights == null ? 0 : this.angularWeights.hashCode());
        result = 31 * result + (this.linearWeights == null ? 0 : this.linearWeights.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WeightMatrix6D) {
            WeightMatrix6D other = (WeightMatrix6D)object;
            if (this.angularWeights == null ? other.angularWeights != null : !this.angularWeights.equals(other.angularWeights)) {
                return false;
            }
            return !(this.linearWeights == null ? other.angularWeights != null : !this.linearWeights.equals(other.linearWeights));
        }
        return false;
    }
}

