/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.weightMatrices;

import org.ejml.MatrixDimensionException;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameMatrix3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.matrixlib.MatrixTools;

public class WeightMatrix3D
implements Tuple3DReadOnly {
    private static final double EPSILON = 1.0E-7;
    private ReferenceFrame weightFrame = null;
    private double xWeight = Double.NaN;
    private double yWeight = Double.NaN;
    private double zWeight = Double.NaN;
    private final transient FrameMatrix3D frameMatrix = new FrameMatrix3D();

    public WeightMatrix3D() {
    }

    public WeightMatrix3D(WeightMatrix3D other) {
        this.set(other);
    }

    public void clearWeightFrame() {
        this.setWeightFrame(null);
    }

    public void setWeightFrame(ReferenceFrame weightFrame) {
        this.weightFrame = weightFrame;
    }

    public void clear() {
        this.weightFrame = null;
        this.xWeight = Double.NaN;
        this.yWeight = Double.NaN;
        this.zWeight = Double.NaN;
    }

    public void set(WeightMatrix3D other) {
        this.weightFrame = other.weightFrame;
        this.xWeight = other.xWeight;
        this.yWeight = other.yWeight;
        this.zWeight = other.zWeight;
    }

    public void setWeights(double weightsValue) {
        this.setWeights(weightsValue, weightsValue, weightsValue);
    }

    public void setWeights(Tuple3DReadOnly weights) {
        this.setWeights(weights.getX(), weights.getY(), weights.getZ());
    }

    public void setWeights(double xWeight, double yWeight, double zWeight) {
        this.xWeight = xWeight;
        this.yWeight = yWeight;
        this.zWeight = zWeight;
    }

    public void setXAxisWeight(double weight) {
        this.xWeight = weight;
    }

    public void setYAxisWeight(double weight) {
        this.yWeight = weight;
    }

    public void setZAxisWeight(double weight) {
        this.zWeight = weight;
    }

    public void scale(double scalar) {
        this.xWeight *= scalar;
        this.yWeight *= scalar;
        this.zWeight *= scalar;
    }

    public void applyWeight(FrameVector3D vectorToBeModified) {
        ReferenceFrame vectorFrame = vectorToBeModified.getReferenceFrame();
        boolean canIgnoreSelectionFrame = this.canIgnoreWeightFrame(vectorFrame);
        if (!canIgnoreSelectionFrame) {
            vectorToBeModified.changeFrame(this.weightFrame);
        }
        vectorToBeModified.setX(this.xWeight * vectorToBeModified.getX());
        vectorToBeModified.setY(this.yWeight * vectorToBeModified.getY());
        vectorToBeModified.setZ(this.zWeight * vectorToBeModified.getZ());
        if (!canIgnoreSelectionFrame) {
            vectorToBeModified.changeFrame(vectorFrame);
        }
    }

    public void getFullWeightMatrixInFrame(ReferenceFrame destinationFrame, DMatrixRMaj weightMatrixToPack) {
        this.getFullWeightMatrixInFrame(destinationFrame, 0, 0, weightMatrixToPack);
    }

    public void getFullWeightMatrixInFrame(ReferenceFrame destinationFrame, int startRow, int startColumn, DMatrixRMaj weightMatrixToPack) {
        int numRows = weightMatrixToPack.getNumRows();
        int numCols = weightMatrixToPack.getNumCols();
        if (numRows < startRow + 3 || numCols < startColumn + 3) {
            throw new MatrixDimensionException("The weight matrix has to be at least a " + (startRow + 3) + "-by-" + (startColumn + 3) + " but was instead a " + numRows + "-by-" + numCols + " matrix.");
        }
        if (this.canIgnoreWeightFrame(destinationFrame)) {
            for (int row = startRow; row < startRow + 3; ++row) {
                for (int column = startColumn; column < startColumn + 3; ++column) {
                    weightMatrixToPack.set(row, column, 0.0);
                }
            }
            weightMatrixToPack.set(startRow++, startColumn++, this.xWeight);
            weightMatrixToPack.set(startRow++, startColumn++, this.yWeight);
            weightMatrixToPack.set(startRow, startColumn, this.zWeight);
        } else {
            this.frameMatrix.setToZero(this.weightFrame);
            this.frameMatrix.setM00(this.xWeight);
            this.frameMatrix.setM11(this.yWeight);
            this.frameMatrix.setM22(this.zWeight);
            this.frameMatrix.changeFrame(destinationFrame);
            this.frameMatrix.get(startRow, startColumn, (DMatrix)weightMatrixToPack);
        }
    }

    public void getEfficientWeightMatrixInFrame(ReferenceFrame destinationFrame, DMatrixRMaj weightMatrixToPack) {
        this.getCompactWeightMatrixInFrame(destinationFrame, 0, 0, weightMatrixToPack);
    }

    public void getCompactWeightMatrixInFrame(ReferenceFrame destinationFrame, int startRow, int startColumn, DMatrixRMaj weightMatrixToPack) {
        int numRows = weightMatrixToPack.getNumRows();
        int numCols = weightMatrixToPack.getNumCols();
        if (numRows < startRow + 3 || numCols < startColumn + 3) {
            throw new MatrixDimensionException("The weight matrix has to be at least a " + (startRow + 3) + "-by-" + (startColumn + 3) + " but was instead a " + numRows + "-by-" + numCols + " matrix.");
        }
        if (this.canIgnoreWeightFrame(destinationFrame)) {
            for (int row = startRow; row < startRow + 3; ++row) {
                for (int column = startColumn; column < startColumn + 3; ++column) {
                    weightMatrixToPack.set(row, column, 0.0);
                }
            }
            weightMatrixToPack.set(startRow, startColumn, this.xWeight);
            weightMatrixToPack.set(startRow + 1, startColumn + 1, this.yWeight);
            weightMatrixToPack.set(startRow + 2, startColumn + 2, this.zWeight);
            MatrixTools.removeZeroRows((DMatrix1Row)weightMatrixToPack, (int)startRow, (int)(startRow + 2), (double)1.0E-7);
        } else {
            this.frameMatrix.setToZero(this.weightFrame);
            this.frameMatrix.setM00(this.xWeight);
            this.frameMatrix.setM11(this.yWeight);
            this.frameMatrix.setM22(this.zWeight);
            this.frameMatrix.changeFrame(destinationFrame);
            this.frameMatrix.get(startRow, startColumn, (DMatrix)weightMatrixToPack);
            MatrixTools.removeZeroRows((DMatrix1Row)weightMatrixToPack, (int)startRow, (int)(startRow + 2), (double)1.0E-7);
        }
    }

    private boolean canIgnoreWeightFrame(ReferenceFrame destinationFrame) {
        if (this.weightFrame == null) {
            return true;
        }
        if (this.weightFrame == destinationFrame) {
            return true;
        }
        if (Math.abs(this.xWeight) < 1.0E-6 && Math.abs(this.yWeight) < 1.0E-6 && Math.abs(this.zWeight) < 1.0E-7) {
            return true;
        }
        return Double.isNaN(this.xWeight) && Double.isNaN(this.yWeight) && Double.isNaN(this.zWeight);
    }

    public double getXAxisWeight() {
        return this.xWeight;
    }

    public double getYAxisWeight() {
        return this.yWeight;
    }

    public double getZAxisWeight() {
        return this.zWeight;
    }

    public ReferenceFrame getWeightFrame() {
        return this.weightFrame;
    }

    public String toString() {
        return "(" + this.xWeight + ", " + this.yWeight + ", " + this.zWeight + ") " + String.valueOf(this.weightFrame);
    }

    public boolean containsHardConstraint() {
        return this.getXAxisWeight() == Double.POSITIVE_INFINITY || this.getYAxisWeight() == Double.POSITIVE_INFINITY || this.getZAxisWeight() == Double.POSITIVE_INFINITY;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.frameMatrix == null ? 0 : this.frameMatrix.hashCode());
        result = 31 * result + (this.weightFrame == null ? 0 : this.weightFrame.hashCode());
        long temp = Double.doubleToLongBits(this.xWeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.yWeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.zWeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof WeightMatrix3D) {
            return this.equals((WeightMatrix3D)object);
        }
        return false;
    }

    public boolean equals(WeightMatrix3D other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.weightFrame == null ? other.weightFrame != null : !this.weightFrame.equals((Object)other.weightFrame)) {
            return false;
        }
        if (Double.compare(this.xWeight, other.xWeight) != 0) {
            return false;
        }
        if (Double.compare(this.yWeight, other.yWeight) != 0) {
            return false;
        }
        return Double.compare(this.zWeight, other.zWeight) == 0;
    }

    public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        return this.epsilonEquals(geometry, epsilon);
    }

    public double getX() {
        return this.xWeight;
    }

    public double getY() {
        return this.yWeight;
    }

    public double getZ() {
        return this.zWeight;
    }

    public void set(Tuple3DReadOnly weightVector) {
        this.setXAxisWeight(weightVector.getX());
        this.setYAxisWeight(weightVector.getY());
        this.setZAxisWeight(weightVector.getZ());
    }
}

