/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.time;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.List;
import us.ihmc.commons.Conversions;

public class TimeTools {
    public static Instant now() {
        return Instant.now();
    }

    public static double calculateDelay(Instant then) {
        return TimeTools.calculateDelay(then.getEpochSecond(), then.getNano());
    }

    public static double calculateDelay(long eventSecondsSinceEpoch, long eventAdditionalNanos) {
        Instant now = Instant.now();
        long seconds = now.getEpochSecond() - eventSecondsSinceEpoch;
        long nano = (long)now.getNano() - eventAdditionalNanos;
        return (double)seconds + Conversions.nanosecondsToSeconds((long)nano);
    }

    public static double secondsBetween(Temporal startInclusive, Temporal endExclusive) {
        return TimeTools.toDoubleSeconds(Duration.between(startInclusive, endExclusive));
    }

    public static double toDoubleSeconds(Duration duration) {
        return TimeTools.secondsNanosToDoubleSeconds(duration.getSeconds(), duration.getNano());
    }

    public static double secondsMillisToDoubleSeconds(long seconds, long millis) {
        return (double)seconds + Conversions.millisecondsToSeconds((double)millis);
    }

    public static double secondsNanosToDoubleSeconds(long seconds, int nanos) {
        return (double)seconds + Conversions.nanosecondsToSeconds((long)nanos);
    }

    public static Duration durationOfSeconds(double seconds) {
        long longSeconds = (long)seconds;
        long nanos = (long)((seconds - (double)longSeconds) * 1.0E9);
        return Duration.ofSeconds(longSeconds, nanos);
    }

    public static int findClosestTimeIndex(Temporal targetTime, List<? extends Temporal> times) {
        long closestNanosFromTargetTime = Long.MAX_VALUE;
        int closestTimeIndex = -1;
        for (int i = 0; i < times.size(); ++i) {
            Temporal time = times.get(i);
            long nanosFromTargetTime = Math.abs(time.until(targetTime, ChronoUnit.NANOS));
            if (nanosFromTargetTime == 0L) {
                return i;
            }
            if (nanosFromTargetTime >= closestNanosFromTargetTime) continue;
            closestNanosFromTargetTime = nanosFromTargetTime;
            closestTimeIndex = i;
        }
        return closestTimeIndex;
    }
}

