/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.testing;

import us.ihmc.commons.FormattingTools;
import us.ihmc.commons.MathTools;
import us.ihmc.robotics.testing.GoalOrientedTestGoal;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public abstract class YoVariableTestGoal
extends GoalOrientedTestGoal {
    private static final int SIGNIFICANT_FIGURES_FOR_PRINT_OUT = 3;
    protected String failurePrefix = null;
    protected StringProvider stringProvider = null;

    protected YoVariableTestGoal(YoVariable ... yoVariables) {
        this("", yoVariables);
    }

    protected YoVariableTestGoal(String failurePrefix, YoVariable ... yoVariables) {
        this(failurePrefix);
        for (YoVariable yoVariable : yoVariables) {
            yoVariable.addListener(this::notifyOfVariableChange);
        }
    }

    public YoVariableTestGoal() {
        this("");
    }

    public YoVariableTestGoal(String failurePrefix) {
        this.failurePrefix = failurePrefix;
    }

    public YoVariableTestGoal(StringProvider stringProvider) {
        this.stringProvider = stringProvider;
    }

    public void notifyOfVariableChange(YoVariable v) {
        this.update();
    }

    public static YoVariableTestGoal variablesEqual(final YoDouble variableOne, final YoDouble variableTwo, final double epsilon) {
        return new YoVariableTestGoal(new YoVariable[]{variableOne}){

            @Override
            public boolean currentlyMeetsGoal() {
                return MathTools.epsilonEquals((double)variableOne.getDoubleValue(), (double)variableTwo.getDoubleValue(), (double)epsilon);
            }

            @Override
            public String toString() {
                String numberStringOne = 1.getFormattedDoubleYoVariable(variableOne);
                String numberStringTwo = 1.getFormattedDoubleYoVariable(variableTwo);
                String epsilonString = FormattingTools.getFormattedToSignificantFigures((double)epsilon, (int)3);
                if (this.stringProvider != null) {
                    this.failurePrefix = this.stringProvider.getString();
                }
                return this.failurePrefix + numberStringOne + " (+/- " + epsilonString + ") == " + numberStringTwo;
            }
        };
    }

    public static YoVariableTestGoal doubleWithinEpsilon(final YoDouble yoDouble, final double goalValue, final double epsilon) {
        return new YoVariableTestGoal(new YoVariable[]{yoDouble}){

            @Override
            public boolean currentlyMeetsGoal() {
                return MathTools.epsilonEquals((double)yoDouble.getDoubleValue(), (double)goalValue, (double)epsilon);
            }

            @Override
            public String toString() {
                String numberString = 2.getFormattedDoubleYoVariable(yoDouble);
                String epsilonString = FormattingTools.getFormattedToSignificantFigures((double)epsilon, (int)3);
                String goalString = FormattingTools.getFormattedToSignificantFigures((double)goalValue, (int)3);
                if (this.stringProvider != null) {
                    this.failurePrefix = this.stringProvider.getString();
                }
                return this.failurePrefix + numberString + " (+/- " + epsilonString + ") == " + goalString;
            }
        };
    }

    public static YoVariableTestGoal doubleGreaterThan(YoDouble yoDouble, double greaterThan) {
        return YoVariableTestGoal.doubleGreaterThan("", yoDouble, greaterThan);
    }

    public static YoVariableTestGoal doubleGreaterThan(String failurePrefix, final YoDouble yoDouble, final double greaterThan) {
        return new YoVariableTestGoal(failurePrefix, new YoVariable[]{yoDouble}){

            @Override
            public boolean currentlyMeetsGoal() {
                return yoDouble.getDoubleValue() > greaterThan;
            }

            @Override
            public String toString() {
                String numberString = 3.getFormattedDoubleYoVariable(yoDouble);
                String greaterThanString = FormattingTools.getFormattedToSignificantFigures((double)greaterThan, (int)3);
                if (this.stringProvider != null) {
                    this.failurePrefix = this.stringProvider.getString();
                }
                return this.failurePrefix + numberString + " > " + greaterThanString;
            }
        };
    }

    public static YoVariableTestGoal deltaGreaterThan(YoDouble minuend, YoDouble subtrahend, double difference) {
        return YoVariableTestGoal.deltaGreaterThan("", minuend, subtrahend, difference);
    }

    public static YoVariableTestGoal deltaGreaterThan(String failurePrefix, final YoDouble minuend, final YoDouble subtrahend, final double difference) {
        return new YoVariableTestGoal(failurePrefix, new YoVariable[]{minuend, subtrahend}){

            @Override
            public boolean currentlyMeetsGoal() {
                return minuend.getDoubleValue() - subtrahend.getDoubleValue() > difference;
            }

            @Override
            public String toString() {
                String minuendString = 4.getFormattedDoubleYoVariable(minuend);
                String subtrahendString = 4.getFormattedDoubleYoVariable(subtrahend);
                String differenceString = FormattingTools.getFormattedToSignificantFigures((double)difference, (int)3);
                if (this.stringProvider != null) {
                    this.failurePrefix = this.stringProvider.getString();
                }
                return this.failurePrefix + minuendString + " - " + subtrahendString + " > " + differenceString;
            }
        };
    }

    public static YoVariableTestGoal doubleLessThan(final YoDouble yoDouble, final double lessThan) {
        return new YoVariableTestGoal(new YoVariable[]{yoDouble}){

            @Override
            public boolean currentlyMeetsGoal() {
                return yoDouble.getDoubleValue() < lessThan;
            }

            @Override
            public String toString() {
                String numberString = 5.getFormattedDoubleYoVariable(yoDouble);
                String lessThanString = FormattingTools.getFormattedToSignificantFigures((double)lessThan, (int)3);
                if (this.stringProvider != null) {
                    this.failurePrefix = this.stringProvider.getString();
                }
                return this.failurePrefix + numberString + " < " + lessThanString;
            }
        };
    }

    public static <T extends Enum<T>> YoVariableTestGoal enumEquals(final YoEnum<T> yoEnum, final Enum<T> enumValue) {
        return new YoVariableTestGoal(new YoVariable[]{yoEnum}){

            @Override
            public boolean currentlyMeetsGoal() {
                return yoEnum.getEnumValue() == enumValue;
            }

            @Override
            public String toString() {
                if (this.stringProvider != null) {
                    this.failurePrefix = this.stringProvider.getString();
                }
                return this.failurePrefix + YoVariableTestGoal.getFormattedEnumYoVariable(yoEnum) + " == " + enumValue.name();
            }
        };
    }

    public static YoVariableTestGoal booleanEquals(final YoBoolean yoBoolean, final boolean booleanValue) {
        return new YoVariableTestGoal(new YoVariable[]{yoBoolean}){

            @Override
            public boolean currentlyMeetsGoal() {
                return yoBoolean.getBooleanValue() == booleanValue;
            }

            @Override
            public String toString() {
                if (this.stringProvider != null) {
                    this.failurePrefix = this.stringProvider.getString();
                }
                return this.failurePrefix + YoVariableTestGoal.getFormattedBooleanYoVariable(yoBoolean) + " == " + booleanValue;
            }
        };
    }

    public static YoVariableTestGoal or(final YoVariableTestGoal goalOne, final YoVariableTestGoal goalTwo) {
        return new YoVariableTestGoal(){

            @Override
            public boolean currentlyMeetsGoal() {
                return goalOne.currentlyMeetsGoal() || goalTwo.currentlyMeetsGoal();
            }

            @Override
            public String toString() {
                if (this.stringProvider != null) {
                    this.failurePrefix = this.stringProvider.getString();
                }
                return this.failurePrefix + goalOne.toString() + " or " + goalTwo.toString();
            }
        };
    }

    public static YoVariableTestGoal and(YoVariableTestGoal goalOne, YoVariableTestGoal goalTwo) {
        return YoVariableTestGoal.and("", goalOne, goalTwo);
    }

    public static YoVariableTestGoal and(String prefix, final YoVariableTestGoal goalOne, final YoVariableTestGoal goalTwo) {
        return new YoVariableTestGoal(prefix){

            @Override
            public boolean currentlyMeetsGoal() {
                return goalOne.currentlyMeetsGoal() && goalTwo.currentlyMeetsGoal();
            }

            @Override
            public String toString() {
                if (this.stringProvider != null) {
                    this.failurePrefix = this.stringProvider.getString();
                }
                return this.failurePrefix + goalOne.toString() + " and " + goalTwo.toString();
            }
        };
    }

    public static YoVariableTestGoal and(StringProvider stringProvider, final YoVariableTestGoal goalOne, final YoVariableTestGoal goalTwo) {
        return new YoVariableTestGoal(stringProvider){

            @Override
            public boolean currentlyMeetsGoal() {
                return goalOne.currentlyMeetsGoal() && goalTwo.currentlyMeetsGoal();
            }

            @Override
            public String toString() {
                if (this.stringProvider != null) {
                    this.failurePrefix = this.stringProvider.getString();
                }
                return this.failurePrefix + goalOne.toString() + " and " + goalTwo.toString();
            }
        };
    }

    public static YoVariableTestGoal not(final YoVariableTestGoal goal) {
        return new YoVariableTestGoal(){

            @Override
            public boolean currentlyMeetsGoal() {
                return !goal.currentlyMeetsGoal();
            }

            @Override
            public String toString() {
                if (this.stringProvider != null) {
                    this.failurePrefix = this.stringProvider.getString();
                }
                return this.failurePrefix + "not " + goal.toString();
            }
        };
    }

    public static YoVariableTestGoal timeInFuture(YoDouble timeYoVariable, double durationFromNow) {
        return YoVariableTestGoal.doubleGreaterThan("Time did not simulate for long enough. ", timeYoVariable, timeYoVariable.getDoubleValue() + durationFromNow);
    }

    private static String getFormattedBooleanYoVariable(YoBoolean yoBoolean) {
        return yoBoolean.getName() + ": " + yoBoolean.getBooleanValue();
    }

    private static <T extends Enum<T>> String getFormattedEnumYoVariable(YoEnum<T> yoEnum) {
        String enumValueName = yoEnum.getEnumValue() != null ? yoEnum.getEnumValue().name() : "null";
        return yoEnum.getName() + ": " + enumValueName;
    }

    public static String getFormattedDoubleYoVariable(YoDouble yoDouble) {
        if (Double.isFinite(yoDouble.getDoubleValue())) {
            return yoDouble.getName() + ": " + FormattingTools.getFormattedToSignificantFigures((double)yoDouble.getDoubleValue(), (int)3);
        }
        return yoDouble.getName() + ": " + yoDouble.getDoubleValue();
    }

    public static interface StringProvider {
        public String getString();
    }
}

