/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.taskExecutor;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachineClock;
import us.ihmc.robotics.taskExecutor.StateExecutor;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.variable.YoDouble;

public class ParallelState<T>
implements State {
    private final Map<T, StateExecutor> executorMap = new LinkedHashMap<T, StateExecutor>();
    private final ArrayList<StateExecutor> executors = new ArrayList();
    private final StateMachineClock clock;

    public ParallelState(YoDouble yotime) {
        this.clock = StateMachineClock.clock((DoubleProvider)yotime);
    }

    @Deprecated
    public ParallelState() {
        this.clock = StateMachineClock.dummyClock();
    }

    public void submit(T executorKey, State state) {
        StateExecutor executor = this.executorMap.get(executorKey);
        if (executor == null) {
            executor = new StateExecutor(this.clock);
            this.executorMap.put(executorKey, executor);
            this.executors.add(executor);
        }
        executor.submit(state);
    }

    public void clear(T executorKey) {
        StateExecutor stateExecutor = this.executorMap.get(executorKey);
        if (stateExecutor != null) {
            stateExecutor.clear();
        }
    }

    public void onEntry() {
        for (int i = 0; i < this.executors.size(); ++i) {
            this.executors.get(i).handleTransitions();
        }
    }

    public void doAction(double timeInState) {
        for (int i = 0; i < this.executors.size(); ++i) {
            this.executors.get(i).doControl();
        }
    }

    public void onExit(double timeInState) {
    }

    public boolean isDone(double timeInState) {
        for (int i = 0; i < this.executors.size(); ++i) {
            if (this.executors.get(i).isDone()) continue;
            return false;
        }
        return true;
    }

    public void clearAll() {
        for (int i = 0; i < this.executors.size(); ++i) {
            this.executors.get(i).clear();
        }
    }
}

