/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.sensors;

import java.util.Arrays;
import java.util.Objects;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.MecanoMissingTools;
import us.ihmc.robotics.screwTheory.GenericCRC32;
import us.ihmc.robotics.sensors.ForceSensorDataReadOnly;
import us.ihmc.robotics.sensors.ForceSensorDefinition;

public class ForceSensorData
implements ForceSensorDataReadOnly,
Settable<ForceSensorData> {
    private final DMatrixRMaj wrenchMatrix = new DMatrixRMaj(6, 1);
    private String sensorName;
    private ReferenceFrame measurementFrame;
    private RigidBodyBasics measurementLink;
    private final transient WrenchReadOnly wrench = MecanoMissingTools.newLinkedWrenchReadOnly(this::getMeasurementFrame, this::getMeasurementFrame, this.wrenchMatrix);

    public ForceSensorData() {
    }

    public ForceSensorData(ForceSensorDefinition forceSensorDefinition) {
        this.setDefinition(forceSensorDefinition);
    }

    public void setDefinition(ForceSensorDefinition forceSensorDefinition) {
        this.setDefinition(forceSensorDefinition.getSensorName(), forceSensorDefinition.getSensorFrame(), forceSensorDefinition.getRigidBody());
    }

    public void setDefinition(String sensorName, ReferenceFrame measurementFrame, RigidBodyBasics measurementLink) {
        this.sensorName = sensorName;
        this.measurementFrame = measurementFrame;
        this.measurementLink = measurementLink;
    }

    public void setWrench(Vector3DReadOnly moment, Vector3DReadOnly force) {
        moment.get(0, (DMatrix)this.wrenchMatrix);
        force.get(3, (DMatrix)this.wrenchMatrix);
    }

    public void setWrench(DMatrixRMaj newWrench) {
        this.wrenchMatrix.set((DMatrixD1)newWrench);
    }

    public void setWrench(float[] newWrench) {
        for (int i = 0; i < 6; ++i) {
            this.wrenchMatrix.set(i, 0, (double)newWrench[i]);
        }
    }

    public void setWrench(WrenchReadOnly newWrench) {
        this.measurementFrame.checkReferenceFrameMatch(newWrench.getReferenceFrame());
        this.measurementFrame.checkReferenceFrameMatch(newWrench.getBodyFrame());
        newWrench.get((DMatrix)this.wrenchMatrix);
    }

    @Override
    public String getSensorName() {
        return this.sensorName;
    }

    @Override
    public ReferenceFrame getMeasurementFrame() {
        return this.measurementFrame;
    }

    @Override
    public RigidBodyBasics getMeasurementLink() {
        return this.measurementLink;
    }

    @Override
    public void getWrenchMatrix(DMatrixRMaj wrenchMatrixToPack) {
        wrenchMatrixToPack.set((DMatrixD1)this.wrenchMatrix);
    }

    public DMatrixRMaj getWrenchMatrix() {
        return this.wrenchMatrix;
    }

    @Override
    public WrenchReadOnly getWrench() {
        return this.wrench;
    }

    public void set(ForceSensorData other) {
        this.set((ForceSensorDataReadOnly)other);
    }

    public void set(ForceSensorDataReadOnly other) {
        this.sensorName = other.getSensorName();
        this.measurementFrame = other.getMeasurementFrame();
        this.measurementLink = other.getMeasurementLink();
        other.getWrenchMatrix(this.wrenchMatrix);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ForceSensorData) {
            ForceSensorData other = (ForceSensorData)obj;
            if (!Objects.equals(this.sensorName, other.sensorName)) {
                return false;
            }
            if (this.measurementFrame != other.measurementFrame) {
                return false;
            }
            if (this.measurementLink != other.measurementLink) {
                return false;
            }
            return MatrixTools.equals((DMatrix1Row)this.wrenchMatrix, (DMatrix1Row)other.wrenchMatrix);
        }
        return false;
    }

    public void calculateChecksum(GenericCRC32 checksum) {
        checksum.update(this.wrenchMatrix);
    }

    public String toString() {
        return "[sensorName=" + this.sensorName + ", wrenchMatrix=" + Arrays.toString(this.wrenchMatrix.data) + ", measurementFrame=" + String.valueOf(this.measurementFrame) + ", measurementLink=" + this.measurementLink.getName() + "]";
    }
}

