/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.mecano.spatial.interfaces.FixedFrameMomentumBasics;
import us.ihmc.robotics.screwTheory.MomentumCalculator;
import us.ihmc.robotics.screwTheory.WholeBodyInertiaCalculator;

public class WholeBodyAngularVelocityCalculator {
    private final WholeBodyInertiaCalculator wholeBodyInertiaCalculator;
    private final MomentumCalculator momentumCalculator;
    private final Momentum robotMomentum = new Momentum();
    private final FrameVector3D linearMomentum = new FrameVector3D();
    private final FrameVector3D angularMomentum = new FrameVector3D();
    private final FrameVector3D wholeBodyAngularVelocity = new FrameVector3D();

    public WholeBodyAngularVelocityCalculator(ReferenceFrame centerOfMassFrame, YoGraphicsListRegistry graphicsListRegistry, RigidBodyBasics ... rigidBodies) {
        this.wholeBodyInertiaCalculator = new WholeBodyInertiaCalculator(centerOfMassFrame, null, rigidBodies);
        this.momentumCalculator = new MomentumCalculator((RigidBodyReadOnly[])rigidBodies);
        this.robotMomentum.setReferenceFrame(centerOfMassFrame);
    }

    public WholeBodyAngularVelocityCalculator(ReferenceFrame centerOfMassFrame, YoGraphicsListRegistry graphicsListRegistry, RigidBodyBasics rootBody) {
        this(centerOfMassFrame, graphicsListRegistry, rootBody.subtreeArray());
    }

    public FrameVector3DReadOnly getLinearMomentum() {
        return this.linearMomentum;
    }

    public FrameVector3DReadOnly getAngularMomentum() {
        return this.angularMomentum;
    }

    public FrameVector3DReadOnly getWholeBodyAngularVelocity() {
        return this.wholeBodyAngularVelocity;
    }

    public void compute() {
        this.wholeBodyInertiaCalculator.compute();
        this.momentumCalculator.computeAndPack((FixedFrameMomentumBasics)this.robotMomentum);
        this.linearMomentum.setIncludingFrame((FrameTuple3DReadOnly)this.robotMomentum.getLinearPart());
        this.angularMomentum.setIncludingFrame((FrameTuple3DReadOnly)this.robotMomentum.getAngularPart());
        this.wholeBodyAngularVelocity.setToZero(this.angularMomentum.getReferenceFrame());
        this.wholeBodyInertiaCalculator.getWholeBodyInertia().getMomentOfInertia().inverseTransform((Tuple3DReadOnly)this.angularMomentum, (Tuple3DBasics)this.wholeBodyAngularVelocity);
    }
}

