/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;

public class SelectionMatrix6D {
    private final SelectionMatrix3D angularPart = new SelectionMatrix3D();
    private final SelectionMatrix3D linearPart = new SelectionMatrix3D();

    public SelectionMatrix6D() {
    }

    public SelectionMatrix6D(SelectionMatrix6D other) {
        this.set(other);
    }

    public void clearSelectionFrame() {
        this.setSelectionFrame(null);
    }

    public void clearAngularSelectionFrame() {
        this.angularPart.clearSelectionFrame();
    }

    public void clearLinearSelectionFrame() {
        this.linearPart.clearSelectionFrame();
    }

    public void setSelectionFrame(ReferenceFrame selectionFrame) {
        this.setSelectionFrames(selectionFrame, selectionFrame);
    }

    public void setSelectionFrames(ReferenceFrame angularSelectionFrame, ReferenceFrame linearSelectionFrame) {
        this.angularPart.setSelectionFrame(angularSelectionFrame);
        this.linearPart.setSelectionFrame(linearSelectionFrame);
    }

    public void resetSelection() {
        this.angularPart.resetSelection();
        this.linearPart.resetSelection();
    }

    public void resetAngularSelection() {
        this.angularPart.resetSelection();
    }

    public void resetLinearSelection() {
        this.linearPart.resetSelection();
    }

    public void clearSelection() {
        this.angularPart.clearSelection();
        this.linearPart.clearSelection();
    }

    public void clearAngularSelection() {
        this.angularPart.clearSelection();
    }

    public void clearLinearSelection() {
        this.linearPart.clearSelection();
    }

    public void setToAngularSelectionOnly() {
        this.angularPart.resetSelection();
        this.linearPart.clearSelection();
    }

    public void setToLinearSelectionOnly() {
        this.angularPart.clearSelection();
        this.linearPart.resetSelection();
    }

    public void set(SelectionMatrix6D other) {
        this.angularPart.set(other.angularPart);
        this.linearPart.set(other.linearPart);
    }

    public void setAngularPart(SelectionMatrix3D angularPart) {
        this.angularPart.set(angularPart);
    }

    public void setLinearPart(SelectionMatrix3D linearPart) {
        this.linearPart.set(linearPart);
    }

    public void setAngularAxisSelection(boolean xSelected, boolean ySelected, boolean zSelected) {
        this.selectAngularX(xSelected);
        this.selectAngularY(ySelected);
        this.selectAngularZ(zSelected);
    }

    public void selectAngularX(boolean select) {
        this.angularPart.selectXAxis(select);
    }

    public void selectAngularY(boolean select) {
        this.angularPart.selectYAxis(select);
    }

    public void selectAngularZ(boolean select) {
        this.angularPart.selectZAxis(select);
    }

    public void setLinearAxisSelection(boolean xSelected, boolean ySelected, boolean zSelected) {
        this.selectLinearX(xSelected);
        this.selectLinearY(ySelected);
        this.selectLinearZ(zSelected);
    }

    public void selectLinearX(boolean select) {
        this.linearPart.selectXAxis(select);
    }

    public void selectLinearY(boolean select) {
        this.linearPart.selectYAxis(select);
    }

    public void selectLinearZ(boolean select) {
        this.linearPart.selectZAxis(select);
    }

    public void selectAxis(int axisIndex, boolean select) {
        switch (axisIndex) {
            case 0: {
                this.selectAngularX(select);
                break;
            }
            case 1: {
                this.selectAngularY(select);
                break;
            }
            case 2: {
                this.selectAngularZ(select);
                break;
            }
            case 3: {
                this.selectLinearX(select);
                break;
            }
            case 4: {
                this.selectLinearY(select);
                break;
            }
            case 5: {
                this.selectLinearZ(select);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(axisIndex));
            }
        }
    }

    public void applyAngularSelection(FrameVector3D vectorToBeModified) {
        this.angularPart.applySelection(vectorToBeModified);
    }

    public void applyLinearSelection(FrameVector3D vectorToBeModified) {
        this.linearPart.applySelection(vectorToBeModified);
    }

    public void getFullSelectionMatrixInFrame(ReferenceFrame destinationFrame, DMatrixRMaj selectionMatrixToPack) {
        selectionMatrixToPack.reshape(6, 6);
        selectionMatrixToPack.zero();
        this.angularPart.getFullSelectionMatrixInFrame(destinationFrame, 0, 0, selectionMatrixToPack);
        this.linearPart.getFullSelectionMatrixInFrame(destinationFrame, 3, 3, selectionMatrixToPack);
    }

    public void getCompactSelectionMatrixInFrame(ReferenceFrame destinationFrame, DMatrixRMaj selectionMatrixToPack) {
        selectionMatrixToPack.reshape(6, 6);
        selectionMatrixToPack.zero();
        this.linearPart.getCompactSelectionMatrixInFrame(destinationFrame, 3, 3, selectionMatrixToPack);
        this.angularPart.getCompactSelectionMatrixInFrame(destinationFrame, 0, 0, selectionMatrixToPack);
    }

    public boolean isAngularXSelected() {
        return this.angularPart.isXSelected();
    }

    public boolean isAngularYSelected() {
        return this.angularPart.isYSelected();
    }

    public boolean isAngularZSelected() {
        return this.angularPart.isZSelected();
    }

    public ReferenceFrame getAngularSelectionFrame() {
        return this.angularPart.getSelectionFrame();
    }

    public boolean isLinearXSelected() {
        return this.linearPart.isXSelected();
    }

    public boolean isLinearYSelected() {
        return this.linearPart.isYSelected();
    }

    public boolean isLinearZSelected() {
        return this.linearPart.isZSelected();
    }

    public boolean isAxisSelected(int axisIndex) {
        switch (axisIndex) {
            case 0: {
                return this.isAngularXSelected();
            }
            case 1: {
                return this.isAngularYSelected();
            }
            case 2: {
                return this.isAngularZSelected();
            }
            case 3: {
                return this.isLinearXSelected();
            }
            case 4: {
                return this.isLinearYSelected();
            }
            case 5: {
                return this.isLinearZSelected();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(axisIndex));
    }

    public ReferenceFrame getLinearSelectionFrame() {
        return this.linearPart.getSelectionFrame();
    }

    public SelectionMatrix3D getAngularPart() {
        return this.angularPart;
    }

    public SelectionMatrix3D getLinearPart() {
        return this.linearPart;
    }

    public boolean isAngularPartActive() {
        return this.isAngularXSelected() || this.isAngularYSelected() || this.isAngularZSelected();
    }

    public boolean isLinearPartActive() {
        return this.isLinearXSelected() || this.isLinearYSelected() || this.isLinearZSelected();
    }

    public int getNumberOfSelectedAxes() {
        return this.linearPart.getNumberOfSelectedAxes() + this.angularPart.getNumberOfSelectedAxes();
    }

    public String toString() {
        return "Angular: " + String.valueOf(this.angularPart) + ", linear: " + String.valueOf(this.linearPart);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.angularPart == null ? 0 : this.angularPart.hashCode());
        result = 31 * result + (this.linearPart == null ? 0 : this.linearPart.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectionMatrix6D other = (SelectionMatrix6D)obj;
        if (this.angularPart == null ? other.angularPart != null : !this.angularPart.equals(other.angularPart)) {
            return false;
        }
        return !(this.linearPart == null ? other.linearPart != null : !this.linearPart.equals(other.linearPart));
    }
}

