/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import org.ejml.MatrixDimensionException;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.FrameMatrix3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.matrixlib.MatrixTools;

public class SelectionMatrix3D {
    private ReferenceFrame selectionFrame = null;
    private boolean xSelected = true;
    private boolean ySelected = true;
    private boolean zSelected = true;
    private final transient FrameMatrix3D frameMatrix = new FrameMatrix3D();

    public SelectionMatrix3D() {
    }

    public SelectionMatrix3D(ReferenceFrame selectionFrame, boolean xSelected, boolean ySelected, boolean zSelected) {
        this.setSelectionFrame(selectionFrame);
        this.setAxisSelection(xSelected, ySelected, zSelected);
    }

    public SelectionMatrix3D(SelectionMatrix3D other) {
        this.set(other);
    }

    public void clearSelectionFrame() {
        this.setSelectionFrame(null);
    }

    public void setSelectionFrame(ReferenceFrame selectionFrame) {
        this.selectionFrame = selectionFrame;
    }

    public void resetSelection() {
        this.selectionFrame = null;
        this.xSelected = true;
        this.ySelected = true;
        this.zSelected = true;
    }

    public void clearSelection() {
        this.selectionFrame = null;
        this.xSelected = false;
        this.ySelected = false;
        this.zSelected = false;
    }

    public void set(SelectionMatrix3D other) {
        this.selectionFrame = other.selectionFrame;
        this.xSelected = other.xSelected;
        this.ySelected = other.ySelected;
        this.zSelected = other.zSelected;
    }

    public void setAxisSelection(boolean xSelected, boolean ySelected, boolean zSelected) {
        this.xSelected = xSelected;
        this.ySelected = ySelected;
        this.zSelected = zSelected;
    }

    public void selectXAxis(boolean select) {
        this.xSelected = select;
    }

    public void selectYAxis(boolean select) {
        this.ySelected = select;
    }

    public void selectZAxis(boolean select) {
        this.zSelected = select;
    }

    public void selectAxis(int axisIndex, boolean select) {
        switch (axisIndex) {
            case 0: {
                this.selectXAxis(select);
                break;
            }
            case 1: {
                this.selectYAxis(select);
                break;
            }
            case 2: {
                this.selectZAxis(select);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(axisIndex));
            }
        }
    }

    public void applySelection(FrameVector3D vectorToBeModified) {
        ReferenceFrame vectorFrame = vectorToBeModified.getReferenceFrame();
        boolean canIgnoreSelectionFrame = this.canIgnoreSelectionFrame(vectorFrame);
        if (!canIgnoreSelectionFrame) {
            vectorToBeModified.changeFrame(this.selectionFrame);
        }
        vectorToBeModified.setX(this.xSelected ? vectorToBeModified.getX() : 0.0);
        vectorToBeModified.setY(this.ySelected ? vectorToBeModified.getY() : 0.0);
        vectorToBeModified.setZ(this.zSelected ? vectorToBeModified.getZ() : 0.0);
        if (!canIgnoreSelectionFrame) {
            vectorToBeModified.changeFrame(vectorFrame);
        }
    }

    public void getFullSelectionMatrixInFrame(ReferenceFrame destinationFrame, DMatrixRMaj selectionMatrixToPack) {
        this.getFullSelectionMatrixInFrame(destinationFrame, 0, 0, selectionMatrixToPack);
    }

    public void getFullSelectionMatrixInFrame(ReferenceFrame destinationFrame, int startRow, int startColumn, DMatrixRMaj selectionMatrixToPack) {
        int numRows = selectionMatrixToPack.getNumRows();
        int numCols = selectionMatrixToPack.getNumCols();
        if (numRows < startRow + 3 || numCols < startColumn + 3) {
            throw new MatrixDimensionException("The selection matrix has to be at least a " + (startRow + 3) + "-by-" + (startColumn + 3) + " but was instead a " + numRows + "-by-" + numCols + " matrix.");
        }
        if (this.canIgnoreSelectionFrame(destinationFrame)) {
            for (int row = startRow; row < startRow + 3; ++row) {
                for (int column = startColumn; column < startColumn + 3; ++column) {
                    selectionMatrixToPack.set(row, column, 0.0);
                }
            }
            selectionMatrixToPack.set(startRow++, startColumn++, this.xSelected ? 1.0 : 0.0);
            selectionMatrixToPack.set(startRow++, startColumn++, this.ySelected ? 1.0 : 0.0);
            selectionMatrixToPack.set(startRow, startColumn, this.zSelected ? 1.0 : 0.0);
        } else {
            this.frameMatrix.setToZero(this.selectionFrame);
            this.frameMatrix.setM00(this.xSelected ? 1.0 : 0.0);
            this.frameMatrix.setM11(this.ySelected ? 1.0 : 0.0);
            this.frameMatrix.setM22(this.zSelected ? 1.0 : 0.0);
            this.frameMatrix.changeFrame(destinationFrame);
            this.frameMatrix.get(startRow, startColumn, (DMatrix)selectionMatrixToPack);
        }
    }

    public void getEfficientSelectionMatrixInFrame(ReferenceFrame destinationFrame, DMatrixRMaj selectionMatrixToPack) {
        this.getCompactSelectionMatrixInFrame(destinationFrame, 0, 0, selectionMatrixToPack);
    }

    public void getCompactSelectionMatrixInFrame(ReferenceFrame destinationFrame, int startRow, int startColumn, DMatrixRMaj selectionMatrixToPack) {
        int numRows = selectionMatrixToPack.getNumRows();
        int numCols = selectionMatrixToPack.getNumCols();
        if (numRows < startRow + 3 || numCols < startColumn + 3) {
            throw new MatrixDimensionException("The selection matrix has to be at least a " + (startRow + 3) + "-by-" + (startColumn + 3) + " but was instead a " + numRows + "-by-" + numCols + " matrix.");
        }
        if (this.canIgnoreSelectionFrame(destinationFrame)) {
            for (int row = startRow; row < startRow + 3; ++row) {
                for (int column = startColumn; column < startColumn + 3; ++column) {
                    selectionMatrixToPack.set(row, column, 0.0);
                }
            }
            if (!this.zSelected) {
                MatrixTools.removeRow((DMatrix1Row)selectionMatrixToPack, (int)(startRow + 2));
            } else {
                selectionMatrixToPack.set(startRow + 2, startColumn + 2, 1.0);
            }
            if (!this.ySelected) {
                MatrixTools.removeRow((DMatrix1Row)selectionMatrixToPack, (int)(startRow + 1));
            } else {
                selectionMatrixToPack.set(startRow + 1, startColumn + 1, 1.0);
            }
            if (!this.xSelected) {
                MatrixTools.removeRow((DMatrix1Row)selectionMatrixToPack, (int)startRow);
            } else {
                selectionMatrixToPack.set(startRow, startColumn, 1.0);
            }
        } else {
            this.frameMatrix.setToZero(this.selectionFrame);
            this.frameMatrix.setM00(this.xSelected ? 1.0 : 0.0);
            this.frameMatrix.setM11(this.ySelected ? 1.0 : 0.0);
            this.frameMatrix.setM22(this.zSelected ? 1.0 : 0.0);
            this.frameMatrix.changeFrame(destinationFrame);
            this.frameMatrix.get(startRow, startColumn, (DMatrix)selectionMatrixToPack);
            MatrixTools.removeZeroRows((DMatrix1Row)selectionMatrixToPack, (int)startRow, (int)(startRow + 2), (double)1.0E-7);
        }
    }

    private boolean canIgnoreSelectionFrame(ReferenceFrame destinationFrame) {
        if (this.selectionFrame == null) {
            return true;
        }
        if (this.selectionFrame == destinationFrame) {
            return true;
        }
        if (this.xSelected && this.ySelected && this.zSelected) {
            return true;
        }
        return !this.xSelected && !this.ySelected && !this.zSelected;
    }

    public boolean isXSelected() {
        return this.xSelected;
    }

    public boolean isYSelected() {
        return this.ySelected;
    }

    public boolean isZSelected() {
        return this.zSelected;
    }

    public boolean isAxisSelected(int axisIndex) {
        switch (axisIndex) {
            case 0: {
                return this.isXSelected();
            }
            case 1: {
                return this.isYSelected();
            }
            case 2: {
                return this.isZSelected();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(axisIndex));
    }

    public int getNumberOfSelectedAxes() {
        return (this.isXSelected() ? 1 : 0) + (this.isYSelected() ? 1 : 0) + (this.isZSelected() ? 1 : 0);
    }

    public ReferenceFrame getSelectionFrame() {
        return this.selectionFrame;
    }

    public String toString() {
        return "(" + this.xSelected + ", " + this.ySelected + ", " + this.zSelected + ") " + String.valueOf(this.selectionFrame);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.selectionFrame == null ? 0 : this.selectionFrame.hashCode());
        result = 31 * result + (this.xSelected ? 1231 : 1237);
        result = 31 * result + (this.ySelected ? 1231 : 1237);
        result = 31 * result + (this.zSelected ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectionMatrix3D other = (SelectionMatrix3D)obj;
        if (this.selectionFrame == null ^ other.selectionFrame == null) {
            return false;
        }
        if (this.selectionFrame != null && this.selectionFrame.hashCode() != other.selectionFrame.hashCode()) {
            return false;
        }
        if (this.xSelected != other.xSelected) {
            return false;
        }
        if (this.ySelected != other.ySelected) {
            return false;
        }
        return this.zSelected == other.zSelected;
    }
}

