/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.ArrayList;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public abstract class AbstractInverseDynamicsCopier {
    private final ArrayList<ImmutablePair<JointBasics, JointBasics>> jointPairs = new ArrayList();

    public AbstractInverseDynamicsCopier(RigidBodyBasics originalBody, RigidBodyBasics targetBody) {
        this.setRigidBodies(originalBody, targetBody);
    }

    public void setRigidBodies(RigidBodyBasics originalBody, RigidBodyBasics targetBody) {
        this.jointPairs.clear();
        JointBasics[] originalJoints = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{originalBody});
        JointBasics[] targetJoints = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{targetBody});
        for (int i = 0; i < originalJoints.length; ++i) {
            JointBasics originalJoint = originalJoints[i];
            JointBasics targetJoint = targetJoints[i];
            AbstractInverseDynamicsCopier.areJointsTheSame(originalJoint, targetJoint);
            ImmutablePair jointPair = new ImmutablePair((Object)originalJoint, (Object)targetJoint);
            this.jointPairs.add((ImmutablePair<JointBasics, JointBasics>)jointPair);
        }
    }

    public final void copy() {
        for (int i = 0; i < this.jointPairs.size(); ++i) {
            ImmutablePair<JointBasics, JointBasics> jointPair = this.jointPairs.get(i);
            JointBasics originalJoint = (JointBasics)jointPair.getLeft();
            JointBasics targetJoint = (JointBasics)jointPair.getRight();
            this.copyJoint(originalJoint, targetJoint);
        }
    }

    protected abstract void copyJoint(JointBasics var1, JointBasics var2);

    private static final void areJointsTheSame(JointBasics originalJoint, JointBasics targetJoint) {
        if (!originalJoint.getClass().equals(targetJoint.getClass()) || !originalJoint.getName().equals(targetJoint.getName())) {
            throw new RuntimeException(originalJoint.getName() + " differs from " + String.valueOf(targetJoint));
        }
    }
}

