/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotSide;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SegmentDependentList;

public class SideDependentList<V>
extends SegmentDependentList<RobotSide, V>
implements Iterable<V> {
    private final transient RobotSide[][] sideArrays = new RobotSide[3][];
    private static final long serialVersionUID = -6514328471068877058L;

    public SideDependentList() {
        super(RobotSide.class);
        this.sideArrays[0] = new RobotSide[0];
        this.sideArrays[1] = new RobotSide[1];
        this.sideArrays[2] = RobotSide.values;
    }

    public SideDependentList(V leftObject, V rightObject) {
        super(RobotSide.class);
        this.sideArrays[0] = new RobotSide[0];
        this.sideArrays[1] = new RobotSide[1];
        this.sideArrays[2] = RobotSide.values;
        this.put(RobotSide.LEFT, leftObject);
        this.put(RobotSide.RIGHT, rightObject);
    }

    public SideDependentList(Supplier<V> valueSupplier) {
        super(RobotSide.class);
        this.sideArrays[0] = new RobotSide[0];
        this.sideArrays[1] = new RobotSide[1];
        this.sideArrays[2] = RobotSide.values;
        this.put(RobotSide.LEFT, valueSupplier.get());
        this.put(RobotSide.RIGHT, valueSupplier.get());
    }

    public SideDependentList(Function<RobotSide, V> valueFunction) {
        super(RobotSide.class);
        this.sideArrays[0] = new RobotSide[0];
        this.sideArrays[1] = new RobotSide[1];
        this.sideArrays[2] = RobotSide.values;
        this.put(RobotSide.LEFT, valueFunction.apply(RobotSide.LEFT));
        this.put(RobotSide.RIGHT, valueFunction.apply(RobotSide.RIGHT));
    }

    public SideDependentList(SegmentDependentList<RobotSide, ? extends V> other) {
        super(RobotSide.class);
        this.sideArrays[0] = new RobotSide[0];
        this.sideArrays[1] = new RobotSide[1];
        this.sideArrays[2] = RobotSide.values;
        for (RobotSide robotSide : RobotSide.values) {
            this.set(robotSide, other.get(robotSide));
        }
    }

    public void set(SideDependentList<V> sideDependentList) {
        for (RobotSide robotSide : RobotSide.values) {
            this.set(robotSide, sideDependentList.get(robotSide));
        }
    }

    public void set(Function<RobotSide, V> valueFunction) {
        for (RobotSide robotSide : RobotSide.values) {
            this.put(robotSide, valueFunction.apply(robotSide));
        }
    }

    public RobotSide[] sides() {
        this.fillSideArray();
        return this.sideArrays[this.size()];
    }

    private void fillSideArray() {
        if (this.size() == 2) {
            return;
        }
        int j = 0;
        for (int i = 0; i < RobotSide.values.length; ++i) {
            if (!this.containsKey(RobotSide.values[i])) continue;
            this.sideArrays[this.size()][j++] = RobotSide.values[i];
        }
    }

    @Override
    public String toString() {
        return new String("type: " + String.valueOf(this.getClass()) + "\nleft: " + String.valueOf(this.get(RobotSide.LEFT)) + "\nright: " + String.valueOf(this.get(RobotSide.RIGHT)));
    }

    public static <K extends Enum<K>, V> SideDependentList<EnumMap<K, V>> createListOfEnumMaps(Class<K> keyType) {
        return new SideDependentList(new EnumMap(keyType), new EnumMap(keyType));
    }

    public static <K, V> SideDependentList<Map<K, V>> createListOfHashMaps() {
        return new SideDependentList<Map<K, V>>(new LinkedHashMap(), new LinkedHashMap());
    }

    public static <V> SideDependentList<ArrayList<V>> createListOfArrayLists() {
        return new SideDependentList<ArrayList<V>>(new ArrayList(), new ArrayList());
    }

    @Override
    public Iterator<V> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<V> {
        private int state = 0;

        @Override
        public boolean hasNext() {
            return this.state < 2;
        }

        @Override
        public V next() {
            if (this.state == 0) {
                ++this.state;
                return SideDependentList.this.get(RobotSide.LEFT);
            }
            if (this.state == 1) {
                ++this.state;
                return SideDependentList.this.get(RobotSide.RIGHT);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove elements from a SideDependentList.");
        }
    }
}

