/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotSide;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import us.ihmc.robotics.robotSide.RobotEnd;

public class EndDependentList<V>
extends EnumMap<RobotEnd, V>
implements Iterable<V> {
    private static final long serialVersionUID = -6514328471068877058L;

    public EndDependentList() {
        super(RobotEnd.class);
    }

    public EndDependentList(V hindObject, V frontObject) {
        super(RobotEnd.class);
        this.put(RobotEnd.HIND, hindObject);
        this.put(RobotEnd.FRONT, frontObject);
    }

    public EndDependentList(EndDependentList<V> other) {
        super(RobotEnd.class);
        for (RobotEnd robotEnd : RobotEnd.values) {
            this.set(robotEnd, other.get(robotEnd));
        }
    }

    public V get(RobotEnd robotEnd) {
        return super.get((Object)robotEnd);
    }

    @Override
    public String toString() {
        return new String("type: " + String.valueOf(this.getClass()) + "\nhind: " + String.valueOf(this.get(RobotEnd.HIND)) + "\nfront: " + String.valueOf(this.get(RobotEnd.FRONT)));
    }

    public V set(RobotEnd robotEnd, V element) {
        return this.put(robotEnd, element);
    }

    public void set(EndDependentList<V> endDependentList) {
        for (RobotEnd robotEnd : RobotEnd.values) {
            this.set(robotEnd, endDependentList.get(robotEnd));
        }
    }

    public static <K extends Enum<K>, V> EndDependentList<EnumMap<K, V>> createListOfEnumMaps(Class<K> keyType) {
        return new EndDependentList(new EnumMap(keyType), new EnumMap(keyType));
    }

    public static <K, V> EndDependentList<Map<K, V>> createListOfHashMaps() {
        return new EndDependentList<Map<K, V>>(new LinkedHashMap(), new LinkedHashMap());
    }

    public static <V> EndDependentList<ArrayList<V>> createListOfArrayLists() {
        return new EndDependentList<ArrayList<V>>(new ArrayList(), new ArrayList());
    }

    @Override
    public Iterator<V> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<V> {
        private int state = 0;

        @Override
        public boolean hasNext() {
            return this.state < 2;
        }

        @Override
        public V next() {
            if (this.state == 0) {
                ++this.state;
                return EndDependentList.this.get(RobotEnd.HIND);
            }
            if (this.state == 1) {
                ++this.state;
                return EndDependentList.this.get(RobotEnd.FRONT);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove elements from a EndDependentList.");
        }
    }
}

