/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import us.ihmc.euclid.referenceFrame.FrameOrientation2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePose2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public class Pose2dReferenceFrame
extends ReferenceFrame {
    private final FramePose2D originPose;

    public Pose2dReferenceFrame(String frameName, ReferenceFrame parentFrame) {
        super(frameName, parentFrame);
        this.originPose = new FramePose2D(parentFrame);
    }

    public Pose2dReferenceFrame(String frameName, FramePose2D pose) {
        this(frameName, pose.getReferenceFrame());
        this.setPoseAndUpdate(pose);
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.originPose.get((RigidBodyTransformBasics)transformToParent);
    }

    public void setPositionAndUpdate(FramePoint2D framePoint) {
        framePoint.checkReferenceFrameMatch(this.getParent());
        this.originPose.getPosition().set((FrameTuple2DReadOnly)framePoint);
        this.update();
    }

    public void setOrientationAndUpdate(FrameOrientation2D frameOrientation) {
        frameOrientation.checkReferenceFrameMatch(this.getParent());
        this.originPose.getOrientation().set((FrameOrientation2DReadOnly)frameOrientation);
        this.update();
    }

    public void setPoseAndUpdate(Point2DReadOnly position, double orientation) {
        this.originPose.getPosition().set((Tuple2DReadOnly)position);
        this.originPose.getOrientation().setYaw(orientation);
        this.update();
    }

    public void setPoseAndUpdate(FramePose2D pose) {
        this.originPose.set(pose);
        this.update();
    }

    public void setPoseAndUpdate(FramePoint2D position, FrameOrientation2D orientation) {
        position.changeFrame(this.originPose.getReferenceFrame());
        this.originPose.getPosition().set((FrameTuple2DReadOnly)position);
        orientation.changeFrame(this.originPose.getReferenceFrame());
        this.originPose.getOrientation().set((FrameOrientation2DReadOnly)orientation);
        this.update();
    }

    public FramePose2D getPoseCopy() {
        return new FramePose2D((FramePose2DReadOnly)this.originPose);
    }

    public String toString() {
        return super.toString() + ", originPose = " + String.valueOf(this.originPose);
    }
}

