/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class MidFootZUpGroundFrame
extends ReferenceFrame {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final ReferenceFrame frameOne;
    private final ReferenceFrame frameTwo;
    private final FramePose3D framePose = new FramePose3D();
    private final FramePose3D poseOne = new FramePose3D();
    private final FramePose3D poseTwo = new FramePose3D();

    public MidFootZUpGroundFrame(String name, ReferenceFrame frameOne, ReferenceFrame frameTwo) {
        super(name, worldFrame, false, true);
        this.frameOne = frameOne;
        this.frameTwo = frameTwo;
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.poseOne.setToZero(this.frameOne);
        this.poseTwo.setToZero(this.frameTwo);
        this.poseOne.changeFrame(worldFrame);
        this.poseTwo.changeFrame(worldFrame);
        this.framePose.interpolate((FramePose3DReadOnly)this.poseOne, (FramePose3DReadOnly)this.poseTwo, 0.5);
        transformToParent.setIdentity();
        transformToParent.setRotationYawAndZeroTranslation(this.framePose.getYaw());
        transformToParent.getTranslation().set((Tuple3DReadOnly)this.framePose.getPosition());
        transformToParent.getTranslation().setZ(Math.min(this.poseOne.getZ(), this.poseTwo.getZ()));
    }
}

