/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.optimization.constrainedOptimization;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.mult.VectorVectorMult_DDRM;
import us.ihmc.math.linearAlgebra.careSolvers.MatrixToolsLocal;

public class AugmentedLagrangeConstructor {
    private double penalty;
    private final double penaltyIncreaseFactor;
    private final DMatrixD1 equalityMultiplier;
    private final DMatrixD1 inequalityMultiplier;

    public AugmentedLagrangeConstructor(double initialPenalty, double penaltyIncreaseFactor, int numEqualityConstraints, int numInequalityConstraints) {
        this.equalityMultiplier = new DMatrixRMaj(numEqualityConstraints, 1);
        this.inequalityMultiplier = new DMatrixRMaj(numInequalityConstraints, 1);
        this.penalty = initialPenalty;
        this.penaltyIncreaseFactor = penaltyIncreaseFactor;
    }

    public double getAugmentedLagrangeCost(double originalCost, DMatrixD1 equalityConstraintEvaluations, DMatrixD1 inequalityConstraintEvaluations) {
        double inequalityConstraintCost = AugmentedLagrangeConstructor.getInequalityConstraintCost(inequalityConstraintEvaluations, this.inequalityMultiplier, this.penalty);
        double equalityConstraintCost = AugmentedLagrangeConstructor.getEqualityConstraintCost(equalityConstraintEvaluations, this.equalityMultiplier, this.penalty);
        return originalCost + inequalityConstraintCost + equalityConstraintCost;
    }

    private static double getEqualityConstraintCost(DMatrixD1 equalityConstraintValue, DMatrixD1 equalityMultiplierK, double penalty) {
        return penalty / 2.0 * VectorVectorMult_DDRM.innerProd((DMatrixD1)equalityConstraintValue, (DMatrixD1)equalityConstraintValue) + VectorVectorMult_DDRM.innerProd((DMatrixD1)equalityMultiplierK, (DMatrixD1)equalityConstraintValue);
    }

    private static double getInequalityConstraintCost(DMatrixD1 inequalityConstraintValues, DMatrixD1 inequalityMultiplier, double penalty) {
        DMatrixD1 inequalityConstraintBarrierValue = AugmentedLagrangeConstructor.calculateBarrierInequalityConstraintValue(inequalityConstraintValues, inequalityMultiplier, penalty);
        return 1.0 / (2.0 * penalty) * (VectorVectorMult_DDRM.innerProd((DMatrixD1)inequalityConstraintBarrierValue, (DMatrixD1)inequalityConstraintBarrierValue) - VectorVectorMult_DDRM.innerProd((DMatrixD1)inequalityMultiplier, (DMatrixD1)inequalityMultiplier));
    }

    private static DMatrixD1 calculateBarrierInequalityConstraintValue(DMatrixD1 inequalityConstraintValue, DMatrixD1 inequalityMultiplier, double penalty) {
        DMatrixRMaj barrierInequalityValue = new DMatrixRMaj((DMatrix)inequalityMultiplier);
        CommonOps_DDRM.add((DMatrixD1)inequalityMultiplier, (double)(-penalty), (DMatrixD1)inequalityConstraintValue, (DMatrixD1)barrierInequalityValue);
        MatrixToolsLocal.elementWiseMin((DMatrixD1)barrierInequalityValue, (double)0.0);
        return barrierInequalityValue;
    }

    public void updateLagrangeMultipliers(DMatrixD1 optimalEqualityConstraintEvaluations, DMatrixD1 optimalInequalityConstraintEvaluations) {
        this.inequalityMultiplier.set(AugmentedLagrangeConstructor.calculateBarrierInequalityConstraintValue(optimalInequalityConstraintEvaluations, this.inequalityMultiplier, this.penalty));
        CommonOps_DDRM.addEquals((DMatrixD1)this.equalityMultiplier, (double)this.penalty, (DMatrixD1)optimalEqualityConstraintEvaluations);
        this.penalty *= this.penaltyIncreaseFactor;
    }
}

