/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.occupancyGrid;

import java.util.List;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.robotics.occupancyGrid.OccupancyGrid;
import us.ihmc.robotics.occupancyGrid.OccupancyGridCell;
import us.ihmc.robotics.robotSide.RobotSide;

public class OccupancyGridTools {
    public static void computeConvexHullOfOccupancyGrid(OccupancyGrid occupancyGrid, FrameConvexPolygon2D convexHullToPack) {
        convexHullToPack.clear(occupancyGrid.getGridFrame());
        List<OccupancyGridCell> activeCells = occupancyGrid.getAllActiveCells();
        for (int i = 0; i < activeCells.size(); ++i) {
            OccupancyGridCell cell = activeCells.get(i);
            if (!cell.getIsOccupied()) continue;
            convexHullToPack.addVertex(occupancyGrid.getXLocation(cell.getXIndex()), occupancyGrid.getYLocation(cell.getYIndex()));
        }
        convexHullToPack.update();
    }

    public static int computeNumberOfCellsOccupiedOnSideOfLine(OccupancyGrid occupancyGrid, FrameLine2DReadOnly frameLine, RobotSide sideToLookAt, double minDistanceFromLine) {
        ReferenceFrame gridFrame = occupancyGrid.getGridFrame();
        frameLine.checkReferenceFrameMatch(gridFrame);
        double shiftingVectorX = -frameLine.getDirectionY();
        double shiftingVectorY = frameLine.getDirectionX();
        if (sideToLookAt == RobotSide.RIGHT) {
            shiftingVectorX = -shiftingVectorX;
            shiftingVectorY = -shiftingVectorY;
        }
        double theta = Math.atan2(frameLine.getDirection().getY(), frameLine.getDirection().getX());
        double cellXSize = occupancyGrid.getCellXSize();
        double cellYSize = occupancyGrid.getCellYSize();
        double distanceToMoveAwayFromLine = Math.max(minDistanceFromLine, Math.abs(cellXSize * Math.cos(theta) + cellYSize * Math.sin(theta)));
        double linePointX = frameLine.getPointX() + (shiftingVectorX *= distanceToMoveAwayFromLine);
        double linePointY = frameLine.getPointY() + (shiftingVectorY *= distanceToMoveAwayFromLine);
        double lineDirectionX = frameLine.getDirectionX();
        double lineDirectionY = frameLine.getDirectionY();
        int numberOfCellsActivatedOnSideToLookAt = 0;
        List<OccupancyGridCell> activeCells = occupancyGrid.getAllActiveCells();
        for (int i = 0; i < activeCells.size(); ++i) {
            double cellY;
            OccupancyGridCell cell = activeCells.get(i);
            double cellX = occupancyGrid.getXLocation(cell.getXIndex());
            if (!EuclidGeometryTools.isPoint2DOnSideOfLine2D((double)cellX, (double)(cellY = occupancyGrid.getXLocation(cell.getYIndex())), (double)linePointX, (double)linePointY, (double)lineDirectionX, (double)lineDirectionY, (sideToLookAt == RobotSide.LEFT ? 1 : 0) != 0) || !cell.getIsOccupied()) continue;
            ++numberOfCellsActivatedOnSideToLookAt;
        }
        return numberOfCellsActivatedOnSideToLookAt;
    }
}

