/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FixedFrameEuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FixedFrameSO3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSE3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSE3WaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SE3WaypointReadOnly;

public class FrameSE3Waypoint
implements FrameSE3WaypointBasics {
    private ReferenceFrame referenceFrame;
    private final FixedFrameEuclideanWaypointBasics euclideanWaypoint = FixedFrameEuclideanWaypointBasics.newFixedFrameEuclideanWaypointBasics((ReferenceFrameHolder)this);
    private final FixedFrameSO3WaypointBasics so3Waypoint = FixedFrameSO3WaypointBasics.newFixedFrameSO3WaypointBasics((ReferenceFrameHolder)this);

    public FrameSE3Waypoint() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameSE3Waypoint(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameSE3Waypoint(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly linearVelocity, FrameVector3DReadOnly angularVelocity) {
        this.setIncludingFrame(position, orientation, linearVelocity, angularVelocity);
    }

    public FrameSE3Waypoint(ReferenceFrame referenceFrame, SE3WaypointReadOnly waypoint) {
        this.setIncludingFrame(referenceFrame, waypoint);
    }

    @Override
    public FixedFrameEuclideanWaypointBasics getEuclideanWaypoint() {
        return this.euclideanWaypoint;
    }

    @Override
    public FixedFrameSO3WaypointBasics getSO3Waypoint() {
        return this.so3Waypoint;
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getEuclideanWaypoint(), (Object)this.getSO3Waypoint());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FrameSE3WaypointReadOnly) {
            return this.equals((FrameSE3WaypointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

