/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.lists;

import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSO3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameTrajectoryPointListBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.lists.FrameSE3TrajectoryPointList;

public class FrameSO3TrajectoryPointList
implements FrameTrajectoryPointListBasics<FrameSO3TrajectoryPoint> {
    private ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
    private final RecyclingArrayList<FrameSO3TrajectoryPoint> trajectoryPoints = new RecyclingArrayList(FrameSO3TrajectoryPoint.class);

    @Override
    public void clear() {
        this.trajectoryPoints.clear();
    }

    public void addTrajectoryPoint(double time, QuaternionReadOnly orientation, Vector3DReadOnly angularVelocity) {
        ((FrameSO3TrajectoryPoint)this.trajectoryPoints.add()).setIncludingFrame(this.getReferenceFrame(), time, (Orientation3DReadOnly)orientation, angularVelocity);
    }

    @Override
    public void addTrajectoryPoint(FrameSO3TrajectoryPoint trajectoryPoint) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)trajectoryPoint);
        ((FrameSO3TrajectoryPoint)this.trajectoryPoints.add()).setIncludingFrame(trajectoryPoint);
    }

    @Override
    public void addTrajectoryPoint(SO3TrajectoryPointBasics trajectoryPoint) {
        FrameSO3TrajectoryPoint newTrajectoryPoint = (FrameSO3TrajectoryPoint)this.trajectoryPoints.add();
        newTrajectoryPoint.setToZero(this.getReferenceFrame());
        newTrajectoryPoint.set(trajectoryPoint);
    }

    public void setIncludingFrame(FrameSE3TrajectoryPointList trajectoryPointList) {
        this.clear(trajectoryPointList.getReferenceFrame());
        for (int i = 0; i < trajectoryPointList.getNumberOfTrajectoryPoints(); ++i) {
            this.addTrajectoryPoint(trajectoryPointList.getTrajectoryPoint(i));
        }
    }

    @Override
    public FrameSO3TrajectoryPoint getTrajectoryPoint(int trajectoryPointIndex) {
        return (FrameSO3TrajectoryPoint)this.trajectoryPoints.get(trajectoryPointIndex);
    }

    @Override
    public int getNumberOfTrajectoryPoints() {
        return this.trajectoryPoints.size();
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
        for (int i = 0; i < this.trajectoryPoints.size(); ++i) {
            ((FrameSO3TrajectoryPoint)this.trajectoryPoints.get(i)).setReferenceFrame(referenceFrame);
        }
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public String toString() {
        return "Frame SO3 trajectory: number of frame SO3 trajectory points = " + this.getNumberOfTrajectoryPoints() + ".";
    }
}

