/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import java.text.DecimalFormat;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.OneDoFTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.YoOneDoFWaypoint;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoOneDoFTrajectoryPoint
implements OneDoFTrajectoryPointBasics {
    private final String namePrefix;
    private final String nameSuffix;
    private final YoOneDoFWaypoint waypoint;
    private final YoDouble time;

    public YoOneDoFTrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.waypoint = new YoOneDoFWaypoint(namePrefix, nameSuffix, registry);
    }

    @Override
    public void setPosition(double position) {
        this.waypoint.setPosition(position);
    }

    @Override
    public void setVelocity(double velocity) {
        this.waypoint.setVelocity(velocity);
    }

    @Override
    public double getPosition() {
        return this.waypoint.getPosition();
    }

    @Override
    public double getVelocity() {
        return this.waypoint.getVelocity();
    }

    @Override
    public void setTime(double time) {
        this.time.set(time);
    }

    @Override
    public double getTime() {
        return this.time.getValue();
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public String toString() {
        DecimalFormat doubleFormat = new DecimalFormat(" 0.00;-0.00");
        String timeString = "time = " + doubleFormat.format(this.getTime());
        return "Trajectory point 1D: (" + timeString + ", " + String.valueOf(this.waypoint) + ")";
    }
}

