/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.YoEuclideanWaypoint;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoEuclideanTrajectoryPoint
implements EuclideanTrajectoryPointBasics {
    private final YoEuclideanWaypoint euclideanWaypoint;
    private final YoDouble time;
    private final String namePrefix;
    private final String nameSuffix;

    public YoEuclideanTrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.euclideanWaypoint = new YoEuclideanWaypoint(namePrefix, nameSuffix, registry);
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
    }

    public YoDouble getYoX() {
        return this.euclideanWaypoint.getYoX();
    }

    public YoDouble getYoY() {
        return this.euclideanWaypoint.getYoY();
    }

    public YoDouble getYoZ() {
        return this.euclideanWaypoint.getYoZ();
    }

    @Override
    public Point3DBasics getPosition() {
        return this.euclideanWaypoint.getPosition();
    }

    @Override
    public Vector3DBasics getLinearVelocity() {
        return this.euclideanWaypoint.getLinearVelocity();
    }

    @Override
    public void setTime(double time) {
        this.time.set(time);
    }

    @Override
    public double getTime() {
        return this.time.getValue();
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getTime(), (Object)this.getPosition(), (Object)this.getLinearVelocity());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FrameEuclideanTrajectoryPointReadOnly) {
            return this.equals((FrameEuclideanTrajectoryPointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

