/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToDoubleFunction;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.AxisAngleConversion;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.SimpleHermiteCurvedBasedOrientationTrajectoryCalculator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSO3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.lists.FrameSO3TrajectoryPointList;
import us.ihmc.robotics.numericalMethods.GradientDescentModule;

public class SO3TrajectoryPointCalculator {
    private static final boolean debug = false;
    private static final int maxIterations = 100;
    private static final double convergenceThreshold = 1.0E-4;
    private static final double velocitOptimizerDT = 0.01;
    private static final double optimizerStepSize = -0.1;
    private static final double optimizerPerturbationSize = 1.0E-4;
    private final FrameSO3TrajectoryPointList trajectoryPoints = new FrameSO3TrajectoryPointList();
    private final TDoubleArrayList times = new TDoubleArrayList();
    private final List<QuaternionBasics> orientations = new ArrayList<QuaternionBasics>();
    private final List<Vector3DBasics> angularVelocities = new ArrayList<Vector3DBasics>();
    private final SimpleHermiteCurvedBasedOrientationTrajectoryCalculator trajectoryCalculator = new SimpleHermiteCurvedBasedOrientationTrajectoryCalculator();

    public void clear() {
        this.times.clear();
        this.orientations.clear();
        this.angularVelocities.clear();
    }

    public void appendTrajectoryPoint(double time, QuaternionBasics orientation) {
        this.times.add(time);
        this.orientations.add((QuaternionBasics)new Quaternion((QuaternionReadOnly)orientation));
        this.angularVelocities.add((Vector3DBasics)new Vector3D());
    }

    public void appendTrajectoryPoint(double time, QuaternionBasics orientation, Vector3DBasics angularVelocity) {
        this.times.add(time);
        this.orientations.add((QuaternionBasics)new Quaternion((QuaternionReadOnly)orientation));
        this.angularVelocities.add((Vector3DBasics)new Vector3D((Tuple3DReadOnly)angularVelocity));
    }

    public void useFirstOrderInitialGuess() {
        for (int i = 1; i < this.times.size() - 1; ++i) {
            double timeDiff = this.times.get(i + 1) - this.times.get(i);
            Quaternion orientationDiff = new Quaternion();
            orientationDiff.set((QuaternionReadOnly)this.orientations.get(i));
            orientationDiff.conjugate();
            orientationDiff.multiply((QuaternionReadOnly)this.orientations.get(i + 1));
            AxisAngle orientationDiffAxisAngle = new AxisAngle((Orientation3DReadOnly)orientationDiff);
            AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)orientationDiff, (AxisAngleBasics)orientationDiffAxisAngle);
            orientationDiffAxisAngle.setAngle(orientationDiffAxisAngle.getAngle() / timeDiff);
            Vector3D angularVelocity = new Vector3D();
            angularVelocity.setX(orientationDiffAxisAngle.getX() * orientationDiffAxisAngle.getAngle());
            angularVelocity.setY(orientationDiffAxisAngle.getY() * orientationDiffAxisAngle.getAngle());
            angularVelocity.setZ(orientationDiffAxisAngle.getZ() * orientationDiffAxisAngle.getAngle());
            this.angularVelocities.get(i).set((Tuple3DReadOnly)angularVelocity);
        }
    }

    public void useSecondOrderInitialGuess() {
        TDoubleArrayList defaultInitialAngularVelocitiesInDoubleArray = new TDoubleArrayList();
        for (int i = 1; i < this.times.size() - 1; ++i) {
            for (int j = 0; j < 3; ++j) {
                defaultInitialAngularVelocitiesInDoubleArray.add(this.angularVelocities.get(i).getElement(j));
            }
        }
        SO3TrajectoryPointOptimizerCostFunction function = new SO3TrajectoryPointOptimizerCostFunction();
        double defaultQuery = function.applyAsDouble(defaultInitialAngularVelocitiesInDoubleArray);
        for (int i = 1; i < this.times.size() - 1; ++i) {
            double timeDiff = this.times.get(i + 1) - this.times.get(i - 1);
            Quaternion orientationDiff = new Quaternion();
            orientationDiff.set((QuaternionReadOnly)this.orientations.get(i - 1));
            orientationDiff.conjugate();
            orientationDiff.multiply((QuaternionReadOnly)this.orientations.get(i + 1));
            AxisAngle orientationDiffAxisAngle = new AxisAngle((Orientation3DReadOnly)orientationDiff);
            AxisAngleConversion.convertQuaternionToAxisAngle((QuaternionReadOnly)orientationDiff, (AxisAngleBasics)orientationDiffAxisAngle);
            orientationDiffAxisAngle.setAngle(orientationDiffAxisAngle.getAngle() / timeDiff);
            Vector3D angularVelocity = new Vector3D();
            angularVelocity.setX(orientationDiffAxisAngle.getX() * orientationDiffAxisAngle.getAngle());
            angularVelocity.setY(orientationDiffAxisAngle.getY() * orientationDiffAxisAngle.getAngle());
            angularVelocity.setZ(orientationDiffAxisAngle.getZ() * orientationDiffAxisAngle.getAngle());
            this.angularVelocities.get(i).set((Tuple3DReadOnly)angularVelocity);
        }
        TDoubleArrayList initialAngularVelocitiesInDoubleArray = new TDoubleArrayList();
        for (int i = 1; i < this.times.size() - 1; ++i) {
            for (int j = 0; j < 3; ++j) {
                initialAngularVelocitiesInDoubleArray.add(this.angularVelocities.get(i).getElement(j));
            }
        }
        double modifiedQuery = function.applyAsDouble(initialAngularVelocitiesInDoubleArray);
        if (modifiedQuery > defaultQuery) {
            int arrayIndex = 0;
            for (int i = 1; i < this.times.size() - 1; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.angularVelocities.get(i).setElement(j, defaultInitialAngularVelocitiesInDoubleArray.get(arrayIndex));
                    ++arrayIndex;
                }
            }
        }
    }

    public void compute() {
        if (this.times.size() != this.orientations.size()) {
            throw new RuntimeException("size are not matched. (times) " + this.times.size() + ", (orientations) " + this.orientations.size());
        }
        if (MathTools.epsilonEquals((double)this.times.get(0), (double)0.0, (double)1.0E-4)) {
            this.times.replace(0, 0.0);
        }
        int numberOfPoints = this.times.size();
        TDoubleArrayList initialAngularVelocitiesInDoubleArray = new TDoubleArrayList();
        for (int i = 1; i < numberOfPoints - 1; ++i) {
            for (int j = 0; j < 3; ++j) {
                initialAngularVelocitiesInDoubleArray.add(this.angularVelocities.get(i).getElement(j));
            }
        }
        SO3TrajectoryPointOptimizerCostFunction function = new SO3TrajectoryPointOptimizerCostFunction();
        GradientDescentModule optimizer = new GradientDescentModule(function, initialAngularVelocitiesInDoubleArray);
        optimizer.setMaximumIterations(100);
        optimizer.setConvergenceThreshold(1.0E-4);
        optimizer.setLearningRate(-0.1);
        optimizer.setPerturbationSize(1.0E-4);
        ArrayList<Vector3D> initialAngularVelocities = new ArrayList<Vector3D>();
        for (int i = 0; i < numberOfPoints; ++i) {
            initialAngularVelocities.add(new Vector3D((Tuple3DReadOnly)this.angularVelocities.get(i)));
        }
        int numberOfIterationToSolve = optimizer.run();
        this.updateTrajectoryPoints();
    }

    private void updateTrajectoryPoints() {
        this.trajectoryPoints.clear();
        for (int i = 0; i < this.times.size(); ++i) {
            this.trajectoryPoints.addTrajectoryPoint(this.times.get(i), (QuaternionReadOnly)this.orientations.get(i), (Vector3DReadOnly)this.angularVelocities.get(i));
        }
    }

    public int getNumberOfTrajectoryPoints() {
        return this.trajectoryPoints.getNumberOfTrajectoryPoints();
    }

    public FrameSO3TrajectoryPoint getTrajectoryPoint(int i) {
        return this.trajectoryPoints.getTrajectoryPoint(i);
    }

    private int getSegmentIndex(double time) {
        int segmentIndex = 0;
        for (int i = 0; i < this.times.size() - 1; ++i) {
            if (!(time < this.times.get(i + 1))) continue;
            segmentIndex = i;
            break;
        }
        return segmentIndex;
    }

    private class SO3TrajectoryPointOptimizerCostFunction
    implements ToDoubleFunction<TDoubleArrayList> {
        private SO3TrajectoryPointOptimizerCostFunction() {
        }

        @Override
        public double applyAsDouble(TDoubleArrayList values) {
            int numberOfPoints = SO3TrajectoryPointCalculator.this.times.size();
            int optimalSolutionIndex = 0;
            for (int i = 1; i < numberOfPoints - 1; ++i) {
                SO3TrajectoryPointCalculator.this.angularVelocities.get(i).setX(values.get(optimalSolutionIndex));
                SO3TrajectoryPointCalculator.this.angularVelocities.get(i).setY(values.get(++optimalSolutionIndex));
                SO3TrajectoryPointCalculator.this.angularVelocities.get(i).setZ(values.get(++optimalSolutionIndex));
                ++optimalSolutionIndex;
            }
            int numberOfTicks = (int)(SO3TrajectoryPointCalculator.this.times.get(SO3TrajectoryPointCalculator.this.times.size() - 1) / 0.01);
            double time = 0.0;
            double cost = 0.0;
            int previousSegmentIndex = -1;
            for (int i = 0; i < numberOfTicks; ++i) {
                int segmentIndex = SO3TrajectoryPointCalculator.this.getSegmentIndex(time);
                if (previousSegmentIndex != segmentIndex) {
                    SO3TrajectoryPointCalculator.this.trajectoryCalculator.setInitialConditions((QuaternionReadOnly)SO3TrajectoryPointCalculator.this.orientations.get(segmentIndex), (Vector3DReadOnly)SO3TrajectoryPointCalculator.this.angularVelocities.get(segmentIndex));
                    SO3TrajectoryPointCalculator.this.trajectoryCalculator.setFinalConditions((QuaternionReadOnly)SO3TrajectoryPointCalculator.this.orientations.get(segmentIndex + 1), (Vector3DReadOnly)SO3TrajectoryPointCalculator.this.angularVelocities.get(segmentIndex + 1));
                    SO3TrajectoryPointCalculator.this.trajectoryCalculator.setTrajectoryTime(SO3TrajectoryPointCalculator.this.times.get(segmentIndex + 1) - SO3TrajectoryPointCalculator.this.times.get(segmentIndex));
                    SO3TrajectoryPointCalculator.this.trajectoryCalculator.setNumberOfRevolutions(0);
                    SO3TrajectoryPointCalculator.this.trajectoryCalculator.initialize();
                }
                double localTime = time - SO3TrajectoryPointCalculator.this.times.get(segmentIndex);
                SO3TrajectoryPointCalculator.this.trajectoryCalculator.compute(localTime);
                Vector3D angularAcceleration = new Vector3D();
                SO3TrajectoryPointCalculator.this.trajectoryCalculator.getAngularAcceleration(angularAcceleration);
                double squareOfAcceleration = 0.0;
                for (int j = 0; j < 3; ++j) {
                    squareOfAcceleration += angularAcceleration.getElement(j) * angularAcceleration.getElement(j);
                }
                cost += squareOfAcceleration * 0.01;
                time += 0.01;
                previousSegmentIndex = segmentIndex;
            }
            return cost;
        }
    }
}

