/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.Precision;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.YoEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FixedFrameEuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSE3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.TrajectoryPointListBasics;
import us.ihmc.robotics.trajectories.core.Polynomial3D;
import us.ihmc.robotics.trajectories.interfaces.FramePositionTrajectoryGenerator;
import us.ihmc.yoVariables.euclid.YoPoint3D;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.FrameIndexMap;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.YoMutableFrameObject;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;

public class MultipleWaypointsPositionTrajectoryGenerator
implements FramePositionTrajectoryGenerator,
YoMutableFrameObject {
    private final String namePrefix;
    private final int maximumNumberOfWaypoints;
    private final YoRegistry registry;
    private final YoLong frameId;
    private final FrameIndexMap frameIndexMap;
    private final YoDouble currentTrajectoryTime;
    private final YoInteger numberOfWaypoints;
    private final YoInteger currentWaypointIndex;
    private final List<FixedFrameEuclideanTrajectoryPointBasics> waypoints;
    private final FixedFramePoint3DBasics currentPosition;
    private final FixedFrameVector3DBasics currentVelocity;
    private final FixedFrameVector3DBasics currentAcceleration;
    private final Polynomial3D subTrajectory;

    public MultipleWaypointsPositionTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this(namePrefix, 30, referenceFrame, parentRegistry);
    }

    public MultipleWaypointsPositionTrajectoryGenerator(String namePrefix, int maximumNumberOfWaypoints, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this.namePrefix = namePrefix;
        this.maximumNumberOfWaypoints = maximumNumberOfWaypoints;
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.frameId = new YoLong(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "frame"}), this.registry);
        this.frameIndexMap = new FrameIndexMap.FrameIndexHashMap();
        this.numberOfWaypoints = new YoInteger(namePrefix + "NumberOfWaypoints", this.registry);
        this.numberOfWaypoints.set(0);
        this.waypoints = new ArrayList<FixedFrameEuclideanTrajectoryPointBasics>(maximumNumberOfWaypoints);
        this.currentTrajectoryTime = new YoDouble(namePrefix + "CurrentTrajectoryTime", this.registry);
        this.currentWaypointIndex = new YoInteger(namePrefix + "CurrentWaypointIndex", this.registry);
        String currentPositionName = namePrefix + "CurrentPosition";
        String currentVelocityName = namePrefix + "CurrentVelocity";
        String currentAccelerationName = namePrefix + "CurrentAcceleration";
        this.currentPosition = EuclidFrameFactories.newLinkedFixedFramePoint3DBasics((ReferenceFrameHolder)this, (Point3DBasics)new YoPoint3D(currentPositionName, this.registry));
        this.currentVelocity = EuclidFrameFactories.newLinkedFixedFrameVector3DBasics((ReferenceFrameHolder)this, (Vector3DBasics)new YoVector3D(currentVelocityName, this.registry));
        this.currentAcceleration = EuclidFrameFactories.newLinkedFixedFrameVector3DBasics((ReferenceFrameHolder)this, (Vector3DBasics)new YoVector3D(currentAccelerationName, this.registry));
        this.subTrajectory = new Polynomial3D(4);
        for (int i = 0; i < maximumNumberOfWaypoints; ++i) {
            YoEuclideanTrajectoryPoint yoTrajectoryPoint = new YoEuclideanTrajectoryPoint(namePrefix, "AtWaypoint" + i, this.registry);
            this.waypoints.add(FixedFrameEuclideanTrajectoryPointBasics.newLinkedFixedFrameEuclideanTrajectoryPointBasics((ReferenceFrameHolder)this, yoTrajectoryPoint));
        }
        this.clear(referenceFrame);
        parentRegistry.addChild(this.registry);
    }

    public void clear() {
        for (int i = 0; i < this.numberOfWaypoints.getIntegerValue(); ++i) {
            this.waypoints.get(i).setToNaN();
        }
        this.numberOfWaypoints.set(0);
        this.currentWaypointIndex.set(0);
    }

    public void clear(ReferenceFrame referenceFrame) {
        this.clear();
        this.setReferenceFrame(referenceFrame);
    }

    public void appendWaypoint(double timeAtWaypoint, Point3DReadOnly position, Vector3DReadOnly linearVelocity) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(timeAtWaypoint, position, linearVelocity);
    }

    private void appendWaypointUnsafe(double timeAtWaypoint, Point3DReadOnly position, Vector3DReadOnly linearVelocity) {
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue()).set(timeAtWaypoint, position, linearVelocity);
        this.numberOfWaypoints.increment();
    }

    public void appendWaypoint(double timeAtWaypoint, FramePoint3DReadOnly position, FrameVector3DReadOnly linearVelocity) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(timeAtWaypoint, position, linearVelocity);
    }

    private void appendWaypointUnsafe(double timeAtWaypoint, FramePoint3DReadOnly position, FrameVector3DReadOnly linearVelocity) {
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue()).set(timeAtWaypoint, position, linearVelocity);
        this.numberOfWaypoints.increment();
    }

    public void appendWaypoint(EuclideanTrajectoryPointReadOnly euclideanWaypoint) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(euclideanWaypoint);
    }

    public void appendWaypoint(FrameEuclideanTrajectoryPointReadOnly frameEuclideanTrajectoryPoint) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameEuclideanTrajectoryPoint);
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(frameEuclideanTrajectoryPoint);
    }

    public void appendWaypoint(FrameSE3TrajectoryPointReadOnly frameSE3TrajectoryPoint) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameSE3TrajectoryPoint);
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(frameSE3TrajectoryPoint);
    }

    private void appendWaypointUnsafe(EuclideanTrajectoryPointReadOnly euclideanWaypoint) {
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue()).set(euclideanWaypoint);
        this.numberOfWaypoints.increment();
    }

    public void appendWaypoints(double[] timeAtWaypoints, FramePoint3DReadOnly[] positions, FrameVector3DReadOnly[] linearVelocities) {
        if (timeAtWaypoints.length != positions.length || linearVelocities != null && positions.length != linearVelocities.length) {
            throw new RuntimeException("Arguments are inconsistent.");
        }
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + timeAtWaypoints.length);
        for (int i = 0; i < timeAtWaypoints.length; ++i) {
            this.appendWaypointUnsafe(timeAtWaypoints[i], positions[i], linearVelocities[i]);
        }
    }

    public void appendWaypoints(double[] timeAtWaypoints, Point3DReadOnly[] positions, Vector3DReadOnly[] linearVelocities) {
        if (timeAtWaypoints.length != positions.length || positions.length != linearVelocities.length) {
            throw new RuntimeException("Arguments are inconsistent.");
        }
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + timeAtWaypoints.length);
        for (int i = 0; i < timeAtWaypoints.length; ++i) {
            this.appendWaypointUnsafe(timeAtWaypoints[i], positions[i], linearVelocities[i]);
        }
    }

    public void appendWaypoints(EuclideanTrajectoryPointReadOnly[] euclideanWaypoint) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + euclideanWaypoint.length);
        for (int i = 0; i < euclideanWaypoint.length; ++i) {
            this.appendWaypointUnsafe(euclideanWaypoint[i]);
        }
    }

    public void appendWaypoints(RecyclingArrayList<? extends EuclideanTrajectoryPointReadOnly> euclideanWaypoint) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + euclideanWaypoint.size());
        for (int i = 0; i < euclideanWaypoint.size(); ++i) {
            this.appendWaypointUnsafe((EuclideanTrajectoryPointReadOnly)euclideanWaypoint.get(i));
        }
    }

    public void appendWaypoints(TrajectoryPointListBasics<? extends EuclideanTrajectoryPointReadOnly> trajectoryPointList) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + trajectoryPointList.getNumberOfTrajectoryPoints());
        for (int i = 0; i < trajectoryPointList.getNumberOfTrajectoryPoints(); ++i) {
            this.appendWaypointUnsafe(trajectoryPointList.getTrajectoryPoint(i));
        }
    }

    private void checkNumberOfWaypoints(int length) {
        if (length > this.maximumNumberOfWaypoints) {
            throw new RuntimeException("Cannot exceed the maximum number of waypoints. Number of waypoints provided: " + length);
        }
    }

    public void initialize() {
        if (this.numberOfWaypoints.getIntegerValue() == 0) {
            throw new RuntimeException("Trajectory has no waypoints.");
        }
        this.currentWaypointIndex.set(0);
    }

    public void compute(double time) {
        if (this.isEmpty()) {
            throw new RuntimeException("Can not call compute on an empty trajectory.");
        }
        this.currentTrajectoryTime.set(time);
        if (time < this.waypoints.get(this.currentWaypointIndex.getIntegerValue()).getTime()) {
            this.currentWaypointIndex.set(0);
        }
        while (this.currentWaypointIndex.getIntegerValue() < this.numberOfWaypoints.getIntegerValue() - 2 && time >= this.waypoints.get(this.currentWaypointIndex.getIntegerValue() + 1).getTime()) {
            this.currentWaypointIndex.increment();
        }
        int secondWaypointIndex = Math.min(this.currentWaypointIndex.getValue() + 1, this.numberOfWaypoints.getValue() - 1);
        FixedFrameEuclideanTrajectoryPointBasics start = this.waypoints.get(this.currentWaypointIndex.getValue());
        FixedFrameEuclideanTrajectoryPointBasics end = this.waypoints.get(secondWaypointIndex);
        if (time < start.getTime()) {
            this.currentPosition.set((FrameTuple3DReadOnly)start.getPosition());
            this.currentVelocity.setToZero();
            this.currentAcceleration.setToZero();
            return;
        }
        if (time > end.getTime()) {
            this.currentPosition.set((FrameTuple3DReadOnly)end.getPosition());
            this.currentVelocity.setToZero();
            this.currentAcceleration.setToZero();
            return;
        }
        if (Precision.equals((double)start.getTime(), (double)end.getTime())) {
            this.currentPosition.set((FrameTuple3DReadOnly)start.getPosition());
            this.currentVelocity.set((FrameTuple3DReadOnly)start.getLinearVelocity());
            this.currentAcceleration.setToZero();
            return;
        }
        this.subTrajectory.setCubicDirectly(end.getTime() - start.getTime(), (Point3DReadOnly)start.getPosition(), (Vector3DReadOnly)start.getLinearVelocity(), (Point3DReadOnly)end.getPosition(), (Vector3DReadOnly)end.getLinearVelocity());
        double subTrajectoryTime = MathTools.clamp((double)(time - start.getTime()), (double)0.0, (double)(end.getTime() - start.getTime()));
        this.subTrajectory.compute(subTrajectoryTime);
        this.currentPosition.set((Tuple3DReadOnly)this.subTrajectory.getPosition());
        this.currentVelocity.set((Tuple3DReadOnly)this.subTrajectory.getVelocity());
        this.currentAcceleration.set((Tuple3DReadOnly)this.subTrajectory.getAcceleration());
    }

    public boolean isDone() {
        boolean isLastWaypoint;
        if (this.isEmpty()) {
            return true;
        }
        boolean bl = isLastWaypoint = this.currentWaypointIndex.getIntegerValue() >= this.numberOfWaypoints.getIntegerValue() - 2;
        if (!isLastWaypoint) {
            return false;
        }
        return this.currentTrajectoryTime.getValue() >= this.waypoints.get(this.currentWaypointIndex.getValue() + 1).getTime();
    }

    public boolean isEmpty() {
        return this.numberOfWaypoints.getIntegerValue() == 0;
    }

    public int getCurrentWaypointIndex() {
        return this.currentWaypointIndex.getIntegerValue();
    }

    public void showVisualization() {
    }

    public void hideVisualization() {
    }

    public FramePoint3DReadOnly getPosition() {
        return this.currentPosition;
    }

    public FrameVector3DReadOnly getVelocity() {
        return this.currentVelocity;
    }

    public FrameVector3DReadOnly getAcceleration() {
        return this.currentAcceleration;
    }

    public int getCurrentNumberOfWaypoints() {
        return this.numberOfWaypoints.getIntegerValue();
    }

    public FixedFrameEuclideanTrajectoryPointBasics getWaypoint(int idx) {
        return this.waypoints.get(idx);
    }

    public int getMaximumNumberOfWaypoints() {
        return this.maximumNumberOfWaypoints;
    }

    public double getLastWaypointTime() {
        return this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1).getTime();
    }

    public void removeFirstWaypoint() {
        if (this.numberOfWaypoints.getIntegerValue() == 0) {
            return;
        }
        this.numberOfWaypoints.decrement();
        for (int i = 0; i < this.numberOfWaypoints.getIntegerValue(); ++i) {
            this.waypoints.get(i).set(this.waypoints.get(i + 1));
        }
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue()).setToNaN();
    }

    public ReferenceFrame getReferenceFrame() {
        return super.getReferenceFrame();
    }

    public YoLong getYoFrameIndex() {
        return this.frameId;
    }

    public FrameIndexMap getFrameIndexMap() {
        return this.frameIndexMap;
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        super.setReferenceFrame(referenceFrame);
    }

    public void applyTransform(Transform transform) {
        this.currentPosition.applyTransform(transform);
        this.currentVelocity.applyTransform(transform);
        this.currentAcceleration.applyTransform(transform);
        for (int i = 0; i < this.numberOfWaypoints.getValue(); ++i) {
            this.waypoints.get(i).applyTransform(transform);
        }
    }

    public void applyInverseTransform(Transform transform) {
        this.currentPosition.applyInverseTransform(transform);
        this.currentVelocity.applyInverseTransform(transform);
        this.currentAcceleration.applyInverseTransform(transform);
        for (int i = 0; i < this.numberOfWaypoints.getValue(); ++i) {
            this.waypoints.get(i).applyInverseTransform(transform);
        }
    }

    public String toString() {
        if (this.numberOfWaypoints.getIntegerValue() == 0) {
            return this.namePrefix + ": Has no waypoints.";
        }
        return this.namePrefix + ": number of waypoints = " + this.numberOfWaypoints.getIntegerValue() + ", current waypoint index = " + this.currentWaypointIndex.getIntegerValue() + "\nFirst waypoint: " + String.valueOf(this.waypoints.get(0)) + ", last waypoint: " + String.valueOf(this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1));
    }
}

