/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import java.util.List;
import java.util.function.Supplier;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.commons.time.TimeIntervalBasics;
import us.ihmc.commons.time.TimeIntervalProvider;
import us.ihmc.commons.time.TimeIntervalTools;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.robotics.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class MultipleSegmentPositionTrajectoryGenerator<T extends FixedFramePositionTrajectoryGenerator & TimeIntervalProvider>
implements FixedFramePositionTrajectoryGenerator {
    private final String namePrefix;
    private final int maximumNumberOfSegments;
    private final YoRegistry registry;
    private final YoDouble currentSegmentTime;
    protected final YoInteger numberOfSegments;
    private final YoInteger currentSegmentIndex;
    protected final RecyclingArrayList<T> segments;
    private final FixedFramePoint3DBasics currentPosition;
    private final FixedFrameVector3DBasics currentVelocity;
    private final FixedFrameVector3DBasics currentAcceleration;

    public MultipleSegmentPositionTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, Supplier<T> trajectorySupplier, YoRegistry parentRegistry) {
        this(namePrefix, 30, referenceFrame, trajectorySupplier, parentRegistry);
    }

    public MultipleSegmentPositionTrajectoryGenerator(String namePrefix, int maximumNumberOfWaypoints, ReferenceFrame referenceFrame, Supplier<T> trajectorySupplier, YoRegistry parentRegistry) {
        this.namePrefix = namePrefix;
        this.maximumNumberOfSegments = maximumNumberOfWaypoints;
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.numberOfSegments = new YoInteger(namePrefix + "NumberOfSegments", this.registry);
        this.numberOfSegments.set(0);
        this.segments = new RecyclingArrayList(trajectorySupplier);
        this.currentSegmentTime = new YoDouble(namePrefix + "CurrentTrajectoryTime", this.registry);
        this.currentSegmentIndex = new YoInteger(namePrefix + "CurrentSegmentIndex", this.registry);
        String currentPositionName = namePrefix + "CurrentPosition";
        String currentVelocityName = namePrefix + "CurrentVelocity";
        String currentAccelerationName = namePrefix + "CurrentAcceleration";
        this.currentPosition = new YoFramePoint3D(currentPositionName, referenceFrame, this.registry);
        this.currentVelocity = new YoFrameVector3D(currentVelocityName, referenceFrame, this.registry);
        this.currentAcceleration = new YoFrameVector3D(currentAccelerationName, referenceFrame, this.registry);
        this.clear();
        parentRegistry.addChild(this.registry);
    }

    public void clear() {
        this.numberOfSegments.set(0);
        this.currentSegmentIndex.set(0);
        this.segments.clear();
    }

    public void appendSegment(T segment) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)segment);
        this.checkNumberOfSegments(this.numberOfSegments.getIntegerValue() + 1);
        this.checkNextSegmentIsContinuous(segment);
        this.appendSegmentsUnsafe(segment);
    }

    private void appendSegmentsUnsafe(T segment) {
        ((Settable)((FixedFramePositionTrajectoryGenerator)this.segments.add())).set(segment);
        this.numberOfSegments.increment();
    }

    public void appendSegments(T[] segments) {
        this.checkNumberOfSegments(this.numberOfSegments.getIntegerValue() + segments.length);
        for (int i = 0; i < segments.length; ++i) {
            this.appendSegment(segments[i]);
        }
    }

    public void appendSegments(List<T> segments) {
        this.checkNumberOfSegments(this.numberOfSegments.getIntegerValue() + segments.size());
        for (int i = 0; i < segments.size(); ++i) {
            this.appendSegment((FixedFramePositionTrajectoryGenerator)segments.get(i));
        }
    }

    protected void checkNumberOfSegments(int length) {
        if (length > this.maximumNumberOfSegments) {
            throw new RuntimeException("Cannot exceed the maximum number of segments. Number of segments provided: " + length);
        }
    }

    protected void checkNextSegmentIsContinuous(T segment) {
        if (this.getCurrentNumberOfSegments() == 0) {
            return;
        }
        if (!TimeIntervalTools.areTimeIntervalsConsecutive((TimeIntervalProvider)((TimeIntervalProvider)this.segments.get(this.getCurrentNumberOfSegments() - 1)), (TimeIntervalProvider)((TimeIntervalProvider)segment), (double)0.005)) {
            throw new RuntimeException("The next segment doesn't start where the previous one ended.");
        }
    }

    public void initialize() {
        if (this.numberOfSegments.getIntegerValue() == 0) {
            throw new RuntimeException("Trajectory has no segments.");
        }
        if (!TimeIntervalTools.isTimeSequenceContinuous(this.segments)) {
            throw new RuntimeException("The segments do not represent a continuous time trajectory.");
        }
        this.currentSegmentIndex.set(0);
    }

    public void compute(double time) {
        if (this.isEmpty()) {
            throw new RuntimeException("Can not call compute on an empty trajectory.");
        }
        this.currentSegmentTime.set(time);
        if (time < ((TimeIntervalProvider)((FixedFramePositionTrajectoryGenerator)this.segments.get(this.currentSegmentIndex.getIntegerValue()))).getTimeInterval().getStartTime()) {
            this.currentSegmentIndex.set(0);
        }
        while (this.currentSegmentIndex.getIntegerValue() < this.numberOfSegments.getIntegerValue() - 1 && time > ((TimeIntervalProvider)((FixedFramePositionTrajectoryGenerator)this.segments.get(this.currentSegmentIndex.getIntegerValue()))).getTimeInterval().getEndTime()) {
            this.currentSegmentIndex.increment();
        }
        FixedFramePositionTrajectoryGenerator segment = (FixedFramePositionTrajectoryGenerator)this.segments.get(this.currentSegmentIndex.getValue());
        TimeIntervalBasics timeInterval = ((TimeIntervalProvider)segment).getTimeInterval();
        double subTrajectoryTime = MathTools.clamp((double)(time - timeInterval.getStartTime()), (double)0.0, (double)timeInterval.getDuration());
        segment.compute(subTrajectoryTime);
        this.currentPosition.set((FrameTuple3DReadOnly)segment.getPosition());
        this.currentVelocity.set((FrameTuple3DReadOnly)segment.getVelocity());
        this.currentAcceleration.set((FrameTuple3DReadOnly)segment.getAcceleration());
    }

    public boolean isDone() {
        boolean isLastWaypoint;
        if (this.isEmpty()) {
            return true;
        }
        boolean bl = isLastWaypoint = this.currentSegmentIndex.getIntegerValue() >= this.numberOfSegments.getIntegerValue() - 1;
        if (!isLastWaypoint) {
            return false;
        }
        return this.currentSegmentTime.getValue() >= this.getEndTime();
    }

    public boolean isEmpty() {
        return this.numberOfSegments.getIntegerValue() == 0;
    }

    public int getCurrentSegmentIndex() {
        return this.currentSegmentIndex.getIntegerValue();
    }

    public double getCurrentSegmentTrajectoryTime() {
        return this.currentSegmentTime.getDoubleValue();
    }

    public void showVisualization() {
    }

    public void hideVisualization() {
    }

    public FramePoint3DReadOnly getPosition() {
        return this.currentPosition;
    }

    public FrameVector3DReadOnly getVelocity() {
        return this.currentVelocity;
    }

    public FrameVector3DReadOnly getAcceleration() {
        return this.currentAcceleration;
    }

    public int getCurrentNumberOfSegments() {
        return this.numberOfSegments.getIntegerValue();
    }

    public int getMaximumNumberOfSegments() {
        return this.maximumNumberOfSegments;
    }

    public double getEndTime() {
        return ((TimeIntervalProvider)((FixedFramePositionTrajectoryGenerator)this.segments.get(this.getCurrentNumberOfSegments() - 1))).getTimeInterval().getEndTime();
    }

    public List<T> getSegments() {
        return this.segments;
    }

    public T getSegment(int segmentIdx) {
        return (T)((FixedFramePositionTrajectoryGenerator)this.segments.get(segmentIdx));
    }

    public void removeSegment(int segmentIdx) {
        this.segments.remove(segmentIdx);
        this.numberOfSegments.decrement();
    }

    public String toString() {
        if (this.numberOfSegments.getIntegerValue() == 0) {
            return this.namePrefix + ": Has no waypoints.";
        }
        return this.namePrefix + ": number of waypoints = " + this.numberOfSegments.getIntegerValue() + ", current waypoint index = " + this.currentSegmentIndex.getIntegerValue();
    }
}

