/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.math.interpolators.OrientationInterpolationCalculator;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePoseTrajectoryGenerator;
import us.ihmc.robotics.trajectories.yoVariables.YoPolynomial;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameVector3D;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class StraightLinePoseTrajectoryGenerator
implements FixedFramePoseTrajectoryGenerator {
    private final YoRegistry registry;
    private final YoMutableFramePoint3D initialPosition;
    private final YoMutableFramePoint3D finalPosition;
    private final YoMutableFrameVector3D differenceVector;
    private final YoMutableFrameVector3D currentVelocity;
    private final YoMutableFrameVector3D currentAcceleration;
    private final YoMutableFrameQuaternion initialOrientation;
    private final YoMutableFrameQuaternion finalOrientation;
    private final YoFrameYawPitchRoll initialOrientationForViz;
    private final YoFrameYawPitchRoll finalOrientationForViz;
    private final YoMutableFrameVector3D currentAngularVelocity;
    private final YoMutableFrameVector3D currentAngularAcceleration;
    private final YoMutableFramePose3D currentPose;
    private final YoPolynomial quinticParameterPolynomial;
    private final YoDouble currentTime;
    private final YoDouble trajectoryTime;
    private final boolean visualize;
    private final YoGraphicsList yoGraphicsList;
    private final BagOfBalls bagOfBalls;
    private final FramePoint3D ballPosition = new FramePoint3D();
    private final int numberOfBalls = 50;
    private final YoBoolean showViz;
    private final OrientationInterpolationCalculator orientationInterpolationCalculator = new OrientationInterpolationCalculator();
    private final YoFrameYawPitchRoll currentOrientationForViz;
    private final List<ImmutablePair<FramePoint3DReadOnly, YoFramePoint3D>> visualizationUpdatables = new ArrayList<ImmutablePair<FramePoint3DReadOnly, YoFramePoint3D>>();

    public StraightLinePoseTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this(namePrefix, referenceFrame, parentRegistry, false, null);
    }

    public StraightLinePoseTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, YoRegistry parentRegistry, boolean visualize, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.initialPosition = new YoMutableFramePoint3D(namePrefix + "InitialPosition", "", this.registry, referenceFrame);
        this.finalPosition = new YoMutableFramePoint3D(namePrefix + "FinalPosition", "", this.registry, referenceFrame);
        this.differenceVector = new YoMutableFrameVector3D(namePrefix + "DifferenceVector", "", this.registry, referenceFrame);
        this.currentVelocity = new YoMutableFrameVector3D(namePrefix + "CurrentVelocity", "", this.registry, referenceFrame);
        this.currentAcceleration = new YoMutableFrameVector3D(namePrefix + "CurrentAcceleration", "", this.registry, referenceFrame);
        this.initialOrientation = new YoMutableFrameQuaternion(namePrefix + "InitialOrientation", "", this.registry, referenceFrame);
        this.finalOrientation = new YoMutableFrameQuaternion(namePrefix + "FinalOrientation", "", this.registry, referenceFrame);
        this.initialOrientationForViz = new YoFrameYawPitchRoll(namePrefix + "InitialOrientationForViz", ReferenceFrame.getWorldFrame(), this.registry);
        this.finalOrientationForViz = new YoFrameYawPitchRoll(namePrefix + "FinalOrientationForViz", ReferenceFrame.getWorldFrame(), this.registry);
        this.currentOrientationForViz = new YoFrameYawPitchRoll(namePrefix + "CurrentOrientationForViz", ReferenceFrame.getWorldFrame(), this.registry);
        this.currentAngularVelocity = new YoMutableFrameVector3D(namePrefix + "CurrentAngularVelocity", "", this.registry, referenceFrame);
        this.currentAngularAcceleration = new YoMutableFrameVector3D(namePrefix + "CurrentAngularAcceleration", "", this.registry, referenceFrame);
        this.currentPose = new YoMutableFramePose3D(namePrefix + "CurrentPose", "", this.registry);
        this.currentPose.setToZero(referenceFrame);
        this.quinticParameterPolynomial = new YoPolynomial(namePrefix + "QuinticParameterPolynomial", 6, this.registry);
        this.currentTime = new YoDouble(namePrefix + "Time", this.registry);
        this.trajectoryTime = new YoDouble(namePrefix + "TrajectoryTime", this.registry);
        parentRegistry.addChild(this.registry);
        boolean bl = this.visualize = visualize && yoGraphicsListRegistry != null;
        if (this.visualize) {
            YoFramePoint3D currentPositionInWorld = new YoFramePoint3D(namePrefix + "CurrentPosition", "WorldViz", ReferenceFrame.getWorldFrame(), this.registry);
            this.visualizationUpdatables.add((ImmutablePair<FramePoint3DReadOnly, YoFramePoint3D>)new ImmutablePair((Object)this.currentPose.getPosition(), (Object)currentPositionInWorld));
            final YoGraphicPosition currentPositionViz = new YoGraphicPosition(namePrefix + "CurrentPosition", currentPositionInWorld, 0.025, YoAppearance.Blue());
            YoFramePoint3D initialPositionInWorld = new YoFramePoint3D(namePrefix + "InitialPosition", "WorldViz", ReferenceFrame.getWorldFrame(), this.registry);
            this.visualizationUpdatables.add((ImmutablePair<FramePoint3DReadOnly, YoFramePoint3D>)new ImmutablePair((Object)this.initialPosition, (Object)initialPositionInWorld));
            final YoGraphicPosition initialPositionViz = new YoGraphicPosition(namePrefix + "InitialPosition", initialPositionInWorld, 0.02, YoAppearance.BlueViolet());
            YoFramePoint3D finalPositionInWorld = new YoFramePoint3D(namePrefix + "FinalPosition", "WorldViz", ReferenceFrame.getWorldFrame(), this.registry);
            this.visualizationUpdatables.add((ImmutablePair<FramePoint3DReadOnly, YoFramePoint3D>)new ImmutablePair((Object)this.finalPosition, (Object)finalPositionInWorld));
            final YoGraphicPosition finalPositionViz = new YoGraphicPosition(namePrefix + "FinalPosition", finalPositionInWorld, 0.02, YoAppearance.Red());
            YoGraphicCoordinateSystem initialPoseViz = new YoGraphicCoordinateSystem(namePrefix + "InitialPose", initialPositionInWorld, this.initialOrientationForViz, 0.1);
            YoGraphicCoordinateSystem finalPoseViz = new YoGraphicCoordinateSystem(namePrefix + "FinalPose", finalPositionInWorld, this.finalOrientationForViz, 0.1);
            YoGraphicCoordinateSystem currentPoseViz = new YoGraphicCoordinateSystem(namePrefix + "CurrentPose", currentPositionInWorld, this.currentOrientationForViz, 0.25);
            this.yoGraphicsList = new YoGraphicsList(namePrefix + "StraightLineTrajectory");
            this.yoGraphicsList.add((YoGraphic)currentPositionViz);
            this.yoGraphicsList.add((YoGraphic)initialPositionViz);
            this.yoGraphicsList.add((YoGraphic)finalPositionViz);
            this.yoGraphicsList.add((YoGraphic)initialPoseViz);
            this.yoGraphicsList.add((YoGraphic)finalPoseViz);
            this.yoGraphicsList.add((YoGraphic)currentPoseViz);
            yoGraphicsListRegistry.registerYoGraphicsList(this.yoGraphicsList);
            this.bagOfBalls = new BagOfBalls(50, 0.01, this.yoGraphicsList.getLabel(), this.registry, yoGraphicsListRegistry);
            this.showViz = new YoBoolean(namePrefix + "ShowViz", this.registry);
            this.showViz.addListener(new YoVariableChangedListener(){

                public void changed(YoVariable v) {
                    boolean visible = StraightLinePoseTrajectoryGenerator.this.showViz.getBooleanValue();
                    currentPositionViz.setVisible(visible);
                    initialPositionViz.setVisible(visible);
                    finalPositionViz.setVisible(visible);
                    StraightLinePoseTrajectoryGenerator.this.bagOfBalls.setVisible(visible);
                }
            });
            this.showViz.notifyListeners();
        } else {
            this.yoGraphicsList = null;
            this.bagOfBalls = null;
            this.showViz = null;
        }
    }

    public void changeFrame(ReferenceFrame referenceFrame) {
        this.initialPosition.changeFrame(referenceFrame);
        this.finalPosition.changeFrame(referenceFrame);
        this.differenceVector.changeFrame(referenceFrame);
        this.currentPose.changeFrame(referenceFrame);
        this.currentVelocity.changeFrame(referenceFrame);
        this.currentAcceleration.changeFrame(referenceFrame);
        this.initialOrientation.changeFrame(referenceFrame);
        this.finalOrientation.changeFrame(referenceFrame);
        this.currentAngularVelocity.changeFrame(referenceFrame);
        this.currentAngularAcceleration.changeFrame(referenceFrame);
    }

    public void switchTrajectoryFrame(ReferenceFrame referenceFrame) {
        this.initialPosition.setToZero(referenceFrame);
        this.finalPosition.setToZero(referenceFrame);
        this.differenceVector.setToZero(referenceFrame);
        this.currentPose.setToZero(referenceFrame);
        this.currentVelocity.setToZero(referenceFrame);
        this.currentAcceleration.setToZero(referenceFrame);
        this.initialOrientation.setToZero(referenceFrame);
        this.finalOrientation.setToZero(referenceFrame);
        this.currentAngularVelocity.setToZero(referenceFrame);
        this.currentAngularAcceleration.setToZero(referenceFrame);
    }

    public void setTrajectoryTime(double newTrajectoryTime) {
        this.trajectoryTime.set(newTrajectoryTime);
    }

    public void setInitialPose(FramePose3DReadOnly initialPose) {
        this.setInitialPose(initialPose.getPosition(), (FrameOrientation3DReadOnly)initialPose.getOrientation());
    }

    public void setInitialPose(FramePoint3DReadOnly initialPosition, FrameOrientation3DReadOnly initialOrientation) {
        this.initialPosition.setMatchingFrame((FrameTuple3DReadOnly)initialPosition);
        this.initialOrientation.setMatchingFrame(initialOrientation);
        this.initialOrientationForViz.setMatchingFrame(initialOrientation);
    }

    public void setFinalPose(FramePose3DReadOnly finalPose) {
        this.setFinalPose(finalPose.getPosition(), (FrameOrientation3DReadOnly)finalPose.getOrientation());
    }

    public void setFinalPose(FramePoint3DReadOnly finalPosition, FrameOrientation3DReadOnly finalOrientation) {
        this.finalPosition.setMatchingFrame((FrameTuple3DReadOnly)finalPosition);
        this.finalOrientation.setMatchingFrame(finalOrientation);
        this.finalOrientationForViz.setMatchingFrame(finalOrientation);
    }

    public void initialize() {
        MathTools.checkIntervalContains((double)this.trajectoryTime.getDoubleValue(), (double)0.0, (double)Double.POSITIVE_INFINITY);
        this.quinticParameterPolynomial.setQuintic(0.0, this.trajectoryTime.getDoubleValue(), 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        this.reset();
        if (this.visualize) {
            this.visualizeTrajectory();
        }
    }

    private void reset() {
        this.currentTime.set(0.0);
        this.currentPose.getPosition().set((FrameTuple3DReadOnly)this.initialPosition);
        this.currentVelocity.setToZero();
        this.currentAcceleration.setToZero();
        this.currentPose.getOrientation().set((FrameQuaternionReadOnly)this.initialOrientation);
        this.currentAngularVelocity.setToZero();
        this.currentAngularAcceleration.setToZero();
    }

    public void compute(double time) {
        double alphaAcc;
        this.currentTime.set(time);
        time = MathTools.clamp((double)time, (double)0.0, (double)this.trajectoryTime.getDoubleValue());
        this.quinticParameterPolynomial.compute(time);
        boolean isDone = this.isDone();
        double alphaPosition = isDone ? 1.0 : this.quinticParameterPolynomial.getValue();
        double alphaVel = isDone ? 0.0 : this.quinticParameterPolynomial.getVelocity();
        double d = alphaAcc = isDone ? 0.0 : this.quinticParameterPolynomial.getAcceleration();
        if (isDone) {
            this.currentPose.getPosition().set((FrameTuple3DReadOnly)this.finalPosition);
            this.currentVelocity.setToZero();
            this.currentAcceleration.setToZero();
            this.currentPose.getOrientation().set((FrameQuaternionReadOnly)this.finalOrientation);
            this.currentAngularVelocity.setToZero();
            this.currentAngularAcceleration.setToZero();
        } else {
            this.differenceVector.sub((FrameTuple3DReadOnly)this.finalPosition, (FrameTuple3DReadOnly)this.initialPosition);
            this.currentPose.getPosition().interpolate((FrameTuple3DReadOnly)this.initialPosition, (FrameTuple3DReadOnly)this.finalPosition, alphaPosition);
            this.currentVelocity.setAndScale(alphaVel, (FrameTuple3DReadOnly)this.differenceVector);
            this.currentAcceleration.setAndScale(alphaAcc, (FrameTuple3DReadOnly)this.differenceVector);
            this.currentPose.getOrientation().interpolate((FrameQuaternionReadOnly)this.initialOrientation, (FrameQuaternionReadOnly)this.finalOrientation, alphaPosition);
            this.orientationInterpolationCalculator.computeAngularVelocity((FrameVector3DBasics)this.currentAngularVelocity, (FrameQuaternionBasics)this.initialOrientation, (FrameQuaternionBasics)this.finalOrientation, alphaVel);
            this.orientationInterpolationCalculator.computeAngularAcceleration((FrameVector3DBasics)this.currentAngularAcceleration, (FrameQuaternionBasics)this.initialOrientation, (FrameQuaternionBasics)this.finalOrientation, alphaAcc);
        }
        this.currentOrientationForViz.setMatchingFrame((FrameOrientation3DReadOnly)this.currentPose.getOrientation());
        for (int i = 0; i < this.visualizationUpdatables.size(); ++i) {
            ImmutablePair<FramePoint3DReadOnly, YoFramePoint3D> pair = this.visualizationUpdatables.get(i);
            ((YoFramePoint3D)pair.getRight()).setMatchingFrame((FrameTuple3DReadOnly)pair.getLeft());
        }
    }

    private void visualizeTrajectory() {
        for (int i = 0; i < 50; ++i) {
            double t = (double)i / 49.0 * this.trajectoryTime.getDoubleValue();
            this.compute(t);
            this.ballPosition.setIncludingFrame((FrameTuple3DReadOnly)this.currentPose.getPosition());
            this.ballPosition.changeFrame(ReferenceFrame.getWorldFrame());
            this.bagOfBalls.setBallLoop((FramePoint3DReadOnly)this.ballPosition);
        }
        this.reset();
    }

    public void showVisualization() {
        if (!this.visualize) {
            return;
        }
        this.showViz.set(true);
    }

    public void hideVisualization() {
        if (!this.visualize) {
            return;
        }
        this.showViz.set(false);
    }

    @Override
    public FramePose3DReadOnly getPose() {
        return this.currentPose;
    }

    public FrameVector3DReadOnly getVelocity() {
        return this.currentVelocity;
    }

    public FrameVector3DReadOnly getAcceleration() {
        return this.currentAcceleration;
    }

    @Override
    public FrameVector3DReadOnly getAngularVelocity() {
        return this.currentAngularVelocity;
    }

    @Override
    public FrameVector3DReadOnly getAngularAcceleration() {
        return this.currentAngularAcceleration;
    }

    public boolean isDone() {
        return this.currentTime.getDoubleValue() >= this.trajectoryTime.getDoubleValue();
    }

    public String toString() {
        Object ret = "";
        ret = (String)ret + "Current time: " + this.currentTime.getDoubleValue() + ", trajectory time: " + this.trajectoryTime.getDoubleValue();
        ret = (String)ret + "\nCurrent pose: " + String.valueOf(this.currentPose);
        ret = (String)ret + "\nCurrent velocity: " + String.valueOf(this.currentVelocity);
        ret = (String)ret + "\nCurrent acceleration: " + String.valueOf(this.currentAcceleration);
        ret = (String)ret + "\nCurrent angular velocity: " + String.valueOf(this.currentAngularVelocity);
        ret = (String)ret + "\nCurrent angular acceleration: " + String.valueOf(this.currentAngularAcceleration);
        return ret;
    }
}

