/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.commons.time.TimeInterval;
import us.ihmc.commons.time.TimeIntervalBasics;
import us.ihmc.commons.time.TimeIntervalProvider;
import us.ihmc.commons.time.TimeIntervalReadOnly;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.matrixlib.MatrixTools;

public class PolynomialEstimator
implements TimeIntervalProvider,
Settable<PolynomialEstimator> {
    private static final boolean debug = false;
    private static final double regularization = 1.0E-5;
    private static final double defaultWeight = 1.0;
    private final LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.general((int)0, (int)0);
    private final DMatrixRMaj hessian = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj gradient = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj equalityConstraintJacobian = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj equalityConstraintJacobianTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj equalityConstraintObjective = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj A = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj b = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj coefficientsAndLagrangeMultipliers = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj coefficients = new DMatrixRMaj(0, 0);
    private int order = 0;
    private final TimeIntervalBasics timeIntervalBasics = new TimeInterval(0.0, Double.POSITIVE_INFINITY);
    private double position = Double.NaN;
    private double velocity = Double.NaN;
    private double acceleration = Double.NaN;

    public TimeIntervalBasics getTimeInterval() {
        return this.timeIntervalBasics;
    }

    public void set(PolynomialEstimator other) {
        this.getTimeInterval().set((TimeIntervalReadOnly)other.getTimeInterval());
        this.reshape(other.getOrder());
        this.coefficients.set((DMatrixD1)other.coefficients);
    }

    public int getOrder() {
        return this.order;
    }

    public void reset() {
        this.getTimeInterval().setInterval(0.0, Double.POSITIVE_INFINITY);
        this.position = Double.NaN;
        this.velocity = Double.NaN;
        this.acceleration = Double.NaN;
    }

    public void reshape(int order) {
        this.order = order;
        this.hessian.reshape(order, order);
        this.gradient.reshape(order, 1);
        this.coefficients.reshape(order, 1);
        this.equalityConstraintJacobian.reshape(0, order);
        this.equalityConstraintObjective.reshape(0, 0);
        this.hessian.zero();
        this.gradient.zero();
        this.coefficients.zero();
        this.equalityConstraintJacobian.zero();
        this.equalityConstraintObjective.zero();
    }

    public void addObjectivePosition(double time, double value) {
        this.addObjectivePosition(1.0, time, value);
    }

    public void addObjectivePosition(double weight, double time, double value) {
        time -= this.getTimeInterval().getStartTime();
        double timeI = 1.0;
        for (int i = 0; i < this.order; ++i) {
            this.hessian.add(i, i, weight * timeI * timeI);
            this.gradient.add(i, 0, weight * value * timeI);
            double timeJ = timeI * time;
            for (int j = i + 1; j < this.order; ++j) {
                double hessianEntrant = weight * timeI * timeJ;
                this.hessian.add(i, j, hessianEntrant);
                this.hessian.add(j, i, hessianEntrant);
                timeJ *= time;
            }
            timeI *= time;
        }
    }

    public void addObjectiveVelocity(double time, double value) {
        this.addObjectiveVelocity(1.0, time, value);
    }

    public void addObjectiveVelocity(double weight, double time, double value) {
        time -= this.getTimeInterval().getStartTime();
        double timeI = 1.0;
        for (int idx = 0; idx < this.order - 1; ++idx) {
            int row = idx + 1;
            this.hessian.add(row, row, weight * (double)row * (double)row * timeI * timeI);
            this.gradient.add(row, 0, weight * value * (double)row * timeI);
            double timeJ = timeI * time;
            for (int j = idx + 1; j < this.order - 1; ++j) {
                int col = j + 1;
                double hessianEntrant = weight * (double)row * (double)col * timeI * timeJ;
                this.hessian.add(row, col, hessianEntrant);
                this.hessian.add(col, row, hessianEntrant);
                timeJ *= time;
            }
            timeI *= time;
        }
    }

    public void addObjectiveAcceleration(double time, double value) {
        this.addObjectiveAcceleration(1.0, time, value);
    }

    public void addObjectiveAcceleration(double weight, double time, double value) {
        time -= this.getTimeInterval().getStartTime();
        double timeI = 1.0;
        for (int idx = 0; idx < this.order - 2; ++idx) {
            int row = idx + 2;
            int prefixI = row * (row - 1);
            this.hessian.add(row, row, weight * (double)prefixI * (double)prefixI * timeI * timeI);
            this.gradient.add(row, 0, weight * value * (double)prefixI * timeI);
            double timeJ = timeI * time;
            for (int j = idx + 1; j < this.order - 2; ++j) {
                int col = j + 2;
                int prefixJ = col * (col - 1);
                double hessianEntrant = weight * (double)prefixI * (double)prefixJ * timeI * timeJ;
                this.hessian.add(row, col, hessianEntrant);
                this.hessian.add(col, row, hessianEntrant);
                timeJ *= time;
            }
            timeI *= time;
        }
    }

    public void addConstraintPosition(double time, double value) {
        int previousSize = this.equalityConstraintObjective.getNumRows();
        int problemSize = this.equalityConstraintJacobian.getNumCols();
        this.equalityConstraintJacobian.reshape(previousSize + 1, problemSize, true);
        this.equalityConstraintObjective.reshape(previousSize + 1, 1, true);
        double timeI = 1.0;
        for (int idx = 0; idx < this.order; ++idx) {
            this.equalityConstraintJacobian.set(previousSize, idx, timeI);
            timeI *= time;
        }
        this.equalityConstraintObjective.set(previousSize, 0, value);
    }

    public void addConstraintVelocity(double time, double value) {
        int previousSize = this.equalityConstraintObjective.getNumRows();
        int problemSize = this.equalityConstraintJacobian.getNumCols();
        this.equalityConstraintJacobian.reshape(previousSize + 1, problemSize, true);
        this.equalityConstraintObjective.reshape(previousSize + 1, 1, true);
        double timeI = 1.0;
        for (int idx = 1; idx < this.order; ++idx) {
            this.equalityConstraintJacobian.set(previousSize, idx, (double)idx * timeI);
            timeI *= time;
        }
        this.equalityConstraintObjective.set(previousSize, 0, value);
    }

    public void addConstraintAcceleration(double time, double value) {
        int previousSize = this.equalityConstraintObjective.getNumRows();
        int problemSize = this.equalityConstraintJacobian.getNumCols();
        this.equalityConstraintJacobian.reshape(previousSize + 1, problemSize, true);
        this.equalityConstraintObjective.reshape(previousSize + 1, 1, true);
        double timeI = 1.0;
        for (int idx = 2; idx < this.order; ++idx) {
            this.equalityConstraintJacobian.set(previousSize, idx, (double)(idx * (idx - 1)) * timeI);
            timeI *= time;
        }
        this.equalityConstraintObjective.set(previousSize, 0, value);
    }

    public void solve() {
        MatrixTools.addDiagonal((DMatrix)this.hessian, (double)1.0E-5);
        int constraints = this.equalityConstraintObjective.getNumRows();
        this.A.reshape(this.order + constraints, this.order + constraints);
        this.b.reshape(this.order + constraints, 1);
        this.coefficientsAndLagrangeMultipliers.reshape(this.order + constraints, 1);
        this.A.zero();
        this.b.zero();
        this.equalityConstraintJacobianTranspose.reshape(this.order, constraints);
        CommonOps_DDRM.transpose((DMatrixRMaj)this.equalityConstraintJacobian, (DMatrixRMaj)this.equalityConstraintJacobianTranspose);
        MatrixTools.setMatrixBlock((DMatrix)this.A, (int)0, (int)0, (DMatrix)this.hessian, (int)0, (int)0, (int)this.order, (int)this.order, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.A, (int)0, (int)this.order, (DMatrix)this.equalityConstraintJacobianTranspose, (int)0, (int)0, (int)this.order, (int)constraints, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.A, (int)this.order, (int)0, (DMatrix)this.equalityConstraintJacobian, (int)0, (int)0, (int)constraints, (int)this.order, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.b, (int)0, (int)0, (DMatrix)this.gradient, (int)0, (int)0, (int)this.order, (int)1, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.b, (int)this.order, (int)0, (DMatrix)this.equalityConstraintObjective, (int)0, (int)0, (int)constraints, (int)1, (double)1.0);
        this.solver.setA((Matrix)this.A);
        this.solver.solve((Matrix)this.b, (Matrix)this.coefficientsAndLagrangeMultipliers);
        MatrixTools.setMatrixBlock((DMatrix)this.coefficients, (int)0, (int)0, (DMatrix)this.coefficientsAndLagrangeMultipliers, (int)0, (int)0, (int)this.order, (int)1, (double)1.0);
    }

    public void compute(double time) {
        int idx;
        this.position = 0.0;
        this.velocity = 0.0;
        this.acceleration = 0.0;
        time -= this.getTimeInterval().getStartTime();
        time = Math.min(time, this.getTimeInterval().getDuration());
        double timeI = 1.0;
        for (idx = 0; idx < this.order - 2; ++idx) {
            this.position += this.coefficients.get(idx) * timeI;
            this.velocity += (double)(idx + 1) * this.coefficients.get(idx + 1) * timeI;
            this.acceleration += (double)((idx + 2) * (idx + 1)) * this.coefficients.get(idx + 2) * timeI;
            timeI *= time;
        }
        while (idx < this.order - 1) {
            this.position += this.coefficients.get(idx) * timeI;
            this.velocity += (double)(idx + 1) * this.coefficients.get(idx + 1) * timeI;
            timeI *= time;
            ++idx;
        }
        while (idx < this.order) {
            this.position += this.coefficients.get(idx) * timeI;
            timeI *= time;
            ++idx;
        }
    }

    public DMatrixRMaj getCoefficients() {
        return this.coefficients;
    }

    public double getPosition() {
        return this.position;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getAcceleration() {
        return this.acceleration;
    }
}

