/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.commons.MathTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.math.trajectories.interfaces.OneDoFJointTrajectoryGenerator;
import us.ihmc.robotics.trajectories.yoVariables.YoPolynomial;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class OneDoFJointQuinticTrajectoryGenerator
implements OneDoFJointTrajectoryGenerator {
    private final YoRegistry registry;
    private final YoDouble finalPosition;
    private final YoDouble currentPosition;
    private final YoDouble currentVelocity;
    private final YoDouble currentAcceleration;
    private final YoPolynomial polynomial;
    private final YoDouble trajectoryTime;
    private final DoubleProvider trajectoryTimeProvider;
    private final YoDouble currentTime;
    private final OneDoFJointBasics joint;

    public OneDoFJointQuinticTrajectoryGenerator(String namePrefix, OneDoFJointBasics joint, DoubleProvider trajectoryTimeProvider, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.joint = joint;
        this.polynomial = new YoPolynomial(namePrefix + "Polynomial", 6, this.registry);
        this.trajectoryTime = new YoDouble(namePrefix + "TrajectoryTime", this.registry);
        this.currentTime = new YoDouble(namePrefix + "CurrentTime", this.registry);
        this.currentPosition = new YoDouble(namePrefix + "CurrentPosition", this.registry);
        this.currentVelocity = new YoDouble(namePrefix + "CurrentVelocity", this.registry);
        this.currentAcceleration = new YoDouble(namePrefix + "CurrentAcceleration", this.registry);
        this.finalPosition = new YoDouble(namePrefix + "FinalPosition", this.registry);
        this.trajectoryTimeProvider = trajectoryTimeProvider;
        parentRegistry.addChild(this.registry);
    }

    @Override
    public void initialize(double initialPosition, double initialVelocity) {
        this.currentTime.set(0.0);
        this.trajectoryTime.set(this.trajectoryTimeProvider.getValue());
        this.polynomial.setQuintic(0.0, this.trajectoryTime.getDoubleValue(), initialPosition, initialVelocity, 0.0, this.finalPosition.getDoubleValue(), 0.0, 0.0);
        this.currentPosition.set(initialPosition);
        this.currentVelocity.set(initialVelocity);
        this.currentAcceleration.set(0.0);
    }

    public void initialize() {
        this.initialize(this.joint.getQ(), this.joint.getQd());
    }

    public void compute(double time) {
        this.currentTime.set(time);
        time = MathTools.clamp((double)time, (double)0.0, (double)this.trajectoryTime.getDoubleValue());
        this.polynomial.compute(time);
        if (this.isDone() || this.trajectoryTime.getDoubleValue() <= 0.0) {
            this.currentPosition.set(this.finalPosition.getDoubleValue());
            this.currentVelocity.set(0.0);
            this.currentAcceleration.set(0.0);
        } else {
            this.currentPosition.set(this.polynomial.getValue());
            this.currentVelocity.set(this.polynomial.getVelocity());
            this.currentAcceleration.set(this.polynomial.getAcceleration());
        }
    }

    public boolean isDone() {
        return this.currentTime.getDoubleValue() >= this.trajectoryTime.getDoubleValue();
    }

    public double getValue() {
        return this.currentPosition.getDoubleValue();
    }

    public double getVelocity() {
        return this.currentVelocity.getDoubleValue();
    }

    public double getAcceleration() {
        return this.currentAcceleration.getDoubleValue();
    }

    public void setFinalPosition(double finalPosition) {
        this.finalPosition.set(finalPosition);
    }
}

