/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.robotics.alphaToAlpha.AlphaToAlphaFunction;
import us.ihmc.robotics.alphaToAlpha.StretchedLinearAlphaToAlphaFunction;
import us.ihmc.robotics.alphaToAlpha.StretchedSlowInMiddleAlphaToAlphaFunction;
import us.ihmc.robotics.trajectories.TrapezoidalVelocityTrajectory;

@Deprecated
public class NDoFTrapezoidalVelocityTrajectory {
    private final TrapezoidalVelocityTrajectory[] trajectories;
    private AlphaToAlphaFunction[] alphaToAlphaFunctions;
    private final double t0;
    private double tFMax;
    private final AlphaToAlphaType alphaToAlphaType;

    public NDoFTrapezoidalVelocityTrajectory(double t0, double[] x0, double[] xF, double[] v0, double[] vF, double[] vMax, double[] aMax, AlphaToAlphaType alphaToAlphaType) {
        this.trajectories = NDoFTrapezoidalVelocityTrajectory.createTrajectories(t0, x0, xF, v0, vF, vMax, aMax);
        this.t0 = t0;
        this.tFMax = TrapezoidalVelocityTrajectory.getTFMax(this.trajectories);
        this.alphaToAlphaFunctions = null;
        this.alphaToAlphaType = alphaToAlphaType;
    }

    public void synchronize(double tFMax) {
        if (this.alphaToAlphaType == null) {
            return;
        }
        this.tFMax = tFMax;
        switch (this.alphaToAlphaType) {
            case LINEAR: {
                this.alphaToAlphaFunctions = NDoFTrapezoidalVelocityTrajectory.getLinearAlphaToAlphaFunctions(this.trajectories, tFMax);
                break;
            }
            case STRETCH_IN_MIDDLE: {
                this.alphaToAlphaFunctions = NDoFTrapezoidalVelocityTrajectory.getStretchedInMiddleAlphaToAlphaFunctions(this.trajectories, tFMax);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void synchronize() {
        this.synchronize(this.tFMax);
    }

    public void synchronizeWith(NDoFTrapezoidalVelocityTrajectory trajectory) {
        NDoFTrapezoidalVelocityTrajectory.synchronize(new NDoFTrapezoidalVelocityTrajectory[]{this, trajectory});
    }

    public double getT0() {
        return this.t0;
    }

    public double[] getTFArray() {
        int n = this.trajectories.length;
        double[] ret = new double[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = this.trajectories[i].getFinalTime();
        }
        return ret;
    }

    public double[] getX0Array() {
        int n = this.trajectories.length;
        double[] ret = new double[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = this.trajectories[i].getX0();
        }
        return ret;
    }

    public double[] getV0Array() {
        int n = this.trajectories.length;
        double[] ret = new double[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = this.trajectories[i].getV0();
        }
        return ret;
    }

    public double getTFMax() {
        return this.tFMax;
    }

    public double getDTFMax() {
        return this.tFMax - this.t0;
    }

    public double getPosition(int index, double t) {
        if (this.alphaToAlphaFunctions == null) {
            return this.trajectories[index].getPosition(t);
        }
        double deltaTime = this.tFMax - this.t0;
        double alphaY = deltaTime < 1.0E-10 ? 1.0 : (t - this.t0) / deltaTime;
        double alphaPrime = this.alphaToAlphaFunctions[index].getAlphaPrime(alphaY);
        double tPrime = this.t0 + this.trajectories[index].getMoveDuration() * alphaPrime;
        double position = this.trajectories[index].getPosition(tPrime);
        return position;
    }

    public double getVelocity(int index, double t) {
        if (this.alphaToAlphaFunctions == null) {
            return this.trajectories[index].getVelocity(t);
        }
        double deltaTime = this.tFMax - this.t0;
        double alphaY = deltaTime < 1.0E-10 ? 1.0 : (t - this.t0) / deltaTime;
        double alphaPrime = this.alphaToAlphaFunctions[index].getAlphaPrime(alphaY);
        double tPrime = this.t0 + this.trajectories[index].getMoveDuration() * alphaPrime;
        double dAlphaDT = 1.0 / deltaTime;
        double dTPrimeDAlphaPrime = this.trajectories[index].getMoveDuration();
        if (deltaTime < 1.0E-10) {
            throw new RuntimeException("deltaTime < 1e-10");
        }
        double dAlphaDT_times_dTPrimeDAlphaPrime = dAlphaDT * dTPrimeDAlphaPrime;
        double dAlphaPrimeDAlpha = this.alphaToAlphaFunctions[index].getDerivativeAtAlpha(alphaY);
        double dXDTPrime = this.trajectories[index].getVelocity(tPrime);
        double dXDT = dAlphaDT_times_dTPrimeDAlphaPrime * dXDTPrime * dAlphaPrimeDAlpha;
        if (Double.isNaN(dXDT)) {
            throw new RuntimeException("Double.isNaN(dXDT)");
        }
        return dXDT;
    }

    public double getAcceleration(int index, double t) {
        if (this.alphaToAlphaFunctions == null) {
            return this.trajectories[index].getAcceleration(t);
        }
        double alphaY = (t - this.t0) / (this.tFMax - this.t0);
        double alphaPrime = this.alphaToAlphaFunctions[index].getAlphaPrime(alphaY);
        double tPrime = this.t0 + this.trajectories[index].getMoveDuration() * alphaPrime;
        double dAlphaDT = 1.0 / (this.tFMax - this.t0);
        double dAlphaPrimeDAlpha = this.alphaToAlphaFunctions[index].getDerivativeAtAlpha(alphaY);
        double dTPrimeDAlphaPrime = this.trajectories[index].getMoveDuration();
        double dXDTPrime = this.trajectories[index].getVelocity(tPrime);
        double dTPrimeDT = dTPrimeDAlphaPrime * dAlphaPrimeDAlpha * dAlphaDT;
        double d2AlphaPrimeDAlpha2 = this.alphaToAlphaFunctions[index].getSecondDerivativeAtAlpha(alphaY);
        double d2XDTPrime2 = this.trajectories[index].getAcceleration(tPrime);
        double d2AlphaPrimeDT2 = d2AlphaPrimeDAlpha2 * dAlphaDT * dAlphaDT;
        double d2TPrimeDT2 = dTPrimeDAlphaPrime * d2AlphaPrimeDT2;
        double d2XDT2 = d2XDTPrime2 * dTPrimeDT * dTPrimeDT + dXDTPrime * d2TPrimeDT2;
        return d2XDT2;
    }

    public double getMaximumVelocity(int index) {
        return this.trajectories[index].getMaximumVelocity();
    }

    public double getMaximumAcceleration(int index) {
        return this.trajectories[index].getMaximumAcceleration();
    }

    public double[] getPositionArray(double t) {
        int n = this.trajectories.length;
        double[] positions = new double[n];
        for (int i = 0; i < n; ++i) {
            positions[i] = this.getPosition(i, t);
        }
        return positions;
    }

    public double[] getVelocityArray(double t) {
        int n = this.trajectories.length;
        double[] velocities = new double[n];
        for (int i = 0; i < n; ++i) {
            velocities[i] = this.getVelocity(i, t);
        }
        return velocities;
    }

    public double[] getAccelerationArray(double t) {
        int n = this.trajectories.length;
        double[] accelerations = new double[n];
        for (int i = 0; i < n; ++i) {
            accelerations[i] = this.getAcceleration(i, t);
        }
        return accelerations;
    }

    public double[] getMaximumVelocityArray() {
        int n = this.trajectories.length;
        double[] maximumVelocities = new double[n];
        for (int i = 0; i < n; ++i) {
            maximumVelocities[i] = this.getMaximumVelocity(i);
        }
        return maximumVelocities;
    }

    public double[] getMaximumAccelerationArray() {
        int n = this.trajectories.length;
        double[] maximumAccelerations = new double[n];
        for (int i = 0; i < n; ++i) {
            maximumAccelerations[i] = this.getMaximumAcceleration(i);
        }
        return maximumAccelerations;
    }

    public int size() {
        return this.trajectories.length;
    }

    public static void synchronize(NDoFTrapezoidalVelocityTrajectory[] trajectories) {
        double tFMaxMax = NDoFTrapezoidalVelocityTrajectory.getTFMaxMax(trajectories);
        for (NDoFTrapezoidalVelocityTrajectory trajectory : trajectories) {
            trajectory.synchronize(tFMaxMax);
        }
    }

    private TrapezoidalVelocityTrajectory[] getTrajectoriesCopy() {
        TrapezoidalVelocityTrajectory[] copy = new TrapezoidalVelocityTrajectory[this.trajectories.length];
        for (int i = 0; i < this.trajectories.length; ++i) {
            copy[i] = new TrapezoidalVelocityTrajectory(this.trajectories[i]);
        }
        return copy;
    }

    private static TrapezoidalVelocityTrajectory[] createTrajectories(double t0, double[] x0, double[] xF, double[] v0, double[] vF, double[] vMax, double[] aMax) {
        int n = x0.length;
        if (xF.length != n || v0.length != n || vF.length != n || vMax.length != n || aMax.length != n) {
            throw new RuntimeException("Array lengths are not equal");
        }
        TrapezoidalVelocityTrajectory[] trajectories = new TrapezoidalVelocityTrajectory[n];
        for (int i = 0; i < n; ++i) {
            trajectories[i] = new TrapezoidalVelocityTrajectory(t0, x0[i], xF[i], v0[i], vF[i], vMax[i], aMax[i]);
        }
        return trajectories;
    }

    private static double getTFMaxMax(NDoFTrapezoidalVelocityTrajectory[] trajectories) {
        double tFMaxMax = Double.NEGATIVE_INFINITY;
        for (NDoFTrapezoidalVelocityTrajectory trajectory : trajectories) {
            double tFMax = trajectory.getTFMax();
            if (!(tFMax > tFMaxMax)) continue;
            tFMaxMax = tFMax;
        }
        return tFMaxMax;
    }

    private static StretchedSlowInMiddleAlphaToAlphaFunction[] getStretchedInMiddleAlphaToAlphaFunctions(TrapezoidalVelocityTrajectory[] trajectories, double tFMax) {
        int n = trajectories.length;
        StretchedSlowInMiddleAlphaToAlphaFunction[] alphaToAlphaFunctions = new StretchedSlowInMiddleAlphaToAlphaFunction[n];
        for (int i = 0; i < n; ++i) {
            double t0 = trajectories[i].getT0();
            double tF = trajectories[i].getFinalTime();
            alphaToAlphaFunctions[i] = tF > t0 ? new StretchedSlowInMiddleAlphaToAlphaFunction((tFMax - t0) / (tF - t0)) : new StretchedSlowInMiddleAlphaToAlphaFunction(1.0);
        }
        return alphaToAlphaFunctions;
    }

    private static StretchedLinearAlphaToAlphaFunction[] getLinearAlphaToAlphaFunctions(TrapezoidalVelocityTrajectory[] trajectories, double tFMax) {
        int n = trajectories.length;
        StretchedLinearAlphaToAlphaFunction[] alphaToAlphaFunctions = new StretchedLinearAlphaToAlphaFunction[n];
        for (int i = 0; i < n; ++i) {
            double t0 = trajectories[i].getT0();
            double tF = trajectories[i].getFinalTime();
            alphaToAlphaFunctions[i] = new StretchedLinearAlphaToAlphaFunction();
        }
        return alphaToAlphaFunctions;
    }

    public String toString() {
        Object ret = "Trajectories:";
        for (TrapezoidalVelocityTrajectory trap : this.trajectories) {
            ret = (String)ret + "\n";
            ret = (String)ret + trap.toString();
        }
        ret = (String)ret + "\n\nalphaToAlphaFunctions:";
        for (AlphaToAlphaFunction alpha : this.alphaToAlphaFunctions) {
            ret = (String)ret + "\n";
            ret = (String)ret + alpha.toString();
        }
        return ret;
    }

    public static enum AlphaToAlphaType {
        LINEAR,
        STRETCH_IN_MIDDLE;

    }
}

