/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.commons.time.TimeIntervalBasics;
import us.ihmc.commons.time.TimeIntervalProvider;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.math.trajectories.PolynomialEstimator3D;
import us.ihmc.robotics.math.trajectories.core.Polynomial3DFrameFactories;
import us.ihmc.robotics.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;

public class FixedFramePolynomialEstimator3D
implements FixedFramePositionTrajectoryGenerator,
TimeIntervalProvider,
Settable<FixedFramePolynomialEstimator3D> {
    private final FramePoint3DReadOnly position;
    private final FrameVector3DReadOnly velocity;
    private final FrameVector3DReadOnly acceleration;
    private double currentTime = 0.0;
    private final PolynomialEstimator3D estimator = new PolynomialEstimator3D();
    private final ReferenceFrame referenceFrame;

    public FixedFramePolynomialEstimator3D(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
        this.position = Polynomial3DFrameFactories.newLinkedFramePoint3DReadOnly((ReferenceFrameHolder)this, (Tuple3DReadOnly)this.estimator.getPosition());
        this.velocity = Polynomial3DFrameFactories.newLinkedFrameVector3DReadOnly((ReferenceFrameHolder)this, this.estimator.getVelocity());
        this.acceleration = Polynomial3DFrameFactories.newLinkedFrameVector3DReadOnly((ReferenceFrameHolder)this, this.estimator.getAcceleration());
    }

    public void reset() {
        this.currentTime = Double.NaN;
        this.estimator.reset();
    }

    public void reshape(int order) {
        this.estimator.reshape(order);
    }

    public void set(FixedFramePolynomialEstimator3D other) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)other);
        this.estimator.set(other.estimator);
    }

    public TimeIntervalBasics getTimeInterval() {
        return this.estimator.getTimeInterval();
    }

    public void addObjectivePosition(double time, FrameTuple3DReadOnly value) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)value);
        this.estimator.addObjectivePosition(time, (Tuple3DReadOnly)value);
    }

    public void addObjectivePosition(double weight, double time, FrameTuple3DReadOnly value) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)value);
        this.estimator.addObjectivePosition(weight, time, (Tuple3DReadOnly)value);
    }

    public void addObjectiveVelocity(double time, FrameTuple3DReadOnly value) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)value);
        this.estimator.addObjectiveVelocity(time, (Tuple3DReadOnly)value);
    }

    public void addObjectiveVelocity(double weight, double time, FrameTuple3DReadOnly value) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)value);
        this.estimator.addObjectiveVelocity(weight, time, (Tuple3DReadOnly)value);
    }

    public void addConstraintPosition(double time, FrameTuple3DReadOnly value) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)value);
        this.estimator.addConstraintPosition(time, (Tuple3DReadOnly)value);
    }

    public void addConstraintVelocity(double time, FrameTuple3DReadOnly value) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)value);
        this.estimator.addConstraintVelocity(time, (Tuple3DReadOnly)value);
    }

    public void initialize() {
        this.estimator.initialize();
    }

    public void compute(double time) {
        this.estimator.compute(time);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public FramePoint3DReadOnly getPosition() {
        return this.position;
    }

    public FrameVector3DReadOnly getVelocity() {
        return this.velocity;
    }

    public FrameVector3DReadOnly getAcceleration() {
        return this.acceleration;
    }

    public boolean isDone() {
        return this.currentTime >= this.getTimeInterval().getEndTime();
    }

    public void showVisualization() {
    }

    public void hideVisualization() {
    }
}

