/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPositionTrajectoryGenerator;
import us.ihmc.robotics.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BlendedWaypointPositionTrajectoryGenerator
implements FixedFramePositionTrajectoryGenerator {
    private final FixedFramePositionTrajectoryGenerator trajectory;
    private final ReferenceFrame trajectoryFrame;
    private final Point3D initialConstraintPositionError = new Point3D();
    private final Vector3D initialConstraintVelocityError = new Vector3D();
    private final Point3D finalConstraintPositionError = new Point3D();
    private final Vector3D finalConstraintVelocityError = new Vector3D();
    private final Point3D constraintPositionError = new Point3D();
    private final Vector3D constraintVelocityError = new Vector3D();
    private static final Point3DReadOnly zeroPoint = EuclidCoreTools.origin3D;
    private static final Vector3DReadOnly zeroVector = EuclidCoreTools.zeroVector3D;
    private final FramePoint3D position = new FramePoint3D();
    private final FrameVector3D velocity = new FrameVector3D();
    private final FrameVector3D acceleration = new FrameVector3D();
    private final FramePoint3D tempPosition = new FramePoint3D();
    private final FrameVector3D tempVelocity = new FrameVector3D();
    private final MultipleWaypointsPositionTrajectoryGenerator blendTrajectory;

    public BlendedWaypointPositionTrajectoryGenerator(String prefix, FixedFramePositionTrajectoryGenerator trajectory, ReferenceFrame trajectoryFrame, YoRegistry parentRegistry) {
        this.trajectory = trajectory;
        this.trajectoryFrame = trajectoryFrame;
        this.blendTrajectory = new MultipleWaypointsPositionTrajectoryGenerator(prefix + "BlendTrajectory", 4, trajectoryFrame, parentRegistry);
        this.position.changeFrame(trajectoryFrame);
        this.velocity.changeFrame(trajectoryFrame);
        this.acceleration.changeFrame(trajectoryFrame);
        this.tempPosition.changeFrame(trajectoryFrame);
        this.tempVelocity.changeFrame(trajectoryFrame);
        this.clear();
    }

    public void clear() {
        this.clearInitialConstraint();
        this.clearFinalConstraint();
        this.blendTrajectory.clear();
    }

    public void clearInitialConstraint() {
        this.initialConstraintPositionError.setToZero();
        this.initialConstraintVelocityError.setToZero();
    }

    public MultipleWaypointsPositionTrajectoryGenerator getBlendTrajectory() {
        return this.blendTrajectory;
    }

    public void clearFinalConstraint() {
        this.finalConstraintPositionError.setToZero();
        this.finalConstraintVelocityError.setToZero();
    }

    public void blendInitialConstraint(FramePoint3DReadOnly initialPosition, double initialTime, double blendDuration) {
        this.clearInitialConstraint();
        this.computeInitialConstraintStartingError(initialPosition, initialTime);
        this.computeInitialConstraintPolynomial(initialTime, blendDuration);
    }

    public void blendInitialConstraint(FramePoint3DReadOnly initialPosition, FrameVector3DReadOnly initialVelocity, double initialTime, double blendDuration) {
        this.clearInitialConstraint();
        this.computeInitialConstraintStartingError(initialPosition, initialVelocity, initialTime);
        this.computeInitialConstraintPolynomial(initialTime, blendDuration);
    }

    public void blendFinalConstraint(FramePoint3DReadOnly finalPosition, FrameVector3DReadOnly finalVelocity, double finalTime, double blendDuration) {
        this.clearFinalConstraint();
        this.computeFinalConstraintEndingError(finalPosition, finalVelocity, finalTime);
        this.computeFinalConstraintPolynomial(finalTime, blendDuration);
    }

    public void blendFinalConstraint(FramePoint3DReadOnly finalPosition, double finalTime, double blendDuration) {
        this.clearFinalConstraint();
        this.computeFinalConstraintEndingError(finalPosition, finalTime);
        this.computeFinalConstraintPolynomial(finalTime, blendDuration);
    }

    public void addBlendWaypoint(FramePoint3DReadOnly desiredPosition, double time) {
        this.computeConstraintPositionError(desiredPosition, time, (Point3DBasics)this.constraintPositionError);
        this.blendTrajectory.appendWaypoint(time, (Point3DReadOnly)this.constraintPositionError, zeroVector);
    }

    public void addBlendWaypoint(FramePoint3DReadOnly desiredPosition, FrameVector3DReadOnly desiredVelocity, double time) {
        this.computeConstraintPositionError(desiredPosition, time, (Point3DBasics)this.constraintPositionError);
        this.computeConstraintVelocityError(desiredVelocity, (Vector3DBasics)this.constraintVelocityError);
        this.blendTrajectory.appendWaypoint(time, (Point3DReadOnly)this.constraintPositionError, (Vector3DReadOnly)this.constraintVelocityError);
    }

    public void initializeTrajectory() {
        this.trajectory.initialize();
    }

    public void initializeBlendingTrajectory() {
        this.blendTrajectory.initialize();
    }

    public ReferenceFrame getReferenceFrame() {
        return this.trajectoryFrame;
    }

    public FramePoint3DReadOnly getPosition() {
        return this.position;
    }

    public FrameVector3DReadOnly getVelocity() {
        return this.velocity;
    }

    public FrameVector3DReadOnly getAcceleration() {
        return this.acceleration;
    }

    public void showVisualization() {
        this.trajectory.showVisualization();
    }

    public void hideVisualization() {
        this.trajectory.hideVisualization();
    }

    public void initialize() {
        this.trajectory.initialize();
    }

    public void compute(double time) {
        this.trajectory.compute(time);
        this.position.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getPosition());
        this.velocity.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getVelocity());
        this.acceleration.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getAcceleration());
        this.position.changeFrame(this.trajectoryFrame);
        this.velocity.changeFrame(this.trajectoryFrame);
        this.acceleration.changeFrame(this.trajectoryFrame);
        if (!this.blendTrajectory.isEmpty()) {
            this.blendTrajectory.compute(time);
            this.position.add((FrameTuple3DReadOnly)this.blendTrajectory.getPosition());
            this.velocity.add((FrameTuple3DReadOnly)this.blendTrajectory.getVelocity());
            this.acceleration.add((FrameTuple3DReadOnly)this.blendTrajectory.getAcceleration());
        }
    }

    public boolean isDone() {
        return this.trajectory.isDone();
    }

    private void computeInitialConstraintStartingError(FramePoint3DReadOnly initialPosition, double initialTime) {
        this.computeConstraintPositionError(initialPosition, initialTime, (Point3DBasics)this.initialConstraintPositionError);
    }

    private void computeInitialConstraintStartingError(FramePoint3DReadOnly initialPosition, FrameVector3DReadOnly initialVelocity, double initialTime) {
        this.computeInitialConstraintStartingError(initialPosition, initialTime);
        this.computeConstraintVelocityError(initialVelocity, (Vector3DBasics)this.initialConstraintVelocityError);
    }

    private void computeFinalConstraintEndingError(FramePoint3DReadOnly finalPosition, double finalTime) {
        this.computeConstraintPositionError(finalPosition, finalTime, (Point3DBasics)this.finalConstraintPositionError);
    }

    private void computeFinalConstraintEndingError(FramePoint3DReadOnly finalPosition, FrameVector3DReadOnly finalVelocity, double finalTime) {
        this.computeFinalConstraintEndingError(finalPosition, finalTime);
        this.computeConstraintVelocityError(finalVelocity, (Vector3DBasics)this.finalConstraintVelocityError);
    }

    private void computeConstraintPositionError(FramePoint3DReadOnly desiredPosition, double time, Point3DBasics positionErrorToPack) {
        this.trajectory.compute(time);
        this.trajectoryFrame.checkReferenceFrameMatch(desiredPosition.getReferenceFrame());
        this.tempPosition.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getPosition());
        this.tempPosition.changeFrame(this.trajectoryFrame);
        positionErrorToPack.sub((Tuple3DReadOnly)desiredPosition, (Tuple3DReadOnly)this.tempPosition);
    }

    private void computeConstraintVelocityError(FrameVector3DReadOnly desiredVelocity, Vector3DBasics velocityErrorToPack) {
        this.trajectoryFrame.checkReferenceFrameMatch(desiredVelocity.getReferenceFrame());
        this.tempVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getVelocity());
        this.tempVelocity.changeFrame(this.trajectoryFrame);
        velocityErrorToPack.sub((Tuple3DReadOnly)desiredVelocity, (Tuple3DReadOnly)this.tempVelocity);
    }

    private void computeInitialConstraintPolynomial(double initialTime, double blendDuration) {
        this.blendTrajectory.appendWaypoint(initialTime, (Point3DReadOnly)this.initialConstraintPositionError, (Vector3DReadOnly)this.initialConstraintVelocityError);
        this.blendTrajectory.appendWaypoint(initialTime + blendDuration, zeroPoint, zeroVector);
        this.blendTrajectory.initialize();
    }

    private void computeFinalConstraintPolynomial(double finalTime, double blendDuration) {
        this.blendTrajectory.appendWaypoint(finalTime - blendDuration, zeroPoint, zeroVector);
        this.blendTrajectory.appendWaypoint(finalTime, (Point3DReadOnly)this.finalConstraintPositionError, (Vector3DReadOnly)this.finalConstraintVelocityError);
        this.blendTrajectory.initialize();
    }
}

