/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.robotics.trajectories.yoVariables.YoPolynomial3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class BlendedPositionTrajectoryGenerator
implements FixedFramePositionTrajectoryGenerator {
    private final FixedFramePositionTrajectoryGenerator trajectory;
    private final ReferenceFrame trajectoryFrame;
    private final YoPolynomial3D initialConstraintPolynomial;
    private final YoPolynomial3D finalConstraintPolynomial;
    private final YoDouble initialBlendTimeOffset;
    private final YoDouble initialBlendStartTime;
    private final YoDouble initialBlendEndTime;
    private final YoDouble finalBlendTimeOffset;
    private final YoDouble finalBlendStartTime;
    private final YoDouble finalBlendEndTime;
    private final Vector3D initialConstraintPositionError = new Vector3D();
    private final Vector3D initialConstraintVelocityError = new Vector3D();
    private final Vector3D finalConstraintPositionError = new Vector3D();
    private final Vector3D finalConstraintVelocityError = new Vector3D();
    private static final Vector3DReadOnly zeroVector = EuclidCoreTools.zeroVector3D;
    private final FramePoint3D position = new FramePoint3D();
    private final FrameVector3D velocity = new FrameVector3D();
    private final FrameVector3D acceleration = new FrameVector3D();
    private final FramePoint3D tempPosition = new FramePoint3D();
    private final FrameVector3D tempVelocity = new FrameVector3D();

    public BlendedPositionTrajectoryGenerator(String prefix, FixedFramePositionTrajectoryGenerator trajectory, ReferenceFrame trajectoryFrame, YoRegistry parentRegistry) {
        this.trajectory = trajectory;
        this.trajectoryFrame = trajectoryFrame;
        this.initialConstraintPolynomial = new YoPolynomial3D(prefix + "InitialConstraintPolynomial", 6, parentRegistry);
        this.finalConstraintPolynomial = new YoPolynomial3D(prefix + "FinalConstraintPolynomial", 6, parentRegistry);
        this.initialBlendTimeOffset = new YoDouble(prefix + "InitialBlendTimeOffset", parentRegistry);
        this.initialBlendStartTime = new YoDouble(prefix + "InitialBlendStartTime", parentRegistry);
        this.initialBlendEndTime = new YoDouble(prefix + "InitialBlendEndTime", parentRegistry);
        this.finalBlendTimeOffset = new YoDouble(prefix + "FinalBlendTimeOffset", parentRegistry);
        this.finalBlendStartTime = new YoDouble(prefix + "FinalBlendStartTime", parentRegistry);
        this.finalBlendEndTime = new YoDouble(prefix + "FinalBlendEndTime", parentRegistry);
        this.position.changeFrame(trajectoryFrame);
        this.velocity.changeFrame(trajectoryFrame);
        this.acceleration.changeFrame(trajectoryFrame);
        this.tempPosition.changeFrame(trajectoryFrame);
        this.tempVelocity.changeFrame(trajectoryFrame);
        this.clear();
    }

    public void clear() {
        this.clearInitialConstraint();
        this.clearFinalConstraint();
    }

    public void clearInitialConstraint() {
        this.initialConstraintPositionError.setToZero();
        this.initialConstraintVelocityError.setToZero();
        this.initialConstraintPolynomial.setZero();
    }

    public void clearFinalConstraint() {
        this.finalConstraintPositionError.setToZero();
        this.finalConstraintVelocityError.setToZero();
        this.finalConstraintPolynomial.setZero();
    }

    public void blendInitialConstraint(FramePoint3DReadOnly initialPosition, double initialTime, double blendDuration) {
        this.clearInitialConstraint();
        this.computeInitialConstraintError(initialPosition, initialTime);
        this.computeInitialConstraintPolynomial(initialTime, blendDuration);
    }

    public void blendInitialConstraint(FramePoint3DReadOnly initialPosition, FrameVector3DReadOnly initialVelocity, double initialTime, double blendDuration) {
        this.clearInitialConstraint();
        this.computeInitialConstraintError(initialPosition, initialVelocity, initialTime);
        this.computeInitialConstraintPolynomial(initialTime, blendDuration);
    }

    public void blendFinalConstraint(FramePoint3DReadOnly finalPosition, FrameVector3DReadOnly finalVelocity, double finalTime, double blendDuration) {
        this.clearFinalConstraint();
        this.computeFinalConstraintError(finalPosition, finalVelocity, finalTime);
        this.computeFinalConstraintPolynomial(finalTime, blendDuration);
    }

    public void blendFinalConstraint(FramePoint3DReadOnly finalPosition, double finalTime, double blendDuration) {
        this.clearFinalConstraint();
        this.computeFinalConstraintError(finalPosition, finalTime);
        this.computeFinalConstraintPolynomial(finalTime, blendDuration);
    }

    public void initializeTrajectory() {
        this.trajectory.initialize();
    }

    public ReferenceFrame getReferenceFrame() {
        return this.trajectoryFrame;
    }

    public FramePoint3DReadOnly getPosition() {
        return this.position;
    }

    public FrameVector3DReadOnly getVelocity() {
        return this.velocity;
    }

    public FrameVector3DReadOnly getAcceleration() {
        return this.acceleration;
    }

    public void showVisualization() {
        this.trajectory.showVisualization();
    }

    public void hideVisualization() {
        this.trajectory.hideVisualization();
    }

    public void initialize() {
        this.trajectory.initialize();
    }

    public void compute(double time) {
        this.trajectory.compute(time);
        this.position.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getPosition());
        this.velocity.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getVelocity());
        this.acceleration.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getAcceleration());
        this.position.changeFrame(this.trajectoryFrame);
        this.velocity.changeFrame(this.trajectoryFrame);
        this.acceleration.changeFrame(this.trajectoryFrame);
        this.computeInitialConstraintOffset(time);
        this.position.add((Tuple3DReadOnly)this.initialConstraintPolynomial.getPosition());
        this.velocity.add((Tuple3DReadOnly)this.initialConstraintPolynomial.getVelocity());
        this.acceleration.add((Tuple3DReadOnly)this.initialConstraintPolynomial.getAcceleration());
        this.computeFinalConstraintOffset(time);
        this.position.add((Tuple3DReadOnly)this.finalConstraintPolynomial.getPosition());
        this.velocity.add((Tuple3DReadOnly)this.finalConstraintPolynomial.getVelocity());
        this.acceleration.add((Tuple3DReadOnly)this.finalConstraintPolynomial.getAcceleration());
    }

    public boolean isDone() {
        return this.trajectory.isDone();
    }

    private void computeInitialConstraintError(FramePoint3DReadOnly initialPosition, double initialTime) {
        this.computeConstraintPositionError(initialPosition, initialTime, (Vector3DBasics)this.initialConstraintPositionError);
    }

    private void computeInitialConstraintError(FramePoint3DReadOnly initialPosition, FrameVector3DReadOnly initialVelocity, double initialTime) {
        this.computeInitialConstraintError(initialPosition, initialTime);
        this.computeConstraintVelocityError(initialVelocity, (Vector3DBasics)this.initialConstraintVelocityError);
    }

    private void computeFinalConstraintError(FramePoint3DReadOnly finalPosition, double finalTime) {
        this.computeConstraintPositionError(finalPosition, finalTime, (Vector3DBasics)this.finalConstraintPositionError);
    }

    private void computeFinalConstraintError(FramePoint3DReadOnly finalPosition, FrameVector3DReadOnly finalVelocity, double finalTime) {
        this.computeFinalConstraintError(finalPosition, finalTime);
        this.computeConstraintVelocityError(finalVelocity, (Vector3DBasics)this.finalConstraintVelocityError);
    }

    private void computeConstraintPositionError(FramePoint3DReadOnly desiredPosition, double time, Vector3DBasics positionErrorToPack) {
        this.trajectory.compute(time);
        this.trajectoryFrame.checkReferenceFrameMatch(desiredPosition.getReferenceFrame());
        this.tempPosition.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getPosition());
        this.tempPosition.changeFrame(this.trajectoryFrame);
        positionErrorToPack.sub((Tuple3DReadOnly)desiredPosition, (Tuple3DReadOnly)this.tempPosition);
    }

    private void computeConstraintVelocityError(FrameVector3DReadOnly desiredVelocity, Vector3DBasics velocityErrorToPack) {
        this.trajectoryFrame.checkReferenceFrameMatch(desiredVelocity.getReferenceFrame());
        this.tempVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getVelocity());
        this.tempVelocity.changeFrame(this.trajectoryFrame);
        velocityErrorToPack.sub((Tuple3DReadOnly)desiredVelocity, (Tuple3DReadOnly)this.tempVelocity);
    }

    private void computeInitialConstraintPolynomial(double initialTime, double blendDuration) {
        this.initialBlendTimeOffset.set(initialTime);
        this.initialBlendStartTime.set(0.0);
        this.initialBlendEndTime.set(blendDuration);
        this.initialConstraintPolynomial.setQuinticWithZeroTerminalAcceleration(this.initialBlendStartTime.getDoubleValue(), this.initialBlendEndTime.getDoubleValue(), (Tuple3DReadOnly)this.initialConstraintPositionError, (Tuple3DReadOnly)this.initialConstraintVelocityError, (Tuple3DReadOnly)zeroVector, (Tuple3DReadOnly)zeroVector);
    }

    private void computeFinalConstraintPolynomial(double finalTime, double blendDuration) {
        this.finalBlendTimeOffset.set(finalTime);
        this.finalBlendStartTime.set(-blendDuration);
        this.finalBlendEndTime.set(0.0);
        this.finalConstraintPolynomial.setQuinticWithZeroTerminalAcceleration(this.finalBlendStartTime.getDoubleValue(), this.finalBlendEndTime.getDoubleValue(), (Tuple3DReadOnly)zeroVector, (Tuple3DReadOnly)zeroVector, (Tuple3DReadOnly)this.finalConstraintPositionError, (Tuple3DReadOnly)this.finalConstraintVelocityError);
    }

    private void computeInitialConstraintOffset(double time) {
        double startTime = this.initialBlendStartTime.getDoubleValue();
        double endTime = this.initialBlendEndTime.getDoubleValue();
        time = MathTools.clamp((double)(time - this.initialBlendTimeOffset.getValue()), (double)startTime, (double)endTime);
        this.initialConstraintPolynomial.compute(time);
    }

    private void computeFinalConstraintOffset(double time) {
        double startTime = this.finalBlendStartTime.getDoubleValue();
        double endTime = this.finalBlendEndTime.getDoubleValue();
        time = MathTools.clamp((double)(time - this.finalBlendTimeOffset.getValue()), (double)startTime, (double)endTime);
        this.finalConstraintPolynomial.compute(time);
    }
}

