/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.robotics.math.trajectories.BlendedOrientationTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.BlendedWaypointPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePoseTrajectoryGenerator;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BlendedPoseTrajectoryGenerator
implements FixedFramePoseTrajectoryGenerator {
    private final BlendedWaypointPositionTrajectoryGenerator blendedPositionTrajectory;
    private final BlendedOrientationTrajectoryGenerator blendedOrientationTrajectory;
    private final FixedFramePoseTrajectoryGenerator trajectory;
    private final FrameVector3D tempVelocity = new FrameVector3D();
    private final FrameVector3D tempAngularVelocity = new FrameVector3D();
    private final FramePose3DReadOnly dummyPose = new FramePose3DReadOnly(){

        public FramePoint3DReadOnly getPosition() {
            return BlendedPoseTrajectoryGenerator.this.blendedPositionTrajectory.getPosition();
        }

        public FrameQuaternionReadOnly getOrientation() {
            return BlendedPoseTrajectoryGenerator.this.blendedOrientationTrajectory.getOrientation();
        }

        public ReferenceFrame getReferenceFrame() {
            return BlendedPoseTrajectoryGenerator.this.blendedPositionTrajectory.getReferenceFrame();
        }
    };

    public BlendedPoseTrajectoryGenerator(String prefix, FixedFramePoseTrajectoryGenerator trajectory, ReferenceFrame trajectoryFrame, YoRegistry parentRegistry) {
        this.trajectory = trajectory;
        this.blendedPositionTrajectory = new BlendedWaypointPositionTrajectoryGenerator(prefix + "Position", trajectory, trajectoryFrame, parentRegistry);
        this.blendedOrientationTrajectory = new BlendedOrientationTrajectoryGenerator(prefix + "Orientation", trajectory, trajectoryFrame, parentRegistry);
    }

    public BlendedOrientationTrajectoryGenerator getOrientationTrajectoryGenerator() {
        return this.blendedOrientationTrajectory;
    }

    public BlendedWaypointPositionTrajectoryGenerator getPositionTrajectoryGenerator() {
        return this.blendedPositionTrajectory;
    }

    public void clear() {
        this.blendedPositionTrajectory.clear();
        this.blendedOrientationTrajectory.clear();
    }

    public void clearInitialConstraint() {
        this.blendedPositionTrajectory.clearInitialConstraint();
        this.blendedOrientationTrajectory.clearInitialConstraint();
    }

    public void clearFinalConstraint() {
        this.blendedPositionTrajectory.clearFinalConstraint();
        this.blendedOrientationTrajectory.clearFinalConstraint();
    }

    public void blendInitialConstraint(FramePose3DReadOnly initialPose, double initialTime, double blendDuration) {
        this.blendedPositionTrajectory.blendInitialConstraint(initialPose.getPosition(), initialTime, blendDuration);
        this.blendedOrientationTrajectory.blendInitialConstraint(initialPose.getOrientation(), initialTime, blendDuration);
    }

    public void blendInitialConstraint(FramePose3DReadOnly initialPose, TwistReadOnly initialTwist, double initialTime, double blendDuration) {
        this.tempVelocity.setIncludingFrame((FrameTuple3DReadOnly)initialTwist.getLinearPart());
        this.tempAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)initialTwist.getAngularPart());
        this.blendedPositionTrajectory.blendInitialConstraint(initialPose.getPosition(), (FrameVector3DReadOnly)this.tempVelocity, initialTime, blendDuration);
        this.blendedOrientationTrajectory.blendInitialConstraint(initialPose.getOrientation(), (FrameVector3DReadOnly)this.tempAngularVelocity, initialTime, blendDuration);
    }

    public void blendFinalConstraint(FramePose3DReadOnly finalPose, double finalTime, double blendDuration) {
        this.blendedPositionTrajectory.blendFinalConstraint(finalPose.getPosition(), finalTime, blendDuration);
        this.blendedOrientationTrajectory.blendFinalConstraint(finalPose.getOrientation(), finalTime, blendDuration);
    }

    public void blendFinalConstraint(FramePose3DReadOnly finalPose, TwistReadOnly finalTwist, double finalTime, double blendDuration) {
        this.tempVelocity.setIncludingFrame((FrameTuple3DReadOnly)finalTwist.getLinearPart());
        this.tempAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)finalTwist.getAngularPart());
        this.blendedPositionTrajectory.blendFinalConstraint(finalPose.getPosition(), (FrameVector3DReadOnly)this.tempVelocity, finalTime, blendDuration);
        this.blendedOrientationTrajectory.blendFinalConstraint(finalPose.getOrientation(), (FrameVector3DReadOnly)this.tempAngularVelocity, finalTime, blendDuration);
    }

    public void initializeTrajectory() {
        this.trajectory.initialize();
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.blendedPositionTrajectory.getReferenceFrame();
    }

    @Override
    public FramePose3DReadOnly getPose() {
        return this.dummyPose;
    }

    @Override
    public FramePoint3DReadOnly getPosition() {
        return this.blendedPositionTrajectory.getPosition();
    }

    public FrameVector3DReadOnly getVelocity() {
        return this.blendedPositionTrajectory.getVelocity();
    }

    public FrameVector3DReadOnly getAcceleration() {
        return this.blendedPositionTrajectory.getAcceleration();
    }

    public FrameQuaternionReadOnly getOrientation() {
        return this.blendedOrientationTrajectory.getOrientation();
    }

    @Override
    public FrameVector3DReadOnly getAngularVelocity() {
        return this.blendedOrientationTrajectory.getAngularVelocity();
    }

    @Override
    public FrameVector3DReadOnly getAngularAcceleration() {
        return this.blendedOrientationTrajectory.getAngularAcceleration();
    }

    public void showVisualization() {
        this.blendedPositionTrajectory.showVisualization();
    }

    public void hideVisualization() {
        this.blendedPositionTrajectory.hideVisualization();
    }

    public void initialize() {
        this.blendedPositionTrajectory.initialize();
        this.blendedOrientationTrajectory.initialize();
    }

    public void compute(double time) {
        this.blendedPositionTrajectory.compute(time);
        this.blendedOrientationTrajectory.compute(time);
    }

    public boolean isDone() {
        return this.blendedPositionTrajectory.isDone() && this.blendedOrientationTrajectory.isDone();
    }
}

