/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.interpolators;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.commons.MathTools;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.trajectories.interfaces.TrajectoryGenerator;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class QuinticSplineInterpolator
implements TrajectoryGenerator {
    private final int maximumNumberOfPoints;
    private final int numberOfSplines;
    private final YoRegistry registry;
    private final YoBoolean initialized;
    private final YoDouble currentTime;
    private DMatrixRMaj h;
    private DMatrixRMaj D;
    private DMatrixRMaj C;
    private DMatrixRMaj Cblock;
    private DMatrixRMaj A;
    private final LinearSolverDense<DMatrixRMaj> solver;
    private DMatrixRMaj sol;
    private DMatrixRMaj s;
    private DMatrixRMaj yd;
    private DMatrixRMaj a;
    private DMatrixRMaj b;
    private DMatrixRMaj c;
    private DMatrixRMaj d;
    private DMatrixRMaj e;
    private DMatrixRMaj f;
    private final double[] x;
    private final YoInteger numberOfPoints;
    private final QuinticSpline[] splines;
    private final YoDouble[] position;
    private final YoDouble[] velocity;
    private final YoDouble[] acceleration;
    private final YoDouble[] jerk;

    public QuinticSplineInterpolator(String name, int maximumNumberOfPoints, int numberOfSplines, YoRegistry parentRegistry) {
        this.maximumNumberOfPoints = maximumNumberOfPoints;
        this.numberOfSplines = numberOfSplines;
        this.registry = new YoRegistry(name);
        this.initialized = new YoBoolean(name + "_initialized", this.registry);
        this.initialized.set(false);
        this.numberOfPoints = new YoInteger(name + "_numberOfPoints", this.registry);
        this.currentTime = new YoDouble(name + "_currentTime", this.registry);
        this.h = new DMatrixRMaj(maximumNumberOfPoints - 1, 1);
        this.D = new DMatrixRMaj(maximumNumberOfPoints - 1, maximumNumberOfPoints + 2);
        this.C = new DMatrixRMaj(maximumNumberOfPoints, maximumNumberOfPoints + 2);
        this.Cblock = new DMatrixRMaj(maximumNumberOfPoints - 1, maximumNumberOfPoints + 2);
        this.A = new DMatrixRMaj(maximumNumberOfPoints + 2, maximumNumberOfPoints + 2);
        this.solver = LinearSolverFactory_DDRM.linear((int)(maximumNumberOfPoints + 2));
        this.s = new DMatrixRMaj(maximumNumberOfPoints + 2, 1);
        this.sol = new DMatrixRMaj(maximumNumberOfPoints + 2, 1);
        this.yd = new DMatrixRMaj(maximumNumberOfPoints - 1, 1);
        this.a = new DMatrixRMaj(maximumNumberOfPoints - 1, 1);
        this.b = new DMatrixRMaj(maximumNumberOfPoints - 1, 1);
        this.c = new DMatrixRMaj(maximumNumberOfPoints - 1, 1);
        this.d = new DMatrixRMaj(maximumNumberOfPoints - 1, 1);
        this.e = new DMatrixRMaj(maximumNumberOfPoints - 1, 1);
        this.f = new DMatrixRMaj(maximumNumberOfPoints - 1, 1);
        this.x = new double[maximumNumberOfPoints];
        this.position = new YoDouble[numberOfSplines];
        this.velocity = new YoDouble[numberOfSplines];
        this.acceleration = new YoDouble[numberOfSplines];
        this.jerk = new YoDouble[numberOfSplines];
        this.splines = new QuinticSpline[numberOfSplines];
        for (int i = 0; i < numberOfSplines; ++i) {
            String eName = name + "-" + i;
            this.splines[i] = new QuinticSpline(eName, maximumNumberOfPoints, this.registry);
            this.position[i] = new YoDouble(eName + "_position", this.registry);
            this.velocity[i] = new YoDouble(eName + "_velocity", this.registry);
            this.acceleration[i] = new YoDouble(eName + "_acceleration", this.registry);
            this.jerk[i] = new YoDouble(eName + "_jerk", this.registry);
        }
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
    }

    public int getMaximumNumberOfWaypoints() {
        return this.maximumNumberOfPoints;
    }

    public void initialize(int numberOfPointsIn, double[] timeIn) {
        int i;
        if (timeIn.length > this.maximumNumberOfPoints) {
            throw new RuntimeException("xIn exceeds the maximum number of points");
        }
        this.numberOfPoints.set(numberOfPointsIn);
        for (i = 0; i < this.numberOfPoints.getValue(); ++i) {
            this.x[i] = timeIn[i];
        }
        this.h.reshape(this.numberOfPoints.getValue() - 1, 1);
        this.D.reshape(this.numberOfPoints.getValue() - 1, this.numberOfPoints.getValue() + 2);
        this.C.reshape(this.numberOfPoints.getValue(), this.numberOfPoints.getValue() + 2);
        this.Cblock.reshape(this.numberOfPoints.getValue() - 1, this.numberOfPoints.getValue() + 2);
        this.A.reshape(this.numberOfPoints.getValue() + 2, this.numberOfPoints.getValue() + 2);
        this.s.reshape(this.numberOfPoints.getValue() + 2, 1);
        this.sol.reshape(this.numberOfPoints.getValue() + 2, 1);
        this.yd.reshape(this.numberOfPoints.getValue() - 1, 1);
        this.a.reshape(this.numberOfPoints.getValue() - 1, 1);
        this.b.reshape(this.numberOfPoints.getValue() - 1, 1);
        this.c.reshape(this.numberOfPoints.getValue() - 1, 1);
        this.d.reshape(this.numberOfPoints.getValue() - 1, 1);
        this.e.reshape(this.numberOfPoints.getValue() - 1, 1);
        this.f.reshape(this.numberOfPoints.getValue() - 1, 1);
        MatrixTools.diff((double[])timeIn, (DMatrix1Row)this.h);
        MatrixTools.setToZero((DMatrix1Row)this.D);
        this.D.unsafe_set(0, 1, 1.0);
        for (i = 1; i < this.numberOfPoints.getValue() - 1; ++i) {
            this.D.unsafe_set(i, i + 1, 2.0 * this.h.unsafe_get(i - 1, 0));
            this.D.unsafe_set(i, i + 2, 2.0 * this.h.unsafe_get(i - 1, 0));
            MatrixTools.addMatrixBlock((DMatrix)this.D, (int)i, (int)0, (DMatrix1Row)this.D, (int)(i - 1), (int)0, (int)1, (int)(this.numberOfPoints.getValue() + 2), (double)1.0);
        }
        MatrixTools.setToZero((DMatrix1Row)this.C);
        this.C.unsafe_set(0, 0, 1.0);
        for (i = 1; i < this.numberOfPoints.getValue(); ++i) {
            this.C.unsafe_set(i, i + 1, 4.0 * MathTools.square((double)this.h.unsafe_get(i - 1, 0)));
            this.C.unsafe_set(i, i + 2, 2.0 * MathTools.square((double)this.h.unsafe_get(i - 1, 0)));
            MatrixTools.addMatrixBlock((DMatrix)this.C, (int)i, (int)0, (DMatrix1Row)this.C, (int)(i - 1), (int)0, (int)1, (int)(this.numberOfPoints.getValue() + 2), (double)1.0);
            MatrixTools.addMatrixBlock((DMatrix)this.C, (int)i, (int)0, (DMatrix1Row)this.D, (int)(i - 1), (int)0, (int)1, (int)(this.numberOfPoints.getValue() + 2), (double)(3.0 * this.h.unsafe_get(i - 1, 0)));
        }
        MatrixTools.setMatrixBlock((DMatrix)this.Cblock, (int)0, (int)0, (DMatrix)this.C, (int)0, (int)0, (int)(this.numberOfPoints.getValue() - 1), (int)(this.numberOfPoints.getValue() + 2), (double)1.0);
        MatrixTools.setToZero((DMatrix1Row)this.A);
        for (i = 0; i < this.numberOfPoints.getValue() - 2; ++i) {
            this.A.unsafe_set(i + 4, i + 2, 2.2 * MathTools.cube((double)this.h.unsafe_get(i, 0)));
            this.A.unsafe_set(i + 4, i + 3, 0.8 * MathTools.cube((double)this.h.unsafe_get(i, 0)) + 0.8 * MathTools.cube((double)this.h.unsafe_get(i + 1, 0)));
            this.A.unsafe_set(i + 4, i + 4, 0.2 * MathTools.cube((double)this.h.unsafe_get(i + 1, 0)));
            MatrixTools.addMatrixBlock((DMatrix)this.A, (int)(i + 4), (int)0, (DMatrix1Row)this.C, (int)i, (int)0, (int)1, (int)(this.numberOfPoints.getValue() + 2), (double)this.h.unsafe_get(i, 0));
            MatrixTools.addMatrixBlock((DMatrix)this.A, (int)(i + 4), (int)0, (DMatrix1Row)this.C, (int)(i + 1), (int)0, (int)1, (int)(this.numberOfPoints.getValue() + 2), (double)this.h.unsafe_get(i + 1, 0));
            MatrixTools.addMatrixBlock((DMatrix)this.A, (int)(i + 4), (int)0, (DMatrix1Row)this.D, (int)i, (int)0, (int)1, (int)(this.numberOfPoints.getValue() + 2), (double)(2.0 * MathTools.square((double)this.h.unsafe_get(i, 0))));
            MatrixTools.addMatrixBlock((DMatrix)this.A, (int)(i + 4), (int)0, (DMatrix1Row)this.D, (int)(i + 1), (int)0, (int)1, (int)(this.numberOfPoints.getValue() + 2), (double)MathTools.square((double)this.h.unsafe_get(i + 1, 0)));
        }
        this.A.unsafe_set(0, 0, this.h.unsafe_get(0, 0));
        this.A.unsafe_set(0, 1, MathTools.square((double)this.h.unsafe_get(0, 0)));
        this.A.unsafe_set(0, 2, 0.8 * MathTools.cube((double)this.h.unsafe_get(0, 0)));
        this.A.unsafe_set(0, 3, 0.2 * MathTools.cube((double)this.h.unsafe_get(0, 0)));
        this.A.unsafe_set(1, 0, 2.0);
        this.A.unsafe_set(2, this.numberOfPoints.getValue(), 2.2 * MathTools.cube((double)this.h.unsafe_get(this.numberOfPoints.getValue() - 2, 0)));
        this.A.unsafe_set(2, this.numberOfPoints.getValue() + 1, 0.8 * MathTools.cube((double)this.h.unsafe_get(this.numberOfPoints.getValue() - 2, 0)));
        MatrixTools.addMatrixBlock((DMatrix)this.A, (int)2, (int)0, (DMatrix1Row)this.C, (int)(this.numberOfPoints.getValue() - 2), (int)0, (int)1, (int)(this.numberOfPoints.getValue() + 2), (double)this.h.unsafe_get(this.numberOfPoints.getValue() - 2, 0));
        MatrixTools.addMatrixBlock((DMatrix)this.A, (int)2, (int)0, (DMatrix1Row)this.D, (int)(this.numberOfPoints.getValue() - 2), (int)0, (int)1, (int)(this.numberOfPoints.getValue() + 2), (double)(2.0 * MathTools.square((double)this.h.unsafe_get(this.numberOfPoints.getValue() - 2, 0))));
        MatrixTools.addMatrixBlock((DMatrix)this.A, (int)3, (int)0, (DMatrix1Row)this.C, (int)(this.numberOfPoints.getValue() - 1), (int)0, (int)1, (int)(this.numberOfPoints.getValue() + 2), (double)2.0);
        if (!this.solver.setA((Matrix)this.A)) {
            throw new IllegalArgumentException("Singular matrix");
        }
        this.initialized.set(true);
        for (i = 0; i < this.numberOfSplines; ++i) {
            this.splines[i].setCoefficientsSet(false);
        }
    }

    public void determineCoefficients(int splineIndex, double[] positionIn, double v0, double vf, double a0, double af) {
        int i;
        if (!this.initialized.getBooleanValue()) {
            throw new RuntimeException("QuinticSplineInterpolator is not initialized");
        }
        if (splineIndex > this.numberOfSplines - 1 || splineIndex < 0) {
            throw new RuntimeException("SplineIndex is out of bounds");
        }
        if (positionIn.length < this.numberOfPoints.getValue()) {
            throw new RuntimeException("Length of positionIn is less than the number of points");
        }
        MatrixTools.setMatrixColumnFromArray((DMatrix1Row)this.a, (int)0, (double[])positionIn, (int)0, (int)this.a.getNumRows());
        MatrixTools.diff((double[])positionIn, (DMatrix1Row)this.yd);
        if (this.numberOfPoints.getValue() > 2) {
            this.s.unsafe_set(0, 0, positionIn[1] / this.h.unsafe_get(0, 0) - positionIn[0] / this.h.unsafe_get(0, 0) - v0);
            for (i = 0; i < this.numberOfPoints.getValue() - 2; ++i) {
                this.s.unsafe_set(i + 4, 0, this.yd.unsafe_get(i + 1, 0) / this.h.unsafe_get(i + 1, 0) - this.yd.unsafe_get(i, 0) / this.h.unsafe_get(i, 0));
            }
        } else {
            this.s.unsafe_set(0, 0, positionIn[1] / this.h.unsafe_get(0, 0) - positionIn[0] / this.h.unsafe_get(0, 0) - v0);
        }
        this.s.unsafe_set(1, 0, a0);
        this.s.unsafe_set(2, 0, vf - positionIn[this.numberOfPoints.getValue() - 1] / this.h.unsafe_get(this.numberOfPoints.getValue() - 2, 0) + positionIn[this.numberOfPoints.getValue() - 2] / this.h.unsafe_get(this.numberOfPoints.getValue() - 2, 0));
        this.s.unsafe_set(3, 0, af);
        this.solver.solve((Matrix)this.s, (Matrix)this.sol);
        CommonOps_DDRM.mult((DMatrix1Row)this.Cblock, (DMatrix1Row)this.sol, (DMatrix1Row)this.c);
        CommonOps_DDRM.mult((DMatrix1Row)this.D, (DMatrix1Row)this.sol, (DMatrix1Row)this.d);
        MatrixTools.setMatrixBlock((DMatrix)this.e, (int)0, (int)0, (DMatrix)this.sol, (int)2, (int)0, (int)(this.numberOfPoints.getValue() - 1), (int)1, (double)1.0);
        MatrixTools.diff((DMatrix1Row)this.sol, (int)2, (int)this.numberOfPoints.getValue(), (DMatrix1Row)this.f);
        CommonOps_DDRM.scale((double)0.2, (DMatrixD1)this.f);
        CommonOps_DDRM.elementDiv((DMatrixD1)this.f, (DMatrixD1)this.h);
        for (i = 0; i < this.numberOfPoints.getValue() - 1; ++i) {
            double hi = this.h.unsafe_get(i, 0);
            double hi2 = MathTools.square((double)hi);
            double hi3 = hi2 * hi;
            double hi4 = hi3 * hi;
            this.b.unsafe_set(i, 0, this.yd.unsafe_get(i, 0) / hi - this.c.unsafe_get(i, 0) * hi - this.d.unsafe_get(i, 0) * hi2 - this.e.unsafe_get(i, 0) * hi3 - this.f.unsafe_get(i, 0) * hi4);
        }
        this.splines[splineIndex].seta(this.a);
        this.splines[splineIndex].setb(this.b);
        this.splines[splineIndex].setc(this.c);
        this.splines[splineIndex].setd(this.d);
        this.splines[splineIndex].sete(this.e);
        this.splines[splineIndex].setf(this.f);
        this.splines[splineIndex].setCoefficientsSet(true);
    }

    public void compute(double timeIn) {
        this.currentTime.set(timeIn);
        double time = timeIn;
        if (time > this.x[this.numberOfPoints.getValue() - 1]) {
            time = this.x[this.numberOfPoints.getValue() - 1];
        }
        if (time < this.x[0]) {
            time = this.x[0];
        }
        int index = this.determineSplineIndex(time);
        double h = time - this.x[index];
        double h2 = MathTools.square((double)h);
        double h3 = h2 * h;
        double h4 = h3 * h;
        double h5 = h4 * h;
        for (int i = 0; i < this.numberOfSplines; ++i) {
            this.splines[i].value(index, h, h2, h3, h4, h5, this.position[i], this.velocity[i], this.acceleration[i], this.jerk[i], null, null);
        }
    }

    public double getPosition(int spline) {
        return this.position[spline].getValue();
    }

    public double getVelocity(int spline) {
        return this.velocity[spline].getValue();
    }

    public double getAcceleration(int spline) {
        return this.acceleration[spline].getValue();
    }

    public double getJerk(int spline) {
        return this.jerk[spline].getValue();
    }

    private int determineSplineIndex(double xx) {
        for (int i = 0; i < this.numberOfPoints.getValue() - 2; ++i) {
            if (!(xx >= this.x[i]) || !(xx <= this.x[i + 1])) continue;
            return i;
        }
        return this.numberOfPoints.getValue() - 2;
    }

    public boolean isDone() {
        return this.currentTime.getValue() > this.x[this.numberOfPoints.getValue() - 1];
    }

    public void initialize() {
        throw new RuntimeException("Use initialize(double[] xIn) and determineCoefficients() to initialize the quintic spline interpolator");
    }

    private class QuinticSpline {
        private final int segments;
        private final YoRegistry registry;
        private final double[] a;
        private final double[] b;
        private final double[] c;
        private final double[] d;
        private final double[] e;
        private final double[] f;
        private final YoBoolean coefficientsSet;

        public QuinticSpline(String name, int pointsToInterpolate, YoRegistry parentRegistry) {
            this.segments = pointsToInterpolate - 1;
            this.registry = new YoRegistry(name);
            parentRegistry.addChild(this.registry);
            this.a = new double[this.segments];
            this.b = new double[this.segments];
            this.c = new double[this.segments];
            this.d = new double[this.segments];
            this.e = new double[this.segments];
            this.f = new double[this.segments];
            this.coefficientsSet = new YoBoolean(name + "_initialized", this.registry);
            this.coefficientsSet.set(false);
        }

        private void set(double[] var, DMatrixRMaj value) {
            for (int i = 0; i < this.segments; ++i) {
                var[i] = value.unsafe_get(i, 0);
            }
        }

        protected void seta(DMatrixRMaj value) {
            this.set(this.a, value);
        }

        protected void setb(DMatrixRMaj value) {
            this.set(this.b, value);
        }

        protected void setc(DMatrixRMaj value) {
            this.set(this.c, value);
        }

        protected void setd(DMatrixRMaj value) {
            this.set(this.d, value);
        }

        protected void sete(DMatrixRMaj value) {
            this.set(this.e, value);
        }

        protected void setf(DMatrixRMaj value) {
            this.set(this.f, value);
        }

        protected void setCoefficientsSet(boolean coefficientsSet) {
            this.coefficientsSet.set(coefficientsSet);
        }

        protected void value(int index, double h, double h2, double h3, double h4, double h5, YoDouble pos, YoDouble vel, YoDouble acc, YoDouble jerk, YoDouble snap, YoDouble crackle) {
            if (!this.coefficientsSet.getBooleanValue()) {
                throw new RuntimeException("Spline coefficients not set");
            }
            pos.set(this.a[index] + this.b[index] * h + this.c[index] * h2 + this.d[index] * h3 + this.e[index] * h4 + this.f[index] * h5);
            if (crackle != null) {
                crackle.set(120.0 * this.f[index]);
            }
            if (snap != null) {
                snap.set(24.0 * this.e[index] + 120.0 * this.f[index] * h);
            }
            jerk.set(6.0 * this.d[index] + 24.0 * this.e[index] * h + 60.0 * this.f[index] * h2);
            acc.set(2.0 * this.c[index] + 6.0 * this.d[index] * h + 12.0 * this.e[index] * h2 + 20.0 * this.f[index] * h3);
            vel.set(this.b[index] + 2.0 * this.c[index] * h + 3.0 * this.d[index] * h2 + 4.0 * this.e[index] * h3 + 5.0 * this.f[index] * h4);
        }
    }
}

