/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.functionGenerator;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.math.functionGenerator.YoFunctionGeneratorMode;
import us.ihmc.robotics.math.functionGenerator.YoFunctionGeneratorNew;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;

public class FunctionGeneratorErrorCalculator {
    private static final int MAX_SAMPLES = 1000;
    private final double controlDT;
    private final YoLong controllerCounter;
    private final YoRegistry registry;
    private final List<TrajectorySignal> trajectorySignals = new ArrayList<TrajectorySignal>();

    public FunctionGeneratorErrorCalculator(String namePrefix, double controlDT, YoRegistry registry) {
        this.registry = registry;
        this.controlDT = controlDT;
        this.controllerCounter = new YoLong(namePrefix + "controllerCounter", registry);
    }

    public void addTrajectorySignal(YoFunctionGeneratorNew functionGenerator, DoubleProvider baselineDesiredValue, OneDoFJointBasics joint) {
        this.trajectorySignals.add(new TrajectorySignal(functionGenerator, joint, baselineDesiredValue, this.registry));
    }

    public void update() {
        this.controllerCounter.increment();
        for (int i = 0; i < this.trajectorySignals.size(); ++i) {
            this.trajectorySignals.get(i).update();
        }
    }

    private class TrajectorySignal {
        private final YoFunctionGeneratorNew functionGenerator;
        private final OneDoFJointBasics joint;
        private final YoDouble previousFrequency;
        private final YoInteger counter;
        private final DoubleProvider baselineDesiredValue;
        private long startCount;
        private int controlTicksPerSample;
        private int samplesPerPeriod;
        private int controlTicksPerPeriod;
        private final YoDouble rmsPositionError;
        private final YoDouble rmsVelocityError;
        private final TDoubleArrayList positionErrorsSq = new TDoubleArrayList(new double[1000]);
        private final TDoubleArrayList velocityErrorsSq = new TDoubleArrayList(new double[1000]);

        TrajectorySignal(YoFunctionGeneratorNew functionGenerator, OneDoFJointBasics joint, DoubleProvider baselineDesiredValue, YoRegistry registry) {
            this.functionGenerator = functionGenerator;
            this.joint = joint;
            this.previousFrequency = new YoDouble("prevFreq" + joint.getName(), registry);
            this.baselineDesiredValue = baselineDesiredValue;
            this.rmsPositionError = new YoDouble("q_err_rms_" + joint.getName(), registry);
            this.rmsVelocityError = new YoDouble("qd_err_rms_" + joint.getName(), registry);
            this.counter = new YoInteger("counter" + joint.getName(), registry);
            this.previousFrequency.setToNaN();
        }

        void update() {
            if (this.functionGenerator.getMode() == YoFunctionGeneratorMode.OFF || this.functionGenerator.getFrequency() < 0.001) {
                this.rmsPositionError.set(0.0);
                this.rmsVelocityError.set(0.0);
                return;
            }
            if (!EuclidCoreTools.epsilonEquals((double)this.functionGenerator.getFrequency(), (double)this.previousFrequency.getValue(), (double)1.0E-5)) {
                this.previousFrequency.set(this.functionGenerator.getFrequency());
                double periodDuration = 1.0 / this.functionGenerator.getFrequency();
                this.controlTicksPerPeriod = (int)(periodDuration / FunctionGeneratorErrorCalculator.this.controlDT);
                this.controlTicksPerSample = (int)Math.ceil((double)this.controlTicksPerPeriod / 1000.0);
                this.samplesPerPeriod = this.controlTicksPerPeriod / this.controlTicksPerSample;
                this.positionErrorsSq.fill(0.0);
                this.velocityErrorsSq.fill(0.0);
                this.startCount = FunctionGeneratorErrorCalculator.this.controllerCounter.getValue();
                this.counter.set(0);
            }
            if (this.controlTicksPerSample <= 0) {
                return;
            }
            if (this.counter.getValue() % this.controlTicksPerSample == 0) {
                this.positionErrorsSq.set(this.counter.getValue() / this.controlTicksPerSample, EuclidCoreTools.square((double)(this.baselineDesiredValue.getValue() - this.joint.getQ())));
                this.velocityErrorsSq.set(this.counter.getValue() / this.controlTicksPerSample, EuclidCoreTools.square((double)(this.functionGenerator.getValueDot() - this.joint.getQd())));
                this.rmsPositionError.set(Math.sqrt(this.positionErrorsSq.sum() / (double)this.samplesPerPeriod));
                this.rmsVelocityError.set(Math.sqrt(this.velocityErrorsSq.sum() / (double)this.samplesPerPeriod));
            }
            this.counter.set((1 + this.counter.getValue()) % this.controlTicksPerPeriod);
        }
    }
}

