/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.functionGenerator;

import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.yoVariables.providers.DoubleProvider;

public abstract class BaseFunctionGenerator {
    public static final DoubleProvider zeroDoubleProvider = () -> 0.0;
    public static final double twoPi = Math.PI * 2;
    private DoubleProvider offset = zeroDoubleProvider;
    private DoubleProvider amplitude = zeroDoubleProvider;
    private DoubleProvider frequency = zeroDoubleProvider;
    private DoubleProvider phase = zeroDoubleProvider;
    private double angle = 0.0;
    private boolean outputDirty = true;
    private double value = 0.0;
    private double valueDot = 0.0;
    private double valueDDot = 0.0;

    public void resetAngle() {
        this.angle = 0.0;
    }

    public void integrateAngle(double dt) {
        this.setAngle(this.getAngle() + this.getAngleDot() * dt);
        this.markDirty();
    }

    void markDirty() {
        this.outputDirty = true;
    }

    private void updateOutput() {
        if (!this.outputDirty) {
            return;
        }
        this.outputDirty = false;
        this.value = this.computeValue();
        this.valueDot = this.computeValueDot();
        this.valueDDot = this.computeValueDDot();
    }

    protected abstract double computeValue();

    protected abstract double computeValueDot();

    protected abstract double computeValueDDot();

    public void setAngle(double angle) {
        if ((angle = AngleTools.shiftAngleToStartOfRange(angle, 0.0)) == this.angle) {
            return;
        }
        this.angle = angle;
        this.markDirty();
    }

    public void setOffset(double offset) {
        this.setOffset(() -> offset);
    }

    public void setOffset(DoubleProvider offset) {
        this.offset = offset;
        this.markDirty();
    }

    public void setAmplitude(double amplitude) {
        this.setAmplitude(() -> amplitude);
    }

    public void setAmplitude(DoubleProvider amplitude) {
        this.amplitude = amplitude;
        this.markDirty();
    }

    public void setFrequency(double frequency) {
        this.setFrequency(() -> frequency);
    }

    public void setFrequency(DoubleProvider frequency) {
        this.frequency = frequency;
        this.markDirty();
    }

    public void setPhase(double phase) {
        this.setPhase(() -> phase);
    }

    public void setPhase(DoubleProvider phase) {
        this.phase = phase;
        this.markDirty();
    }

    public double getOffset() {
        return this.offset.getValue();
    }

    public double getAmplitude() {
        return this.amplitude.getValue();
    }

    public double getFrequency() {
        return this.frequency.getValue();
    }

    public double getPhase() {
        return this.phase.getValue();
    }

    public double getAngle() {
        return this.angle;
    }

    public double getAngleDot() {
        return Math.PI * 2 * this.frequency.getValue();
    }

    public double getValue() {
        this.updateOutput();
        return this.value;
    }

    public double getValueDot() {
        this.updateOutput();
        return this.valueDot;
    }

    public double getValueDDot() {
        this.updateOutput();
        return this.valueDDot;
    }
}

