/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.filters.ProcessingYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoIMUMahonyFilter
implements ProcessingYoVariable {
    private static final double MIN_MAGNITUDE = 1.0E-5;
    private static final double GRAVITY_DEFAULT_VALUE = 9.81;
    public static final Vector3DReadOnly ACCELERATION_REFERENCE = Axis3D.Z;
    public static final Vector3DReadOnly NORTH_REFERENCE = Axis3D.X;
    private YoFrameVector3D rawAngularVelocity;
    private YoFrameVector3D rawLinearAcceleration;
    private YoFrameVector3D rawMagneticVector;
    private final YoFrameQuaternion estimatedOrientation;
    private final YoFrameVector3D estimatedAngularVelocity;
    private final YoFrameVector3D orientationError;
    private final YoFrameVector3D angularVelocityBias;
    private final YoDouble proportionalGain;
    private final YoDouble integralGain;
    private final DoubleProvider proportionalGainProvider;
    private final DoubleProvider integralGainProvider;
    private final YoDouble zeroAngularVelocityThreshold;
    private final YoDouble zeroLinearAccelerationThreshold;
    private final YoDouble yawRateBiasGain;
    private final double updateDT;
    private double gravityMagnitude = 9.81;
    private final YoBoolean hasBeenInitialized;
    private final ReferenceFrame sensorFrame;
    private final Vector3D rotationUpdate = new Vector3D();
    private final Quaternion quaternionUpdate = new Quaternion();
    private final Vector3D angularVelocityUnbiased = new Vector3D();
    private final Vector3D angularVelocityTerm = new Vector3D();
    private boolean hasDesiredInitialHeading = false;
    private final Vector3D desiredInitialHeading = new Vector3D();
    private final Vector3D m = new Vector3D();
    private final Vector3D mRef = new Vector3D();
    private final Vector3D a = new Vector3D();
    private final Vector3D aRef = new Vector3D();
    private final Vector3D normalPart = new Vector3D();
    private final Vector3D tangentialPart = new Vector3D();

    public YoIMUMahonyFilter(String imuName, String namePrefix, String nameSuffix, double updateDT, ReferenceFrame sensorFrame, YoRegistry parentRegistry) {
        this(imuName, namePrefix, nameSuffix, updateDT, false, sensorFrame, parentRegistry);
    }

    public YoIMUMahonyFilter(String imuName, String namePrefix, String nameSuffix, double updateDT, boolean createYawRateBiasEstimator, ReferenceFrame sensorFrame, YoRegistry parentRegistry) {
        this(imuName, namePrefix, nameSuffix, updateDT, createYawRateBiasEstimator, sensorFrame, (DoubleProvider)null, (DoubleProvider)null, parentRegistry);
    }

    public YoIMUMahonyFilter(String imuName, String namePrefix, String nameSuffix, double updateDT, boolean createYawRateBiasEstimator, ReferenceFrame sensorFrame, DoubleProvider proportionalGain, DoubleProvider integralGain, YoRegistry parentRegistry) {
        this(imuName, namePrefix, nameSuffix, updateDT, createYawRateBiasEstimator, sensorFrame, null, null, proportionalGain, integralGain, parentRegistry);
    }

    public YoIMUMahonyFilter(String imuName, String namePrefix, String nameSuffix, double updateDT, ReferenceFrame sensorFrame, YoFrameQuaternion estimatedOrientation, YoFrameVector3D estimatedAngularVelocity, YoRegistry parentRegistry) {
        this(imuName, namePrefix, nameSuffix, updateDT, false, sensorFrame, estimatedOrientation, estimatedAngularVelocity, parentRegistry);
    }

    public YoIMUMahonyFilter(String imuName, String namePrefix, String nameSuffix, double updateDT, boolean createYawRateBiasEstimator, ReferenceFrame sensorFrame, YoFrameQuaternion estimatedOrientation, YoFrameVector3D estimatedAngularVelocity, YoRegistry parentRegistry) {
        this(imuName, namePrefix, nameSuffix, updateDT, createYawRateBiasEstimator, sensorFrame, estimatedOrientation, estimatedAngularVelocity, null, null, parentRegistry);
    }

    public YoIMUMahonyFilter(String imuName, String namePrefix, String nameSuffix, double updateDT, boolean createYawRateBiasEstimator, ReferenceFrame sensorFrame, YoFrameQuaternion estimatedOrientation, YoFrameVector3D estimatedAngularVelocity, DoubleProvider proportionalGain, DoubleProvider integralGain, YoRegistry parentRegistry) {
        this.updateDT = updateDT;
        this.sensorFrame = sensorFrame;
        YoRegistry registry = new YoRegistry(imuName + "MahonyFilter");
        parentRegistry.addChild(registry);
        if (estimatedOrientation != null) {
            estimatedOrientation.checkReferenceFrameMatch(sensorFrame.getRootFrame());
        } else {
            estimatedOrientation = new YoFrameQuaternion(namePrefix, nameSuffix, sensorFrame.getRootFrame(), registry);
        }
        if (estimatedAngularVelocity != null) {
            estimatedAngularVelocity.checkReferenceFrameMatch(sensorFrame);
        } else {
            estimatedAngularVelocity = new YoFrameVector3D(namePrefix, nameSuffix, sensorFrame, registry);
        }
        this.estimatedOrientation = estimatedOrientation;
        this.estimatedAngularVelocity = estimatedAngularVelocity;
        this.orientationError = new YoFrameVector3D(namePrefix + "OrientationError", nameSuffix, sensorFrame, registry);
        this.angularVelocityBias = new YoFrameVector3D(namePrefix + "AngularVelocityBias", nameSuffix, sensorFrame, registry);
        if (proportionalGain == null) {
            this.proportionalGain = new YoDouble(namePrefix + "ProportionalGain" + nameSuffix, registry);
            this.proportionalGainProvider = this.proportionalGain;
        } else {
            this.proportionalGain = proportionalGain instanceof YoDouble ? (YoDouble)proportionalGain : null;
            this.proportionalGainProvider = proportionalGain;
        }
        if (integralGain == null) {
            this.integralGain = new YoDouble(namePrefix + "IntegralGain" + nameSuffix, registry);
            this.integralGainProvider = this.integralGain;
        } else {
            this.integralGain = integralGain instanceof YoDouble ? (YoDouble)integralGain : null;
            this.integralGainProvider = integralGain;
        }
        this.zeroLinearAccelerationThreshold = new YoDouble(namePrefix + "ZeroLinearAccelerationThreshold" + nameSuffix, registry);
        if (createYawRateBiasEstimator) {
            this.zeroAngularVelocityThreshold = new YoDouble(namePrefix + "ZeroAngularVelocityThreshold" + nameSuffix, registry);
            this.yawRateBiasGain = new YoDouble(namePrefix + "YawRateBiasGain" + nameSuffix, registry);
        } else {
            this.zeroAngularVelocityThreshold = null;
            this.yawRateBiasGain = null;
        }
        this.hasBeenInitialized = new YoBoolean(namePrefix + "HasBeenInitialized" + nameSuffix, registry);
    }

    public void setInputs(YoFrameVector3D inputAngularVelocity, YoFrameVector3D inputLinearAcceleration) {
        this.setInputs(inputAngularVelocity, inputLinearAcceleration, null);
    }

    public void setInputs(YoFrameVector3D inputAngularVelocity, YoFrameVector3D inputLinearAcceleration, YoFrameVector3D inputMagneticVector) {
        if (inputAngularVelocity != null) {
            inputAngularVelocity.checkReferenceFrameMatch(this.sensorFrame);
        }
        if (inputLinearAcceleration != null) {
            inputLinearAcceleration.checkReferenceFrameMatch(this.sensorFrame);
        }
        if (inputMagneticVector != null) {
            inputMagneticVector.checkReferenceFrameMatch(this.sensorFrame);
        }
        this.rawAngularVelocity = inputAngularVelocity;
        this.rawLinearAcceleration = inputLinearAcceleration;
        this.rawMagneticVector = inputMagneticVector;
    }

    public void setGains(double proportionalGain, double integralGain) {
        this.proportionalGain.set(proportionalGain);
        this.integralGain.set(integralGain);
    }

    public void setGains(double proportionalGain, double integralGain, double zeroLinearAccelerationThreshold) {
        this.proportionalGain.set(proportionalGain);
        this.integralGain.set(integralGain);
        this.zeroLinearAccelerationThreshold.set(zeroLinearAccelerationThreshold);
    }

    public void setGravityMagnitude(double gravityMagnitude) {
        this.gravityMagnitude = gravityMagnitude;
    }

    public void setYawDriftParameters(double zeroAngularVelocityThreshold, double gain) {
        this.zeroAngularVelocityThreshold.set(zeroAngularVelocityThreshold);
        this.yawRateBiasGain.set(gain);
    }

    public void setHasBeenInitialized(boolean value) {
        this.hasBeenInitialized.set(value);
    }

    public void update() {
        YoFrameVector3D inputAngularVelocity = this.rawAngularVelocity;
        YoFrameVector3D inputLinearAcceleration = this.rawLinearAcceleration;
        YoFrameVector3D inputMagneticVector = this.rawMagneticVector;
        if (inputMagneticVector != null) {
            this.update((Vector3DReadOnly)inputAngularVelocity, (Vector3DReadOnly)inputLinearAcceleration, (Vector3DReadOnly)inputMagneticVector);
        } else {
            this.update((Vector3DReadOnly)inputAngularVelocity, (Vector3DReadOnly)inputLinearAcceleration);
        }
    }

    public void update(FrameVector3DReadOnly inputAngularVelocity, FrameVector3DReadOnly inputLinearAcceleration) {
        this.update(inputAngularVelocity, inputLinearAcceleration, null);
    }

    public void update(FrameVector3DReadOnly inputAngularVelocity, FrameVector3DReadOnly inputLinearAcceleration, FrameVector3DReadOnly inputMagneticVector) {
        inputAngularVelocity.checkReferenceFrameMatch(this.sensorFrame);
        inputLinearAcceleration.checkReferenceFrameMatch(this.sensorFrame);
        if (inputMagneticVector != null) {
            inputMagneticVector.checkReferenceFrameMatch(this.sensorFrame);
        }
        this.update((Vector3DReadOnly)inputAngularVelocity, (Vector3DReadOnly)inputLinearAcceleration, (Vector3DReadOnly)inputMagneticVector);
    }

    public void update(Vector3DReadOnly inputAngularVelocity, Vector3DReadOnly inputLinearAcceleration) {
        this.update(inputAngularVelocity, inputLinearAcceleration, null);
    }

    public void update(Vector3DReadOnly inputAngularVelocity, Vector3DReadOnly inputLinearAcceleration, Vector3DReadOnly inputMagneticVector) {
        if (!this.hasBeenInitialized.getValue()) {
            this.initialize(inputLinearAcceleration, inputMagneticVector);
            return;
        }
        boolean success = this.computeOrientationError((QuaternionReadOnly)this.estimatedOrientation, inputLinearAcceleration, inputMagneticVector, (Vector3DBasics)this.orientationError);
        if (success) {
            this.angularVelocityTerm.scaleAdd(this.proportionalGainProvider.getValue(), (Tuple3DReadOnly)this.orientationError, (Tuple3DReadOnly)inputAngularVelocity);
            boolean hasIntegralTerm = this.updateIntegralTerm((Vector3DBasics)this.angularVelocityBias, inputMagneticVector != null, (Orientation3DReadOnly)this.estimatedOrientation, inputAngularVelocity, inputLinearAcceleration, (Vector3DReadOnly)this.orientationError);
            if (hasIntegralTerm) {
                this.angularVelocityTerm.add((Tuple3DReadOnly)this.angularVelocityBias);
            }
            this.angularVelocityUnbiased.add((Tuple3DReadOnly)inputAngularVelocity, (Tuple3DReadOnly)this.angularVelocityBias);
        } else {
            this.orientationError.setToZero();
            this.angularVelocityTerm.set((Tuple3DReadOnly)inputAngularVelocity);
            this.angularVelocityUnbiased.set((Tuple3DReadOnly)inputAngularVelocity);
        }
        this.rotationUpdate.setAndScale(this.updateDT, (Tuple3DReadOnly)this.angularVelocityTerm);
        this.quaternionUpdate.setRotationVector((Vector3DReadOnly)this.rotationUpdate);
        this.estimatedOrientation.multiply((QuaternionReadOnly)this.quaternionUpdate);
        if (this.estimatedAngularVelocity != null) {
            this.estimatedAngularVelocity.set((Tuple3DReadOnly)this.angularVelocityUnbiased);
        }
    }

    public void reset() {
        this.hasBeenInitialized.set(false);
    }

    public void setDesiredInitialHeading(Vector3DReadOnly desiredInitialHeading) {
        this.desiredInitialHeading.set((Tuple3DReadOnly)desiredInitialHeading);
        this.hasDesiredInitialHeading = true;
    }

    public void initialize(Orientation3DReadOnly initialOrientation) {
        this.estimatedOrientation.set(initialOrientation);
        this.angularVelocityBias.setToZero();
        this.hasBeenInitialized.set(true);
    }

    private void initialize(Vector3DReadOnly acceleration, Vector3DReadOnly magneticVector) {
        boolean success;
        if (magneticVector == null && this.hasDesiredInitialHeading) {
            magneticVector = this.desiredInitialHeading;
        }
        if (!(success = YoIMUMahonyFilter.computeRotationMatrixFromXZAxes(magneticVector, acceleration, (Orientation3DBasics)this.estimatedOrientation))) {
            this.estimatedOrientation.setToZero();
        } else {
            this.estimatedOrientation.invert();
        }
        this.angularVelocityBias.setToZero();
        this.hasBeenInitialized.set(true);
    }

    private boolean updateIntegralTerm(Vector3DBasics integralTerm, boolean hasMagneticVector, Orientation3DReadOnly orientation, Vector3DReadOnly angularVelocity, Vector3DReadOnly linearAcceleration, Vector3DReadOnly errorTerm) {
        if (!Double.isFinite(this.integralGainProvider.getValue()) || this.integralGainProvider.getValue() <= 0.0) {
            integralTerm.setToZero();
            return false;
        }
        orientation.inverseTransform((Tuple3DReadOnly)ACCELERATION_REFERENCE, (Tuple3DBasics)this.aRef);
        this.a.setAndScale(this.gravityMagnitude, (Tuple3DReadOnly)this.aRef);
        this.a.sub((Tuple3DReadOnly)linearAcceleration, (Tuple3DReadOnly)this.a);
        if (this.zeroLinearAccelerationThreshold.getValue() > 0.0 && this.a.lengthSquared() > MathTools.square((double)this.zeroLinearAccelerationThreshold.getValue())) {
            return true;
        }
        integralTerm.scaleAdd(this.integralGainProvider.getValue() * this.updateDT, (Tuple3DReadOnly)errorTerm, (Tuple3DReadOnly)integralTerm);
        if (hasMagneticVector) {
            return true;
        }
        if (this.yawRateBiasGain != null) {
            if (angularVelocity.lengthSquared() > MathTools.square((double)this.zeroAngularVelocityThreshold.getValue())) {
                return true;
            }
            double normalPartMagnitude = TupleTools.dot((Tuple3DReadOnly)this.aRef, (Tuple3DReadOnly)integralTerm);
            if (Double.isFinite(normalPartMagnitude) && normalPartMagnitude != 0.0) {
                this.normalPart.setAndScale(normalPartMagnitude, (Tuple3DReadOnly)this.aRef);
                this.tangentialPart.sub((Tuple3DReadOnly)integralTerm, (Tuple3DReadOnly)this.normalPart);
                double yawRateError = -angularVelocity.dot((Tuple3DReadOnly)this.aRef);
                double ajustedNormalMagnitude = EuclidCoreTools.interpolate((double)normalPartMagnitude, (double)yawRateError, (double)this.yawRateBiasGain.getValue());
                this.normalPart.scale(ajustedNormalMagnitude / normalPartMagnitude);
                integralTerm.add((Tuple3DReadOnly)this.normalPart, (Tuple3DReadOnly)this.tangentialPart);
            }
        } else {
            double normalPartMagnitude = TupleTools.dot((Tuple3DReadOnly)this.aRef, (Tuple3DReadOnly)integralTerm);
            if (Double.isFinite(normalPartMagnitude) && normalPartMagnitude != 0.0) {
                this.normalPart.setAndScale(normalPartMagnitude, (Tuple3DReadOnly)this.aRef);
                this.tangentialPart.sub((Tuple3DReadOnly)integralTerm, (Tuple3DReadOnly)this.normalPart);
                this.normalPart.scale(1.0 - this.integralGainProvider.getValue());
                integralTerm.add((Tuple3DReadOnly)this.normalPart, (Tuple3DReadOnly)this.tangentialPart);
            }
        }
        return true;
    }

    private boolean computeOrientationError(QuaternionReadOnly orientation, Vector3DReadOnly acceleration, Vector3DReadOnly magneticVector, Vector3DBasics errorToPack) {
        double norm;
        boolean success = false;
        errorToPack.setToZero();
        if (magneticVector != null && Double.isFinite(norm = magneticVector.length()) && norm >= 1.0E-5) {
            this.m.setAndScale(1.0 / norm, (Tuple3DReadOnly)magneticVector);
            orientation.transform((Tuple3DReadOnly)this.m, (Tuple3DBasics)this.mRef);
            this.mRef.setX(EuclidCoreTools.norm((double)this.mRef.getX(), (double)this.mRef.getY()));
            this.mRef.setY(0.0);
            orientation.inverseTransform((Tuple3DBasics)this.mRef);
            errorToPack.cross((Tuple3DReadOnly)this.m, (Tuple3DReadOnly)this.mRef);
            success = true;
        }
        if (acceleration != null && Double.isFinite(norm = acceleration.length()) && norm >= 1.0E-5) {
            this.a.setAndScale(1.0 / norm, (Tuple3DReadOnly)acceleration);
            orientation.inverseTransform((Tuple3DReadOnly)ACCELERATION_REFERENCE, (Tuple3DBasics)this.aRef);
            double ex = errorToPack.getX();
            double ey = errorToPack.getY();
            double ez = errorToPack.getZ();
            errorToPack.cross((Tuple3DReadOnly)this.a, (Tuple3DReadOnly)this.aRef);
            errorToPack.add(ex, ey, ez);
            success = true;
        }
        return success;
    }

    public YoFrameQuaternion getEstimatedOrientation() {
        return this.estimatedOrientation;
    }

    public YoFrameVector3D getEstimatedAngularVelocity() {
        return this.estimatedAngularVelocity;
    }

    public YoFrameVector3D getErrorTerm() {
        return this.orientationError;
    }

    public YoFrameVector3D getIntegralTerm() {
        return this.angularVelocityBias;
    }

    private static boolean computeRotationMatrixFromXZAxes(Vector3DReadOnly xAxis, Vector3DReadOnly zAxis, Orientation3DBasics orientationToPack) {
        double yAxisZ;
        double yAxisY;
        if (xAxis == null) {
            xAxis = Axis3D.X;
        }
        if (zAxis == null) {
            zAxis = Axis3D.Z;
        }
        double zAxisX = zAxis.getX();
        double zAxisY = zAxis.getY();
        double zAxisZ = zAxis.getZ();
        double length = zAxis.length();
        if (length < 1.0E-5) {
            return false;
        }
        length = 1.0 / length;
        zAxisX *= length;
        zAxisY *= length;
        zAxisZ *= length;
        double yAxisX = zAxisY * xAxis.getZ() - zAxisZ * xAxis.getY();
        double length2 = Math.sqrt(EuclidCoreTools.normSquared((double)yAxisX, (double)(yAxisY = zAxisZ * xAxis.getX() - zAxisX * xAxis.getZ()), (double)(yAxisZ = zAxisX * xAxis.getY() - zAxisY * xAxis.getX())));
        if (length2 < 1.0E-5) {
            return false;
        }
        length2 = 1.0 / length2;
        double xAxisX = (yAxisY *= length2) * zAxisZ - (yAxisZ *= length2) * zAxisY;
        double xAxisY = yAxisZ * zAxisX - (yAxisX *= length2) * zAxisZ;
        double xAxisZ = yAxisX * zAxisY - yAxisY * zAxisX;
        if (orientationToPack instanceof RotationMatrixBasics) {
            ((RotationMatrix)orientationToPack).setUnsafe(xAxisX, yAxisX, zAxisX, xAxisY, yAxisY, zAxisY, xAxisZ, yAxisZ, zAxisZ);
        } else {
            orientationToPack.setRotationMatrix(xAxisX, yAxisX, zAxisX, xAxisY, yAxisY, zAxisY, xAxisZ, yAxisZ, zAxisZ);
        }
        return true;
    }
}

