/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class WeightedAverageYoFrameVector3D
extends YoFrameVector3D {
    private final List<DoubleProvider> booleanWeights = new ArrayList<DoubleProvider>();
    private final List<YoFrameVector3D> frameVectorsToAverage = new ArrayList<YoFrameVector3D>();

    public WeightedAverageYoFrameVector3D(String name, ReferenceFrame referenceFrame, YoRegistry registry) {
        super(name, referenceFrame, registry);
    }

    public void addFrameVector3DToAverage(DoubleProvider booleanWeight, YoFrameVector3D frameVectorToAverage) {
        this.booleanWeights.add(booleanWeight);
        frameVectorToAverage.checkReferenceFrameMatch(this.getReferenceFrame());
        this.frameVectorsToAverage.add(frameVectorToAverage);
    }

    public void update() {
        int numberOfBooleans = this.booleanWeights.size();
        this.setToZero();
        double totalWeight = 0.0;
        for (int i = 0; i < numberOfBooleans; ++i) {
            FrameVector3DReadOnly frameVectorToAverage = (FrameVector3DReadOnly)this.frameVectorsToAverage.get(i);
            double weight = this.booleanWeights.get(i).getValue();
            if (frameVectorToAverage.containsNaN()) continue;
            this.scaleAdd(weight, (FrameTuple3DReadOnly)frameVectorToAverage, (FrameTuple3DReadOnly)this);
            totalWeight += weight;
        }
        if (totalWeight <= 0.0) {
            this.setToZero();
            return;
        }
        this.scale(1.0 / totalWeight);
    }
}

